/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceContributorCount;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.transform.ComplianceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Compliance
implements StructuredPojo,
ToCopyableBuilder<Builder, Compliance> {
    private final String complianceType;
    private final ComplianceContributorCount complianceContributorCount;

    private Compliance(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.complianceContributorCount = builder.complianceContributorCount;
    }

    public String complianceType() {
        return this.complianceType;
    }

    public ComplianceContributorCount complianceContributorCount() {
        return this.complianceContributorCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.complianceType() == null ? 0 : this.complianceType().hashCode());
        hashCode = 31 * hashCode + (this.complianceContributorCount() == null ? 0 : this.complianceContributorCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compliance)) {
            return false;
        }
        Compliance other = (Compliance)obj;
        if (other.complianceType() == null ^ this.complianceType() == null) {
            return false;
        }
        if (other.complianceType() != null && !other.complianceType().equals(this.complianceType())) {
            return false;
        }
        if (other.complianceContributorCount() == null ^ this.complianceContributorCount() == null) {
            return false;
        }
        return other.complianceContributorCount() == null || other.complianceContributorCount().equals(this.complianceContributorCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.complianceType() != null) {
            sb.append("ComplianceType: ").append(this.complianceType()).append(",");
        }
        if (this.complianceContributorCount() != null) {
            sb.append("ComplianceContributorCount: ").append(this.complianceContributorCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String complianceType;
        private ComplianceContributorCount complianceContributorCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Compliance model) {
            this.setComplianceType(model.complianceType);
            this.setComplianceContributorCount(model.complianceContributorCount);
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final void setComplianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
        }

        public final ComplianceContributorCount getComplianceContributorCount() {
            return this.complianceContributorCount;
        }

        @Override
        public final Builder complianceContributorCount(ComplianceContributorCount complianceContributorCount) {
            this.complianceContributorCount = complianceContributorCount;
            return this;
        }

        public final void setComplianceContributorCount(ComplianceContributorCount complianceContributorCount) {
            this.complianceContributorCount = complianceContributorCount;
        }

        public Compliance build() {
            return new Compliance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Compliance> {
        public Builder complianceType(String var1);

        public Builder complianceType(ComplianceType var1);

        public Builder complianceContributorCount(ComplianceContributorCount var1);
    }
}

