/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationAsyncClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationRulePreviewRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationRulePreviewResponse;
import software.amazon.awssdk.services.computeoptimizerautomation.model.PreviewResult;

public class ListAutomationRulePreviewPublisher
implements SdkPublisher<ListAutomationRulePreviewResponse> {
    private final ComputeOptimizerAutomationAsyncClient client;
    private final ListAutomationRulePreviewRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAutomationRulePreviewPublisher(ComputeOptimizerAutomationAsyncClient client, ListAutomationRulePreviewRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAutomationRulePreviewPublisher(ComputeOptimizerAutomationAsyncClient client, ListAutomationRulePreviewRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAutomationRulePreviewResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAutomationRulePreviewResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PreviewResult> previewResults() {
        Function<ListAutomationRulePreviewResponse, Iterator> getIterator = response -> {
            if (response != null && response.previewResults() != null) {
                return response.previewResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAutomationRulePreviewResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAutomationRulePreviewResponseFetcher
    implements AsyncPageFetcher<ListAutomationRulePreviewResponse> {
        private ListAutomationRulePreviewResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomationRulePreviewResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAutomationRulePreviewResponse> nextPage(ListAutomationRulePreviewResponse previousPage) {
            if (previousPage == null) {
                return ListAutomationRulePreviewPublisher.this.client.listAutomationRulePreview(ListAutomationRulePreviewPublisher.this.firstRequest);
            }
            return ListAutomationRulePreviewPublisher.this.client.listAutomationRulePreview((ListAutomationRulePreviewRequest)((Object)ListAutomationRulePreviewPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

