/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizerautomation.model.SummaryDimension;
import software.amazon.awssdk.services.computeoptimizerautomation.model.SummaryDimensionsCopier;
import software.amazon.awssdk.services.computeoptimizerautomation.model.SummaryTotals;
import software.amazon.awssdk.services.computeoptimizerautomation.model.TimePeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationEventSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationEventSummary> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(AutomationEventSummary.getter(AutomationEventSummary::key)).setter(AutomationEventSummary.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<List<SummaryDimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dimensions").getter(AutomationEventSummary.getter(AutomationEventSummary::dimensions)).setter(AutomationEventSummary.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SummaryDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimePeriod> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timePeriod").getter(AutomationEventSummary.getter(AutomationEventSummary::timePeriod)).setter(AutomationEventSummary.setter(Builder::timePeriod)).constructor(TimePeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timePeriod").build()}).build();
    private static final SdkField<SummaryTotals> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("total").getter(AutomationEventSummary.getter(AutomationEventSummary::total)).setter(AutomationEventSummary.setter(Builder::total)).constructor(SummaryTotals::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, DIMENSIONS_FIELD, TIME_PERIOD_FIELD, TOTAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomationEventSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String key;
    private final List<SummaryDimension> dimensions;
    private final TimePeriod timePeriod;
    private final SummaryTotals total;

    private AutomationEventSummary(BuilderImpl builder) {
        this.key = builder.key;
        this.dimensions = builder.dimensions;
        this.timePeriod = builder.timePeriod;
        this.total = builder.total;
    }

    public final String key() {
        return this.key;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<SummaryDimension> dimensions() {
        return this.dimensions;
    }

    public final TimePeriod timePeriod() {
        return this.timePeriod;
    }

    public final SummaryTotals total() {
        return this.total;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationEventSummary)) {
            return false;
        }
        AutomationEventSummary other = (AutomationEventSummary)obj;
        return Objects.equals(this.key(), other.key()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.total(), other.total());
    }

    public final String toString() {
        return ToString.builder((String)"AutomationEventSummary").add("Key", (Object)this.key()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("TimePeriod", (Object)this.timePeriod()).add("Total", (Object)this.total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "timePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", KEY_FIELD);
        map.put("dimensions", DIMENSIONS_FIELD);
        map.put("timePeriod", TIME_PERIOD_FIELD);
        map.put("total", TOTAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomationEventSummary, T> g) {
        return obj -> g.apply((AutomationEventSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private List<SummaryDimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private TimePeriod timePeriod;
        private SummaryTotals total;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationEventSummary model) {
            this.key(model.key);
            this.dimensions(model.dimensions);
            this.timePeriod(model.timePeriod);
            this.total(model.total);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final List<SummaryDimension.Builder> getDimensions() {
            List<SummaryDimension.Builder> result = SummaryDimensionsCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<SummaryDimension.BuilderImpl> dimensions) {
            this.dimensions = SummaryDimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<SummaryDimension> dimensions) {
            this.dimensions = SummaryDimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(SummaryDimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<SummaryDimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (SummaryDimension)((SummaryDimension.Builder)SummaryDimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TimePeriod.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(TimePeriod.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final SummaryTotals.Builder getTotal() {
            return this.total != null ? this.total.toBuilder() : null;
        }

        public final void setTotal(SummaryTotals.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        public final Builder total(SummaryTotals total) {
            this.total = total;
            return this;
        }

        public AutomationEventSummary build() {
            return new AutomationEventSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationEventSummary> {
        public Builder key(String var1);

        public Builder dimensions(Collection<SummaryDimension> var1);

        public Builder dimensions(SummaryDimension ... var1);

        public Builder dimensions(Consumer<SummaryDimension.Builder> ... var1);

        public Builder timePeriod(TimePeriod var1);

        default public Builder timePeriod(Consumer<TimePeriod.Builder> timePeriod) {
            return this.timePeriod((TimePeriod)((TimePeriod.Builder)TimePeriod.builder().applyMutation(timePeriod)).build());
        }

        public Builder total(SummaryTotals var1);

        default public Builder total(Consumer<SummaryTotals.Builder> total) {
            return this.total((SummaryTotals)((SummaryTotals.Builder)SummaryTotals.builder().applyMutation(total)).build());
        }
    }
}

