/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizerautomation.model.EstimatedMonthlySavings;
import software.amazon.awssdk.services.computeoptimizerautomation.model.RecommendedActionType;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ResourceDetails;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ResourceType;
import software.amazon.awssdk.services.computeoptimizerautomation.model.Tag;
import software.amazon.awssdk.services.computeoptimizerautomation.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PreviewResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PreviewResult> {
    private static final SdkField<String> RECOMMENDED_ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendedActionId").getter(PreviewResult.getter(PreviewResult::recommendedActionId)).setter(PreviewResult.setter(Builder::recommendedActionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedActionId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(PreviewResult.getter(PreviewResult::resourceArn)).setter(PreviewResult.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(PreviewResult.getter(PreviewResult::resourceId)).setter(PreviewResult.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(PreviewResult.getter(PreviewResult::accountId)).setter(PreviewResult.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(PreviewResult.getter(PreviewResult::region)).setter(PreviewResult.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(PreviewResult.getter(PreviewResult::resourceTypeAsString)).setter(PreviewResult.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<Integer> LOOK_BACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("lookBackPeriodInDays").getter(PreviewResult.getter(PreviewResult::lookBackPeriodInDays)).setter(PreviewResult.setter(Builder::lookBackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookBackPeriodInDays").build()}).build();
    private static final SdkField<String> RECOMMENDED_ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendedActionType").getter(PreviewResult.getter(PreviewResult::recommendedActionTypeAsString)).setter(PreviewResult.setter(Builder::recommendedActionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedActionType").build()}).build();
    private static final SdkField<String> CURRENT_RESOURCE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentResourceSummary").getter(PreviewResult.getter(PreviewResult::currentResourceSummary)).setter(PreviewResult.setter(Builder::currentResourceSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentResourceSummary").build()}).build();
    private static final SdkField<ResourceDetails> CURRENT_RESOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentResourceDetails").getter(PreviewResult.getter(PreviewResult::currentResourceDetails)).setter(PreviewResult.setter(Builder::currentResourceDetails)).constructor(ResourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentResourceDetails").build()}).build();
    private static final SdkField<String> RECOMMENDED_RESOURCE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendedResourceSummary").getter(PreviewResult.getter(PreviewResult::recommendedResourceSummary)).setter(PreviewResult.setter(Builder::recommendedResourceSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedResourceSummary").build()}).build();
    private static final SdkField<ResourceDetails> RECOMMENDED_RESOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recommendedResourceDetails").getter(PreviewResult.getter(PreviewResult::recommendedResourceDetails)).setter(PreviewResult.setter(Builder::recommendedResourceDetails)).constructor(ResourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedResourceDetails").build()}).build();
    private static final SdkField<Boolean> RESTART_NEEDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("restartNeeded").getter(PreviewResult.getter(PreviewResult::restartNeeded)).setter(PreviewResult.setter(Builder::restartNeeded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartNeeded").build()}).build();
    private static final SdkField<EstimatedMonthlySavings> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("estimatedMonthlySavings").getter(PreviewResult.getter(PreviewResult::estimatedMonthlySavings)).setter(PreviewResult.setter(Builder::estimatedMonthlySavings)).constructor(EstimatedMonthlySavings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlySavings").build()}).build();
    private static final SdkField<List<Tag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceTags").getter(PreviewResult.getter(PreviewResult::resourceTags)).setter(PreviewResult.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDED_ACTION_ID_FIELD, RESOURCE_ARN_FIELD, RESOURCE_ID_FIELD, ACCOUNT_ID_FIELD, REGION_FIELD, RESOURCE_TYPE_FIELD, LOOK_BACK_PERIOD_IN_DAYS_FIELD, RECOMMENDED_ACTION_TYPE_FIELD, CURRENT_RESOURCE_SUMMARY_FIELD, CURRENT_RESOURCE_DETAILS_FIELD, RECOMMENDED_RESOURCE_SUMMARY_FIELD, RECOMMENDED_RESOURCE_DETAILS_FIELD, RESTART_NEEDED_FIELD, ESTIMATED_MONTHLY_SAVINGS_FIELD, RESOURCE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PreviewResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String recommendedActionId;
    private final String resourceArn;
    private final String resourceId;
    private final String accountId;
    private final String region;
    private final String resourceType;
    private final Integer lookBackPeriodInDays;
    private final String recommendedActionType;
    private final String currentResourceSummary;
    private final ResourceDetails currentResourceDetails;
    private final String recommendedResourceSummary;
    private final ResourceDetails recommendedResourceDetails;
    private final Boolean restartNeeded;
    private final EstimatedMonthlySavings estimatedMonthlySavings;
    private final List<Tag> resourceTags;

    private PreviewResult(BuilderImpl builder) {
        this.recommendedActionId = builder.recommendedActionId;
        this.resourceArn = builder.resourceArn;
        this.resourceId = builder.resourceId;
        this.accountId = builder.accountId;
        this.region = builder.region;
        this.resourceType = builder.resourceType;
        this.lookBackPeriodInDays = builder.lookBackPeriodInDays;
        this.recommendedActionType = builder.recommendedActionType;
        this.currentResourceSummary = builder.currentResourceSummary;
        this.currentResourceDetails = builder.currentResourceDetails;
        this.recommendedResourceSummary = builder.recommendedResourceSummary;
        this.recommendedResourceDetails = builder.recommendedResourceDetails;
        this.restartNeeded = builder.restartNeeded;
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
        this.resourceTags = builder.resourceTags;
    }

    public final String recommendedActionId() {
        return this.recommendedActionId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String region() {
        return this.region;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final Integer lookBackPeriodInDays() {
        return this.lookBackPeriodInDays;
    }

    public final RecommendedActionType recommendedActionType() {
        return RecommendedActionType.fromValue(this.recommendedActionType);
    }

    public final String recommendedActionTypeAsString() {
        return this.recommendedActionType;
    }

    public final String currentResourceSummary() {
        return this.currentResourceSummary;
    }

    public final ResourceDetails currentResourceDetails() {
        return this.currentResourceDetails;
    }

    public final String recommendedResourceSummary() {
        return this.recommendedResourceSummary;
    }

    public final ResourceDetails recommendedResourceDetails() {
        return this.recommendedResourceDetails;
    }

    public final Boolean restartNeeded() {
        return this.restartNeeded;
    }

    public final EstimatedMonthlySavings estimatedMonthlySavings() {
        return this.estimatedMonthlySavings;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> resourceTags() {
        return this.resourceTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedActionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookBackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentResourceSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentResourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedResourceSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedResourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.restartNeeded());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlySavings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreviewResult)) {
            return false;
        }
        PreviewResult other = (PreviewResult)obj;
        return Objects.equals(this.recommendedActionId(), other.recommendedActionId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.lookBackPeriodInDays(), other.lookBackPeriodInDays()) && Objects.equals(this.recommendedActionTypeAsString(), other.recommendedActionTypeAsString()) && Objects.equals(this.currentResourceSummary(), other.currentResourceSummary()) && Objects.equals(this.currentResourceDetails(), other.currentResourceDetails()) && Objects.equals(this.recommendedResourceSummary(), other.recommendedResourceSummary()) && Objects.equals(this.recommendedResourceDetails(), other.recommendedResourceDetails()) && Objects.equals(this.restartNeeded(), other.restartNeeded()) && Objects.equals(this.estimatedMonthlySavings(), other.estimatedMonthlySavings()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags());
    }

    public final String toString() {
        return ToString.builder((String)"PreviewResult").add("RecommendedActionId", (Object)this.recommendedActionId()).add("ResourceArn", (Object)this.resourceArn()).add("ResourceId", (Object)this.resourceId()).add("AccountId", (Object)this.accountId()).add("Region", (Object)this.region()).add("ResourceType", (Object)this.resourceTypeAsString()).add("LookBackPeriodInDays", (Object)this.lookBackPeriodInDays()).add("RecommendedActionType", (Object)this.recommendedActionTypeAsString()).add("CurrentResourceSummary", (Object)this.currentResourceSummary()).add("CurrentResourceDetails", (Object)this.currentResourceDetails()).add("RecommendedResourceSummary", (Object)this.recommendedResourceSummary()).add("RecommendedResourceDetails", (Object)this.recommendedResourceDetails()).add("RestartNeeded", (Object)this.restartNeeded()).add("EstimatedMonthlySavings", (Object)this.estimatedMonthlySavings()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recommendedActionId": {
                return Optional.ofNullable(clazz.cast(this.recommendedActionId()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "lookBackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookBackPeriodInDays()));
            }
            case "recommendedActionType": {
                return Optional.ofNullable(clazz.cast(this.recommendedActionTypeAsString()));
            }
            case "currentResourceSummary": {
                return Optional.ofNullable(clazz.cast(this.currentResourceSummary()));
            }
            case "currentResourceDetails": {
                return Optional.ofNullable(clazz.cast(this.currentResourceDetails()));
            }
            case "recommendedResourceSummary": {
                return Optional.ofNullable(clazz.cast(this.recommendedResourceSummary()));
            }
            case "recommendedResourceDetails": {
                return Optional.ofNullable(clazz.cast(this.recommendedResourceDetails()));
            }
            case "restartNeeded": {
                return Optional.ofNullable(clazz.cast(this.restartNeeded()));
            }
            case "estimatedMonthlySavings": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlySavings()));
            }
            case "resourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recommendedActionId", RECOMMENDED_ACTION_ID_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("region", REGION_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("lookBackPeriodInDays", LOOK_BACK_PERIOD_IN_DAYS_FIELD);
        map.put("recommendedActionType", RECOMMENDED_ACTION_TYPE_FIELD);
        map.put("currentResourceSummary", CURRENT_RESOURCE_SUMMARY_FIELD);
        map.put("currentResourceDetails", CURRENT_RESOURCE_DETAILS_FIELD);
        map.put("recommendedResourceSummary", RECOMMENDED_RESOURCE_SUMMARY_FIELD);
        map.put("recommendedResourceDetails", RECOMMENDED_RESOURCE_DETAILS_FIELD);
        map.put("restartNeeded", RESTART_NEEDED_FIELD);
        map.put("estimatedMonthlySavings", ESTIMATED_MONTHLY_SAVINGS_FIELD);
        map.put("resourceTags", RESOURCE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PreviewResult, T> g) {
        return obj -> g.apply((PreviewResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recommendedActionId;
        private String resourceArn;
        private String resourceId;
        private String accountId;
        private String region;
        private String resourceType;
        private Integer lookBackPeriodInDays;
        private String recommendedActionType;
        private String currentResourceSummary;
        private ResourceDetails currentResourceDetails;
        private String recommendedResourceSummary;
        private ResourceDetails recommendedResourceDetails;
        private Boolean restartNeeded;
        private EstimatedMonthlySavings estimatedMonthlySavings;
        private List<Tag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PreviewResult model) {
            this.recommendedActionId(model.recommendedActionId);
            this.resourceArn(model.resourceArn);
            this.resourceId(model.resourceId);
            this.accountId(model.accountId);
            this.region(model.region);
            this.resourceType(model.resourceType);
            this.lookBackPeriodInDays(model.lookBackPeriodInDays);
            this.recommendedActionType(model.recommendedActionType);
            this.currentResourceSummary(model.currentResourceSummary);
            this.currentResourceDetails(model.currentResourceDetails);
            this.recommendedResourceSummary(model.recommendedResourceSummary);
            this.recommendedResourceDetails(model.recommendedResourceDetails);
            this.restartNeeded(model.restartNeeded);
            this.estimatedMonthlySavings(model.estimatedMonthlySavings);
            this.resourceTags(model.resourceTags);
        }

        public final String getRecommendedActionId() {
            return this.recommendedActionId;
        }

        public final void setRecommendedActionId(String recommendedActionId) {
            this.recommendedActionId = recommendedActionId;
        }

        @Override
        public final Builder recommendedActionId(String recommendedActionId) {
            this.recommendedActionId = recommendedActionId;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Integer getLookBackPeriodInDays() {
            return this.lookBackPeriodInDays;
        }

        public final void setLookBackPeriodInDays(Integer lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
        }

        @Override
        public final Builder lookBackPeriodInDays(Integer lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
            return this;
        }

        public final String getRecommendedActionType() {
            return this.recommendedActionType;
        }

        public final void setRecommendedActionType(String recommendedActionType) {
            this.recommendedActionType = recommendedActionType;
        }

        @Override
        public final Builder recommendedActionType(String recommendedActionType) {
            this.recommendedActionType = recommendedActionType;
            return this;
        }

        @Override
        public final Builder recommendedActionType(RecommendedActionType recommendedActionType) {
            this.recommendedActionType(recommendedActionType == null ? null : recommendedActionType.toString());
            return this;
        }

        public final String getCurrentResourceSummary() {
            return this.currentResourceSummary;
        }

        public final void setCurrentResourceSummary(String currentResourceSummary) {
            this.currentResourceSummary = currentResourceSummary;
        }

        @Override
        public final Builder currentResourceSummary(String currentResourceSummary) {
            this.currentResourceSummary = currentResourceSummary;
            return this;
        }

        public final ResourceDetails.Builder getCurrentResourceDetails() {
            return this.currentResourceDetails != null ? this.currentResourceDetails.toBuilder() : null;
        }

        public final void setCurrentResourceDetails(ResourceDetails.BuilderImpl currentResourceDetails) {
            this.currentResourceDetails = currentResourceDetails != null ? currentResourceDetails.build() : null;
        }

        @Override
        public final Builder currentResourceDetails(ResourceDetails currentResourceDetails) {
            this.currentResourceDetails = currentResourceDetails;
            return this;
        }

        public final String getRecommendedResourceSummary() {
            return this.recommendedResourceSummary;
        }

        public final void setRecommendedResourceSummary(String recommendedResourceSummary) {
            this.recommendedResourceSummary = recommendedResourceSummary;
        }

        @Override
        public final Builder recommendedResourceSummary(String recommendedResourceSummary) {
            this.recommendedResourceSummary = recommendedResourceSummary;
            return this;
        }

        public final ResourceDetails.Builder getRecommendedResourceDetails() {
            return this.recommendedResourceDetails != null ? this.recommendedResourceDetails.toBuilder() : null;
        }

        public final void setRecommendedResourceDetails(ResourceDetails.BuilderImpl recommendedResourceDetails) {
            this.recommendedResourceDetails = recommendedResourceDetails != null ? recommendedResourceDetails.build() : null;
        }

        @Override
        public final Builder recommendedResourceDetails(ResourceDetails recommendedResourceDetails) {
            this.recommendedResourceDetails = recommendedResourceDetails;
            return this;
        }

        public final Boolean getRestartNeeded() {
            return this.restartNeeded;
        }

        public final void setRestartNeeded(Boolean restartNeeded) {
            this.restartNeeded = restartNeeded;
        }

        @Override
        public final Builder restartNeeded(Boolean restartNeeded) {
            this.restartNeeded = restartNeeded;
            return this;
        }

        public final EstimatedMonthlySavings.Builder getEstimatedMonthlySavings() {
            return this.estimatedMonthlySavings != null ? this.estimatedMonthlySavings.toBuilder() : null;
        }

        public final void setEstimatedMonthlySavings(EstimatedMonthlySavings.BuilderImpl estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings != null ? estimatedMonthlySavings.build() : null;
        }

        @Override
        public final Builder estimatedMonthlySavings(EstimatedMonthlySavings estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public final List<Tag.Builder> getResourceTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<Tag.BuilderImpl> resourceTags) {
            this.resourceTags = TagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<Tag> resourceTags) {
            this.resourceTags = TagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Tag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<Tag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PreviewResult build() {
            return new PreviewResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PreviewResult> {
        public Builder recommendedActionId(String var1);

        public Builder resourceArn(String var1);

        public Builder resourceId(String var1);

        public Builder accountId(String var1);

        public Builder region(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder lookBackPeriodInDays(Integer var1);

        public Builder recommendedActionType(String var1);

        public Builder recommendedActionType(RecommendedActionType var1);

        public Builder currentResourceSummary(String var1);

        public Builder currentResourceDetails(ResourceDetails var1);

        default public Builder currentResourceDetails(Consumer<ResourceDetails.Builder> currentResourceDetails) {
            return this.currentResourceDetails((ResourceDetails)((ResourceDetails.Builder)ResourceDetails.builder().applyMutation(currentResourceDetails)).build());
        }

        public Builder recommendedResourceSummary(String var1);

        public Builder recommendedResourceDetails(ResourceDetails var1);

        default public Builder recommendedResourceDetails(Consumer<ResourceDetails.Builder> recommendedResourceDetails) {
            return this.recommendedResourceDetails((ResourceDetails)((ResourceDetails.Builder)ResourceDetails.builder().applyMutation(recommendedResourceDetails)).build());
        }

        public Builder restartNeeded(Boolean var1);

        public Builder estimatedMonthlySavings(EstimatedMonthlySavings var1);

        default public Builder estimatedMonthlySavings(Consumer<EstimatedMonthlySavings.Builder> estimatedMonthlySavings) {
            return this.estimatedMonthlySavings((EstimatedMonthlySavings)((EstimatedMonthlySavings.Builder)EstimatedMonthlySavings.builder().applyMutation(estimatedMonthlySavings)).build());
        }

        public Builder resourceTags(Collection<Tag> var1);

        public Builder resourceTags(Tag ... var1);

        public Builder resourceTags(Consumer<Tag.Builder> ... var1);
    }
}

