/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationEventSummary;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationEventSummariesRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationEventSummariesResponse;

public class ListAutomationEventSummariesIterable
implements SdkIterable<ListAutomationEventSummariesResponse> {
    private final ComputeOptimizerAutomationClient client;
    private final ListAutomationEventSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAutomationEventSummariesIterable(ComputeOptimizerAutomationClient client, ListAutomationEventSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAutomationEventSummariesResponseFetcher();
    }

    public Iterator<ListAutomationEventSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutomationEventSummary> automationEventSummaries() {
        Function<ListAutomationEventSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.automationEventSummaries() != null) {
                return response.automationEventSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAutomationEventSummariesResponseFetcher
    implements SyncPageFetcher<ListAutomationEventSummariesResponse> {
        private ListAutomationEventSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomationEventSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAutomationEventSummariesResponse nextPage(ListAutomationEventSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListAutomationEventSummariesIterable.this.client.listAutomationEventSummaries(ListAutomationEventSummariesIterable.this.firstRequest);
            }
            return ListAutomationEventSummariesIterable.this.client.listAutomationEventSummaries((ListAutomationEventSummariesRequest)((Object)ListAutomationEventSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

