/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of a recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Summary implements SdkPojo, Serializable, ToCopyableBuilder<Summary.Builder, Summary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Summary::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("value")
            .getter(getter(Summary::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<List<ReasonCodeSummary>> REASON_CODE_SUMMARIES_FIELD = SdkField
            .<List<ReasonCodeSummary>> builder(MarshallingType.LIST)
            .memberName("reasonCodeSummaries")
            .getter(getter(Summary::reasonCodeSummaries))
            .setter(setter(Builder::reasonCodeSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasonCodeSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReasonCodeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReasonCodeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD,
            REASON_CODE_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Double value;

    private final List<ReasonCodeSummary> reasonCodeSummaries;

    private Summary(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.reasonCodeSummaries = builder.reasonCodeSummaries;
    }

    /**
     * <p>
     * The finding classification of the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link Finding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The finding classification of the recommendation.
     * @see Finding
     */
    public final Finding name() {
        return Finding.fromValue(name);
    }

    /**
     * <p>
     * The finding classification of the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link Finding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The finding classification of the recommendation.
     * @see Finding
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The value of the recommendation summary.
     * </p>
     * 
     * @return The value of the recommendation summary.
     */
    public final Double value() {
        return value;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReasonCodeSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReasonCodeSummaries() {
        return reasonCodeSummaries != null && !(reasonCodeSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that summarize a finding reason code.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReasonCodeSummaries} method.
     * </p>
     * 
     * @return An array of objects that summarize a finding reason code.
     */
    public final List<ReasonCodeSummary> reasonCodeSummaries() {
        return reasonCodeSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(hasReasonCodeSummaries() ? reasonCodeSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Summary)) {
            return false;
        }
        Summary other = (Summary) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(value(), other.value())
                && hasReasonCodeSummaries() == other.hasReasonCodeSummaries()
                && Objects.equals(reasonCodeSummaries(), other.reasonCodeSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Summary").add("Name", nameAsString()).add("Value", value())
                .add("ReasonCodeSummaries", hasReasonCodeSummaries() ? reasonCodeSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "reasonCodeSummaries":
            return Optional.ofNullable(clazz.cast(reasonCodeSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("reasonCodeSummaries", REASON_CODE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Summary, T> g) {
        return obj -> g.apply((Summary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Summary> {
        /**
         * <p>
         * The finding classification of the recommendation.
         * </p>
         * 
         * @param name
         *        The finding classification of the recommendation.
         * @see Finding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Finding
         */
        Builder name(String name);

        /**
         * <p>
         * The finding classification of the recommendation.
         * </p>
         * 
         * @param name
         *        The finding classification of the recommendation.
         * @see Finding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Finding
         */
        Builder name(Finding name);

        /**
         * <p>
         * The value of the recommendation summary.
         * </p>
         * 
         * @param value
         *        The value of the recommendation summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);

        /**
         * <p>
         * An array of objects that summarize a finding reason code.
         * </p>
         * 
         * @param reasonCodeSummaries
         *        An array of objects that summarize a finding reason code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonCodeSummaries(Collection<ReasonCodeSummary> reasonCodeSummaries);

        /**
         * <p>
         * An array of objects that summarize a finding reason code.
         * </p>
         * 
         * @param reasonCodeSummaries
         *        An array of objects that summarize a finding reason code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonCodeSummaries(ReasonCodeSummary... reasonCodeSummaries);

        /**
         * <p>
         * An array of objects that summarize a finding reason code.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ReasonCodeSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ReasonCodeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ReasonCodeSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #reasonCodeSummaries(List<ReasonCodeSummary>)}.
         * 
         * @param reasonCodeSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.ReasonCodeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reasonCodeSummaries(java.util.Collection<ReasonCodeSummary>)
         */
        Builder reasonCodeSummaries(Consumer<ReasonCodeSummary.Builder>... reasonCodeSummaries);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Double value;

        private List<ReasonCodeSummary> reasonCodeSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Summary model) {
            name(model.name);
            value(model.value);
            reasonCodeSummaries(model.reasonCodeSummaries);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(Finding name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final List<ReasonCodeSummary.Builder> getReasonCodeSummaries() {
            List<ReasonCodeSummary.Builder> result = ReasonCodeSummariesCopier.copyToBuilder(this.reasonCodeSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReasonCodeSummaries(Collection<ReasonCodeSummary.BuilderImpl> reasonCodeSummaries) {
            this.reasonCodeSummaries = ReasonCodeSummariesCopier.copyFromBuilder(reasonCodeSummaries);
        }

        @Override
        public final Builder reasonCodeSummaries(Collection<ReasonCodeSummary> reasonCodeSummaries) {
            this.reasonCodeSummaries = ReasonCodeSummariesCopier.copy(reasonCodeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodeSummaries(ReasonCodeSummary... reasonCodeSummaries) {
            reasonCodeSummaries(Arrays.asList(reasonCodeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodeSummaries(Consumer<ReasonCodeSummary.Builder>... reasonCodeSummaries) {
            reasonCodeSummaries(Stream.of(reasonCodeSummaries).map(c -> ReasonCodeSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Summary build() {
            return new Summary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
