/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecommendationPreferencesResponse extends ComputeOptimizerResponse implements
        ToCopyableBuilder<GetRecommendationPreferencesResponse.Builder, GetRecommendationPreferencesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetRecommendationPreferencesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<RecommendationPreferencesDetail>> RECOMMENDATION_PREFERENCES_DETAILS_FIELD = SdkField
            .<List<RecommendationPreferencesDetail>> builder(MarshallingType.LIST)
            .memberName("recommendationPreferencesDetails")
            .getter(getter(GetRecommendationPreferencesResponse::recommendationPreferencesDetails))
            .setter(setter(Builder::recommendationPreferencesDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationPreferencesDetails")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationPreferencesDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationPreferencesDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RECOMMENDATION_PREFERENCES_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<RecommendationPreferencesDetail> recommendationPreferencesDetails;

    private GetRecommendationPreferencesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.recommendationPreferencesDetails = builder.recommendationPreferencesDetails;
    }

    /**
     * <p>
     * The token to use to advance to the next page of recommendation preferences.
     * </p>
     * <p>
     * This value is null when there are no more pages of recommendation preferences to return.
     * </p>
     * 
     * @return The token to use to advance to the next page of recommendation preferences.</p>
     *         <p>
     *         This value is null when there are no more pages of recommendation preferences to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendationPreferencesDetails
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasRecommendationPreferencesDetails() {
        return recommendationPreferencesDetails != null && !(recommendationPreferencesDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe recommendation preferences.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendationPreferencesDetails}
     * method.
     * </p>
     * 
     * @return An array of objects that describe recommendation preferences.
     */
    public final List<RecommendationPreferencesDetail> recommendationPreferencesDetails() {
        return recommendationPreferencesDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRecommendationPreferencesDetails() ? recommendationPreferencesDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationPreferencesResponse)) {
            return false;
        }
        GetRecommendationPreferencesResponse other = (GetRecommendationPreferencesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasRecommendationPreferencesDetails() == other.hasRecommendationPreferencesDetails()
                && Objects.equals(recommendationPreferencesDetails(), other.recommendationPreferencesDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetRecommendationPreferencesResponse")
                .add("NextToken", nextToken())
                .add("RecommendationPreferencesDetails",
                        hasRecommendationPreferencesDetails() ? recommendationPreferencesDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "recommendationPreferencesDetails":
            return Optional.ofNullable(clazz.cast(recommendationPreferencesDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("recommendationPreferencesDetails", RECOMMENDATION_PREFERENCES_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationPreferencesResponse, T> g) {
        return obj -> g.apply((GetRecommendationPreferencesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComputeOptimizerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecommendationPreferencesResponse> {
        /**
         * <p>
         * The token to use to advance to the next page of recommendation preferences.
         * </p>
         * <p>
         * This value is null when there are no more pages of recommendation preferences to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to advance to the next page of recommendation preferences.</p>
         *        <p>
         *        This value is null when there are no more pages of recommendation preferences to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of objects that describe recommendation preferences.
         * </p>
         * 
         * @param recommendationPreferencesDetails
         *        An array of objects that describe recommendation preferences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationPreferencesDetails(Collection<RecommendationPreferencesDetail> recommendationPreferencesDetails);

        /**
         * <p>
         * An array of objects that describe recommendation preferences.
         * </p>
         * 
         * @param recommendationPreferencesDetails
         *        An array of objects that describe recommendation preferences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationPreferencesDetails(RecommendationPreferencesDetail... recommendationPreferencesDetails);

        /**
         * <p>
         * An array of objects that describe recommendation preferences.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferencesDetail.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferencesDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferencesDetail.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #recommendationPreferencesDetails(List<RecommendationPreferencesDetail>)}.
         * 
         * @param recommendationPreferencesDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferencesDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationPreferencesDetails(java.util.Collection<RecommendationPreferencesDetail>)
         */
        Builder recommendationPreferencesDetails(
                Consumer<RecommendationPreferencesDetail.Builder>... recommendationPreferencesDetails);
    }

    static final class BuilderImpl extends ComputeOptimizerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RecommendationPreferencesDetail> recommendationPreferencesDetails = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationPreferencesResponse model) {
            super(model);
            nextToken(model.nextToken);
            recommendationPreferencesDetails(model.recommendationPreferencesDetails);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RecommendationPreferencesDetail.Builder> getRecommendationPreferencesDetails() {
            List<RecommendationPreferencesDetail.Builder> result = RecommendationPreferencesDetailsCopier
                    .copyToBuilder(this.recommendationPreferencesDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendationPreferencesDetails(
                Collection<RecommendationPreferencesDetail.BuilderImpl> recommendationPreferencesDetails) {
            this.recommendationPreferencesDetails = RecommendationPreferencesDetailsCopier
                    .copyFromBuilder(recommendationPreferencesDetails);
        }

        @Override
        public final Builder recommendationPreferencesDetails(
                Collection<RecommendationPreferencesDetail> recommendationPreferencesDetails) {
            this.recommendationPreferencesDetails = RecommendationPreferencesDetailsCopier.copy(recommendationPreferencesDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationPreferencesDetails(RecommendationPreferencesDetail... recommendationPreferencesDetails) {
            recommendationPreferencesDetails(Arrays.asList(recommendationPreferencesDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationPreferencesDetails(
                Consumer<RecommendationPreferencesDetail.Builder>... recommendationPreferencesDetails) {
            recommendationPreferencesDetails(Stream.of(recommendationPreferencesDetails)
                    .map(c -> RecommendationPreferencesDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRecommendationPreferencesResponse build() {
            return new GetRecommendationPreferencesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
