/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLambdaFunctionRecommendationsRequest extends ComputeOptimizerRequest implements
        ToCopyableBuilder<GetLambdaFunctionRecommendationsRequest.Builder, GetLambdaFunctionRecommendationsRequest> {
    private static final SdkField<List<String>> FUNCTION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("functionArns")
            .getter(getter(GetLambdaFunctionRecommendationsRequest::functionArns))
            .setter(setter(Builder::functionArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(GetLambdaFunctionRecommendationsRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LambdaFunctionRecommendationFilter>> FILTERS_FIELD = SdkField
            .<List<LambdaFunctionRecommendationFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(GetLambdaFunctionRecommendationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LambdaFunctionRecommendationFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(LambdaFunctionRecommendationFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetLambdaFunctionRecommendationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetLambdaFunctionRecommendationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARNS_FIELD,
            ACCOUNT_IDS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> functionArns;

    private final List<String> accountIds;

    private final List<LambdaFunctionRecommendationFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private GetLambdaFunctionRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.functionArns = builder.functionArns;
        this.accountIds = builder.accountIds;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the FunctionArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFunctionArns() {
        return functionArns != null && !(functionArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the functions for which to return recommendations.
     * </p>
     * <p>
     * You can specify a qualified or unqualified ARN. If you specify an unqualified ARN without a function version
     * suffix, Compute Optimizer will return recommendations for the latest (<code>$LATEST</code>) version of the
     * function. If you specify a qualified ARN with a version suffix, Compute Optimizer will return recommendations for
     * the specified function version. For more information about using function versions, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using">Using
     * versions</a> in the <i>Lambda Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctionArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the functions for which to return recommendations.</p>
     *         <p>
     *         You can specify a qualified or unqualified ARN. If you specify an unqualified ARN without a function
     *         version suffix, Compute Optimizer will return recommendations for the latest (<code>$LATEST</code>)
     *         version of the function. If you specify a qualified ARN with a version suffix, Compute Optimizer will
     *         return recommendations for the specified function version. For more information about using function
     *         versions, see <a href=
     *         "https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using"
     *         >Using versions</a> in the <i>Lambda Developer Guide</i>.
     */
    public final List<String> functionArns() {
        return functionArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account for which to return function recommendations.
     * </p>
     * <p>
     * If your account is the management account of an organization, use this parameter to specify the member account
     * for which you want to return function recommendations.
     * </p>
     * <p>
     * Only one account ID can be specified per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account for which to return function recommendations.</p>
     *         <p>
     *         If your account is the management account of an organization, use this parameter to specify the member
     *         account for which you want to return function recommendations.
     *         </p>
     *         <p>
     *         Only one account ID can be specified per request.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects to specify a filter that returns a more specific list of function recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return An array of objects to specify a filter that returns a more specific list of function recommendations.
     */
    public final List<LambdaFunctionRecommendationFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token to advance to the next page of function recommendations.
     * </p>
     * 
     * @return The token to advance to the next page of function recommendations.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of function recommendations to return with a single request.
     * </p>
     * <p>
     * To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of function recommendations to return with a single request.</p>
     *         <p>
     *         To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctionArns() ? functionArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLambdaFunctionRecommendationsRequest)) {
            return false;
        }
        GetLambdaFunctionRecommendationsRequest other = (GetLambdaFunctionRecommendationsRequest) obj;
        return hasFunctionArns() == other.hasFunctionArns() && Objects.equals(functionArns(), other.functionArns())
                && hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLambdaFunctionRecommendationsRequest")
                .add("FunctionArns", hasFunctionArns() ? functionArns() : null)
                .add("AccountIds", hasAccountIds() ? accountIds() : null).add("Filters", hasFilters() ? filters() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "functionArns":
            return Optional.ofNullable(clazz.cast(functionArns()));
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("functionArns", FUNCTION_ARNS_FIELD);
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLambdaFunctionRecommendationsRequest, T> g) {
        return obj -> g.apply((GetLambdaFunctionRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComputeOptimizerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLambdaFunctionRecommendationsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the functions for which to return recommendations.
         * </p>
         * <p>
         * You can specify a qualified or unqualified ARN. If you specify an unqualified ARN without a function version
         * suffix, Compute Optimizer will return recommendations for the latest (<code>$LATEST</code>) version of the
         * function. If you specify a qualified ARN with a version suffix, Compute Optimizer will return recommendations
         * for the specified function version. For more information about using function versions, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using"
         * >Using versions</a> in the <i>Lambda Developer Guide</i>.
         * </p>
         * 
         * @param functionArns
         *        The Amazon Resource Name (ARN) of the functions for which to return recommendations.</p>
         *        <p>
         *        You can specify a qualified or unqualified ARN. If you specify an unqualified ARN without a function
         *        version suffix, Compute Optimizer will return recommendations for the latest (<code>$LATEST</code>)
         *        version of the function. If you specify a qualified ARN with a version suffix, Compute Optimizer will
         *        return recommendations for the specified function version. For more information about using function
         *        versions, see <a href=
         *        "https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using"
         *        >Using versions</a> in the <i>Lambda Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArns(Collection<String> functionArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the functions for which to return recommendations.
         * </p>
         * <p>
         * You can specify a qualified or unqualified ARN. If you specify an unqualified ARN without a function version
         * suffix, Compute Optimizer will return recommendations for the latest (<code>$LATEST</code>) version of the
         * function. If you specify a qualified ARN with a version suffix, Compute Optimizer will return recommendations
         * for the specified function version. For more information about using function versions, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using"
         * >Using versions</a> in the <i>Lambda Developer Guide</i>.
         * </p>
         * 
         * @param functionArns
         *        The Amazon Resource Name (ARN) of the functions for which to return recommendations.</p>
         *        <p>
         *        You can specify a qualified or unqualified ARN. If you specify an unqualified ARN without a function
         *        version suffix, Compute Optimizer will return recommendations for the latest (<code>$LATEST</code>)
         *        version of the function. If you specify a qualified ARN with a version suffix, Compute Optimizer will
         *        return recommendations for the specified function version. For more information about using function
         *        versions, see <a href=
         *        "https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using"
         *        >Using versions</a> in the <i>Lambda Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArns(String... functionArns);

        /**
         * <p>
         * The ID of the Amazon Web Services account for which to return function recommendations.
         * </p>
         * <p>
         * If your account is the management account of an organization, use this parameter to specify the member
         * account for which you want to return function recommendations.
         * </p>
         * <p>
         * Only one account ID can be specified per request.
         * </p>
         * 
         * @param accountIds
         *        The ID of the Amazon Web Services account for which to return function recommendations.</p>
         *        <p>
         *        If your account is the management account of an organization, use this parameter to specify the member
         *        account for which you want to return function recommendations.
         *        </p>
         *        <p>
         *        Only one account ID can be specified per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The ID of the Amazon Web Services account for which to return function recommendations.
         * </p>
         * <p>
         * If your account is the management account of an organization, use this parameter to specify the member
         * account for which you want to return function recommendations.
         * </p>
         * <p>
         * Only one account ID can be specified per request.
         * </p>
         * 
         * @param accountIds
         *        The ID of the Amazon Web Services account for which to return function recommendations.</p>
         *        <p>
         *        If your account is the management account of an organization, use this parameter to specify the member
         *        account for which you want to return function recommendations.
         *        </p>
         *        <p>
         *        Only one account ID can be specified per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of function recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects to specify a filter that returns a more specific list of function recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<LambdaFunctionRecommendationFilter> filters);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of function recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects to specify a filter that returns a more specific list of function recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(LambdaFunctionRecommendationFilter... filters);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of function recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilter.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<LambdaFunctionRecommendationFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<LambdaFunctionRecommendationFilter>)
         */
        Builder filters(Consumer<LambdaFunctionRecommendationFilter.Builder>... filters);

        /**
         * <p>
         * The token to advance to the next page of function recommendations.
         * </p>
         * 
         * @param nextToken
         *        The token to advance to the next page of function recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of function recommendations to return with a single request.
         * </p>
         * <p>
         * To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of function recommendations to return with a single request.</p>
         *        <p>
         *        To retrieve the remaining results, make another request with the returned <code>nextToken</code>
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComputeOptimizerRequest.BuilderImpl implements Builder {
        private List<String> functionArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<LambdaFunctionRecommendationFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLambdaFunctionRecommendationsRequest model) {
            super(model);
            functionArns(model.functionArns);
            accountIds(model.accountIds);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getFunctionArns() {
            if (functionArns instanceof SdkAutoConstructList) {
                return null;
            }
            return functionArns;
        }

        public final void setFunctionArns(Collection<String> functionArns) {
            this.functionArns = FunctionArnsCopier.copy(functionArns);
        }

        @Override
        public final Builder functionArns(Collection<String> functionArns) {
            this.functionArns = FunctionArnsCopier.copy(functionArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionArns(String... functionArns) {
            functionArns(Arrays.asList(functionArns));
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final List<LambdaFunctionRecommendationFilter.Builder> getFilters() {
            List<LambdaFunctionRecommendationFilter.Builder> result = LambdaFunctionRecommendationFiltersCopier
                    .copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<LambdaFunctionRecommendationFilter.BuilderImpl> filters) {
            this.filters = LambdaFunctionRecommendationFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<LambdaFunctionRecommendationFilter> filters) {
            this.filters = LambdaFunctionRecommendationFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(LambdaFunctionRecommendationFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<LambdaFunctionRecommendationFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> LambdaFunctionRecommendationFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLambdaFunctionRecommendationsRequest build() {
            return new GetLambdaFunctionRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
