/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEnrollmentStatusesForOrganizationResponse extends ComputeOptimizerResponse implements
        ToCopyableBuilder<GetEnrollmentStatusesForOrganizationResponse.Builder, GetEnrollmentStatusesForOrganizationResponse> {
    private static final SdkField<List<AccountEnrollmentStatus>> ACCOUNT_ENROLLMENT_STATUSES_FIELD = SdkField
            .<List<AccountEnrollmentStatus>> builder(MarshallingType.LIST)
            .memberName("accountEnrollmentStatuses")
            .getter(getter(GetEnrollmentStatusesForOrganizationResponse::accountEnrollmentStatuses))
            .setter(setter(Builder::accountEnrollmentStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountEnrollmentStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountEnrollmentStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountEnrollmentStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetEnrollmentStatusesForOrganizationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACCOUNT_ENROLLMENT_STATUSES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AccountEnrollmentStatus> accountEnrollmentStatuses;

    private final String nextToken;

    private GetEnrollmentStatusesForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.accountEnrollmentStatuses = builder.accountEnrollmentStatuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountEnrollmentStatuses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAccountEnrollmentStatuses() {
        return accountEnrollmentStatuses != null && !(accountEnrollmentStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the enrollment statuses of organization member accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountEnrollmentStatuses} method.
     * </p>
     * 
     * @return An array of objects that describe the enrollment statuses of organization member accounts.
     */
    public final List<AccountEnrollmentStatus> accountEnrollmentStatuses() {
        return accountEnrollmentStatuses;
    }

    /**
     * <p>
     * The token to use to advance to the next page of account enrollment statuses.
     * </p>
     * <p>
     * This value is null when there are no more pages of account enrollment statuses to return.
     * </p>
     * 
     * @return The token to use to advance to the next page of account enrollment statuses.</p>
     *         <p>
     *         This value is null when there are no more pages of account enrollment statuses to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountEnrollmentStatuses() ? accountEnrollmentStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnrollmentStatusesForOrganizationResponse)) {
            return false;
        }
        GetEnrollmentStatusesForOrganizationResponse other = (GetEnrollmentStatusesForOrganizationResponse) obj;
        return hasAccountEnrollmentStatuses() == other.hasAccountEnrollmentStatuses()
                && Objects.equals(accountEnrollmentStatuses(), other.accountEnrollmentStatuses())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEnrollmentStatusesForOrganizationResponse")
                .add("AccountEnrollmentStatuses", hasAccountEnrollmentStatuses() ? accountEnrollmentStatuses() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountEnrollmentStatuses":
            return Optional.ofNullable(clazz.cast(accountEnrollmentStatuses()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountEnrollmentStatuses", ACCOUNT_ENROLLMENT_STATUSES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEnrollmentStatusesForOrganizationResponse, T> g) {
        return obj -> g.apply((GetEnrollmentStatusesForOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComputeOptimizerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEnrollmentStatusesForOrganizationResponse> {
        /**
         * <p>
         * An array of objects that describe the enrollment statuses of organization member accounts.
         * </p>
         * 
         * @param accountEnrollmentStatuses
         *        An array of objects that describe the enrollment statuses of organization member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountEnrollmentStatuses(Collection<AccountEnrollmentStatus> accountEnrollmentStatuses);

        /**
         * <p>
         * An array of objects that describe the enrollment statuses of organization member accounts.
         * </p>
         * 
         * @param accountEnrollmentStatuses
         *        An array of objects that describe the enrollment statuses of organization member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountEnrollmentStatuses(AccountEnrollmentStatus... accountEnrollmentStatuses);

        /**
         * <p>
         * An array of objects that describe the enrollment statuses of organization member accounts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.AccountEnrollmentStatus.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.AccountEnrollmentStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.AccountEnrollmentStatus.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #accountEnrollmentStatuses(List<AccountEnrollmentStatus>)}.
         * 
         * @param accountEnrollmentStatuses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.AccountEnrollmentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountEnrollmentStatuses(java.util.Collection<AccountEnrollmentStatus>)
         */
        Builder accountEnrollmentStatuses(Consumer<AccountEnrollmentStatus.Builder>... accountEnrollmentStatuses);

        /**
         * <p>
         * The token to use to advance to the next page of account enrollment statuses.
         * </p>
         * <p>
         * This value is null when there are no more pages of account enrollment statuses to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to advance to the next page of account enrollment statuses.</p>
         *        <p>
         *        This value is null when there are no more pages of account enrollment statuses to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ComputeOptimizerResponse.BuilderImpl implements Builder {
        private List<AccountEnrollmentStatus> accountEnrollmentStatuses = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnrollmentStatusesForOrganizationResponse model) {
            super(model);
            accountEnrollmentStatuses(model.accountEnrollmentStatuses);
            nextToken(model.nextToken);
        }

        public final List<AccountEnrollmentStatus.Builder> getAccountEnrollmentStatuses() {
            List<AccountEnrollmentStatus.Builder> result = AccountEnrollmentStatusesCopier
                    .copyToBuilder(this.accountEnrollmentStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountEnrollmentStatuses(Collection<AccountEnrollmentStatus.BuilderImpl> accountEnrollmentStatuses) {
            this.accountEnrollmentStatuses = AccountEnrollmentStatusesCopier.copyFromBuilder(accountEnrollmentStatuses);
        }

        @Override
        public final Builder accountEnrollmentStatuses(Collection<AccountEnrollmentStatus> accountEnrollmentStatuses) {
            this.accountEnrollmentStatuses = AccountEnrollmentStatusesCopier.copy(accountEnrollmentStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountEnrollmentStatuses(AccountEnrollmentStatus... accountEnrollmentStatuses) {
            accountEnrollmentStatuses(Arrays.asList(accountEnrollmentStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountEnrollmentStatuses(Consumer<AccountEnrollmentStatus.Builder>... accountEnrollmentStatuses) {
            accountEnrollmentStatuses(Stream.of(accountEnrollmentStatuses)
                    .map(c -> AccountEnrollmentStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetEnrollmentStatusesForOrganizationResponse build() {
            return new GetEnrollmentStatusesForOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
