/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAutoScalingGroupRecommendationsRequest extends ComputeOptimizerRequest implements
        ToCopyableBuilder<GetAutoScalingGroupRecommendationsRequest.Builder, GetAutoScalingGroupRecommendationsRequest> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(GetAutoScalingGroupRecommendationsRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTO_SCALING_GROUP_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("autoScalingGroupArns")
            .getter(getter(GetAutoScalingGroupRecommendationsRequest::autoScalingGroupArns))
            .setter(setter(Builder::autoScalingGroupArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetAutoScalingGroupRecommendationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetAutoScalingGroupRecommendationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(GetAutoScalingGroupRecommendationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RecommendationPreferences> RECOMMENDATION_PREFERENCES_FIELD = SdkField
            .<RecommendationPreferences> builder(MarshallingType.SDK_POJO).memberName("recommendationPreferences")
            .getter(getter(GetAutoScalingGroupRecommendationsRequest::recommendationPreferences))
            .setter(setter(Builder::recommendationPreferences)).constructor(RecommendationPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationPreferences").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD,
            AUTO_SCALING_GROUP_ARNS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD, RECOMMENDATION_PREFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> accountIds;

    private final List<String> autoScalingGroupArns;

    private final String nextToken;

    private final Integer maxResults;

    private final List<Filter> filters;

    private final RecommendationPreferences recommendationPreferences;

    private GetAutoScalingGroupRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.autoScalingGroupArns = builder.autoScalingGroupArns;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.recommendationPreferences = builder.recommendationPreferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account for which to return Amazon EC2 Auto Scaling group recommendations.
     * </p>
     * <p>
     * If your account is the management account of an organization, use this parameter to specify the member account
     * for which you want to return Amazon EC2 Auto Scaling group recommendations.
     * </p>
     * <p>
     * Only one account ID can be specified per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account for which to return Amazon EC2 Auto Scaling group
     *         recommendations.</p>
     *         <p>
     *         If your account is the management account of an organization, use this parameter to specify the member
     *         account for which you want to return Amazon EC2 Auto Scaling group recommendations.
     *         </p>
     *         <p>
     *         Only one account ID can be specified per request.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoScalingGroupArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAutoScalingGroupArns() {
        return autoScalingGroupArns != null && !(autoScalingGroupArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon EC2 Auto Scaling groups for which to return recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoScalingGroupArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon EC2 Auto Scaling groups for which to return recommendations.
     */
    public final List<String> autoScalingGroupArns() {
        return autoScalingGroupArns;
    }

    /**
     * <p>
     * The token to advance to the next page of Amazon EC2 Auto Scaling group recommendations.
     * </p>
     * 
     * @return The token to advance to the next page of Amazon EC2 Auto Scaling group recommendations.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of Amazon EC2 Auto Scaling group recommendations to return with a single request.
     * </p>
     * <p>
     * To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of Amazon EC2 Auto Scaling group recommendations to return with a single request.</p>
     *         <p>
     *         To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects to specify a filter that returns a more specific list of Amazon EC2 Auto Scaling group
     * recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return An array of objects to specify a filter that returns a more specific list of Amazon EC2 Auto Scaling
     *         group recommendations.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * An object to specify the preferences for the Amazon EC2 Auto Scaling group recommendations to return in the
     * response.
     * </p>
     * 
     * @return An object to specify the preferences for the Amazon EC2 Auto Scaling group recommendations to return in
     *         the response.
     */
    public final RecommendationPreferences recommendationPreferences() {
        return recommendationPreferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoScalingGroupArns() ? autoScalingGroupArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recommendationPreferences());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutoScalingGroupRecommendationsRequest)) {
            return false;
        }
        GetAutoScalingGroupRecommendationsRequest other = (GetAutoScalingGroupRecommendationsRequest) obj;
        return hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && hasAutoScalingGroupArns() == other.hasAutoScalingGroupArns()
                && Objects.equals(autoScalingGroupArns(), other.autoScalingGroupArns())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(recommendationPreferences(), other.recommendationPreferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAutoScalingGroupRecommendationsRequest")
                .add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("AutoScalingGroupArns", hasAutoScalingGroupArns() ? autoScalingGroupArns() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("Filters", hasFilters() ? filters() : null)
                .add("RecommendationPreferences", recommendationPreferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "autoScalingGroupArns":
            return Optional.ofNullable(clazz.cast(autoScalingGroupArns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "recommendationPreferences":
            return Optional.ofNullable(clazz.cast(recommendationPreferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("autoScalingGroupArns", AUTO_SCALING_GROUP_ARNS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("recommendationPreferences", RECOMMENDATION_PREFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAutoScalingGroupRecommendationsRequest, T> g) {
        return obj -> g.apply((GetAutoScalingGroupRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComputeOptimizerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAutoScalingGroupRecommendationsRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account for which to return Amazon EC2 Auto Scaling group recommendations.
         * </p>
         * <p>
         * If your account is the management account of an organization, use this parameter to specify the member
         * account for which you want to return Amazon EC2 Auto Scaling group recommendations.
         * </p>
         * <p>
         * Only one account ID can be specified per request.
         * </p>
         * 
         * @param accountIds
         *        The ID of the Amazon Web Services account for which to return Amazon EC2 Auto Scaling group
         *        recommendations.</p>
         *        <p>
         *        If your account is the management account of an organization, use this parameter to specify the member
         *        account for which you want to return Amazon EC2 Auto Scaling group recommendations.
         *        </p>
         *        <p>
         *        Only one account ID can be specified per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The ID of the Amazon Web Services account for which to return Amazon EC2 Auto Scaling group recommendations.
         * </p>
         * <p>
         * If your account is the management account of an organization, use this parameter to specify the member
         * account for which you want to return Amazon EC2 Auto Scaling group recommendations.
         * </p>
         * <p>
         * Only one account ID can be specified per request.
         * </p>
         * 
         * @param accountIds
         *        The ID of the Amazon Web Services account for which to return Amazon EC2 Auto Scaling group
         *        recommendations.</p>
         *        <p>
         *        If your account is the management account of an organization, use this parameter to specify the member
         *        account for which you want to return Amazon EC2 Auto Scaling group recommendations.
         *        </p>
         *        <p>
         *        Only one account ID can be specified per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon EC2 Auto Scaling groups for which to return recommendations.
         * </p>
         * 
         * @param autoScalingGroupArns
         *        The Amazon Resource Name (ARN) of the Amazon EC2 Auto Scaling groups for which to return
         *        recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupArns(Collection<String> autoScalingGroupArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon EC2 Auto Scaling groups for which to return recommendations.
         * </p>
         * 
         * @param autoScalingGroupArns
         *        The Amazon Resource Name (ARN) of the Amazon EC2 Auto Scaling groups for which to return
         *        recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupArns(String... autoScalingGroupArns);

        /**
         * <p>
         * The token to advance to the next page of Amazon EC2 Auto Scaling group recommendations.
         * </p>
         * 
         * @param nextToken
         *        The token to advance to the next page of Amazon EC2 Auto Scaling group recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of Amazon EC2 Auto Scaling group recommendations to return with a single request.
         * </p>
         * <p>
         * To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of Amazon EC2 Auto Scaling group recommendations to return with a single
         *        request.</p>
         *        <p>
         *        To retrieve the remaining results, make another request with the returned <code>nextToken</code>
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of Amazon EC2 Auto Scaling group
         * recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects to specify a filter that returns a more specific list of Amazon EC2 Auto Scaling
         *        group recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of Amazon EC2 Auto Scaling group
         * recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects to specify a filter that returns a more specific list of Amazon EC2 Auto Scaling
         *        group recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of Amazon EC2 Auto Scaling group
         * recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.Filter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.computeoptimizer.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.Filter.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * An object to specify the preferences for the Amazon EC2 Auto Scaling group recommendations to return in the
         * response.
         * </p>
         * 
         * @param recommendationPreferences
         *        An object to specify the preferences for the Amazon EC2 Auto Scaling group recommendations to return
         *        in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationPreferences(RecommendationPreferences recommendationPreferences);

        /**
         * <p>
         * An object to specify the preferences for the Amazon EC2 Auto Scaling group recommendations to return in the
         * response.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationPreferences.Builder}
         * avoiding the need to create one manually via {@link RecommendationPreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationPreferences.Builder#build()} is called immediately
         * and its result is passed to {@link #recommendationPreferences(RecommendationPreferences)}.
         * 
         * @param recommendationPreferences
         *        a consumer that will call methods on {@link RecommendationPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationPreferences(RecommendationPreferences)
         */
        default Builder recommendationPreferences(Consumer<RecommendationPreferences.Builder> recommendationPreferences) {
            return recommendationPreferences(RecommendationPreferences.builder().applyMutation(recommendationPreferences).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComputeOptimizerRequest.BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> autoScalingGroupArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private RecommendationPreferences recommendationPreferences;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutoScalingGroupRecommendationsRequest model) {
            super(model);
            accountIds(model.accountIds);
            autoScalingGroupArns(model.autoScalingGroupArns);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
            recommendationPreferences(model.recommendationPreferences);
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getAutoScalingGroupArns() {
            if (autoScalingGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return autoScalingGroupArns;
        }

        public final void setAutoScalingGroupArns(Collection<String> autoScalingGroupArns) {
            this.autoScalingGroupArns = AutoScalingGroupArnsCopier.copy(autoScalingGroupArns);
        }

        @Override
        public final Builder autoScalingGroupArns(Collection<String> autoScalingGroupArns) {
            this.autoScalingGroupArns = AutoScalingGroupArnsCopier.copy(autoScalingGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroupArns(String... autoScalingGroupArns) {
            autoScalingGroupArns(Arrays.asList(autoScalingGroupArns));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final RecommendationPreferences.Builder getRecommendationPreferences() {
            return recommendationPreferences != null ? recommendationPreferences.toBuilder() : null;
        }

        public final void setRecommendationPreferences(RecommendationPreferences.BuilderImpl recommendationPreferences) {
            this.recommendationPreferences = recommendationPreferences != null ? recommendationPreferences.build() : null;
        }

        @Override
        public final Builder recommendationPreferences(RecommendationPreferences recommendationPreferences) {
            this.recommendationPreferences = recommendationPreferences;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAutoScalingGroupRecommendationsRequest build() {
            return new GetAutoScalingGroupRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
