/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRecommendationExportJobsRequest extends ComputeOptimizerRequest implements
        ToCopyableBuilder<DescribeRecommendationExportJobsRequest.Builder, DescribeRecommendationExportJobsRequest> {
    private static final SdkField<List<String>> JOB_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("jobIds")
            .getter(getter(DescribeRecommendationExportJobsRequest::jobIds))
            .setter(setter(Builder::jobIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<JobFilter>> FILTERS_FIELD = SdkField
            .<List<JobFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(DescribeRecommendationExportJobsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeRecommendationExportJobsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeRecommendationExportJobsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_IDS_FIELD, FILTERS_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> jobIds;

    private final List<JobFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeRecommendationExportJobsRequest(BuilderImpl builder) {
        super(builder);
        this.jobIds = builder.jobIds;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobIds() {
        return jobIds != null && !(jobIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identification numbers of the export jobs to return.
     * </p>
     * <p>
     * An export job ID is returned when you create an export using the <a>ExportAutoScalingGroupRecommendations</a> or
     * <a>ExportEC2InstanceRecommendations</a> actions.
     * </p>
     * <p>
     * All export jobs created in the last seven days are returned if this parameter is omitted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobIds} method.
     * </p>
     * 
     * @return The identification numbers of the export jobs to return.</p>
     *         <p>
     *         An export job ID is returned when you create an export using the
     *         <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions.
     *         </p>
     *         <p>
     *         All export jobs created in the last seven days are returned if this parameter is omitted.
     */
    public final List<String> jobIds() {
        return jobIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects to specify a filter that returns a more specific list of export jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return An array of objects to specify a filter that returns a more specific list of export jobs.
     */
    public final List<JobFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token to advance to the next page of export jobs.
     * </p>
     * 
     * @return The token to advance to the next page of export jobs.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of export jobs to return with a single request.
     * </p>
     * <p>
     * To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of export jobs to return with a single request.</p>
     *         <p>
     *         To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobIds() ? jobIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecommendationExportJobsRequest)) {
            return false;
        }
        DescribeRecommendationExportJobsRequest other = (DescribeRecommendationExportJobsRequest) obj;
        return hasJobIds() == other.hasJobIds() && Objects.equals(jobIds(), other.jobIds()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRecommendationExportJobsRequest").add("JobIds", hasJobIds() ? jobIds() : null)
                .add("Filters", hasFilters() ? filters() : null).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobIds":
            return Optional.ofNullable(clazz.cast(jobIds()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobIds", JOB_IDS_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecommendationExportJobsRequest, T> g) {
        return obj -> g.apply((DescribeRecommendationExportJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComputeOptimizerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRecommendationExportJobsRequest> {
        /**
         * <p>
         * The identification numbers of the export jobs to return.
         * </p>
         * <p>
         * An export job ID is returned when you create an export using the <a>ExportAutoScalingGroupRecommendations</a>
         * or <a>ExportEC2InstanceRecommendations</a> actions.
         * </p>
         * <p>
         * All export jobs created in the last seven days are returned if this parameter is omitted.
         * </p>
         * 
         * @param jobIds
         *        The identification numbers of the export jobs to return.</p>
         *        <p>
         *        An export job ID is returned when you create an export using the
         *        <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions.
         *        </p>
         *        <p>
         *        All export jobs created in the last seven days are returned if this parameter is omitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobIds(Collection<String> jobIds);

        /**
         * <p>
         * The identification numbers of the export jobs to return.
         * </p>
         * <p>
         * An export job ID is returned when you create an export using the <a>ExportAutoScalingGroupRecommendations</a>
         * or <a>ExportEC2InstanceRecommendations</a> actions.
         * </p>
         * <p>
         * All export jobs created in the last seven days are returned if this parameter is omitted.
         * </p>
         * 
         * @param jobIds
         *        The identification numbers of the export jobs to return.</p>
         *        <p>
         *        An export job ID is returned when you create an export using the
         *        <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions.
         *        </p>
         *        <p>
         *        All export jobs created in the last seven days are returned if this parameter is omitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobIds(String... jobIds);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of export jobs.
         * </p>
         * 
         * @param filters
         *        An array of objects to specify a filter that returns a more specific list of export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<JobFilter> filters);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of export jobs.
         * </p>
         * 
         * @param filters
         *        An array of objects to specify a filter that returns a more specific list of export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(JobFilter... filters);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of export jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.JobFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.computeoptimizer.model.JobFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.JobFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<JobFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.JobFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<JobFilter>)
         */
        Builder filters(Consumer<JobFilter.Builder>... filters);

        /**
         * <p>
         * The token to advance to the next page of export jobs.
         * </p>
         * 
         * @param nextToken
         *        The token to advance to the next page of export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of export jobs to return with a single request.
         * </p>
         * <p>
         * To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of export jobs to return with a single request.</p>
         *        <p>
         *        To retrieve the remaining results, make another request with the returned <code>nextToken</code>
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComputeOptimizerRequest.BuilderImpl implements Builder {
        private List<String> jobIds = DefaultSdkAutoConstructList.getInstance();

        private List<JobFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecommendationExportJobsRequest model) {
            super(model);
            jobIds(model.jobIds);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getJobIds() {
            if (jobIds instanceof SdkAutoConstructList) {
                return null;
            }
            return jobIds;
        }

        public final void setJobIds(Collection<String> jobIds) {
            this.jobIds = JobIdsCopier.copy(jobIds);
        }

        @Override
        public final Builder jobIds(Collection<String> jobIds) {
            this.jobIds = JobIdsCopier.copy(jobIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobIds(String... jobIds) {
            jobIds(Arrays.asList(jobIds));
            return this;
        }

        public final List<JobFilter.Builder> getFilters() {
            List<JobFilter.Builder> result = JobFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<JobFilter.BuilderImpl> filters) {
            this.filters = JobFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<JobFilter> filters) {
            this.filters = JobFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(JobFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<JobFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> JobFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRecommendationExportJobsRequest build() {
            return new DescribeRecommendationExportJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
