/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of an EC2 Amazon EC2 Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingGroupConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingGroupConfiguration.Builder, AutoScalingGroupConfiguration> {
    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("desiredCapacity").getter(getter(AutoScalingGroupConfiguration::desiredCapacity))
            .setter(setter(Builder::desiredCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCapacity").build()).build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minSize").getter(getter(AutoScalingGroupConfiguration::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxSize").getter(getter(AutoScalingGroupConfiguration::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSize").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(AutoScalingGroupConfiguration::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("allocationStrategy").getter(getter(AutoScalingGroupConfiguration::allocationStrategyAsString))
            .setter(setter(Builder::allocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocationStrategy").build())
            .build();

    private static final SdkField<Double> ESTIMATED_INSTANCE_HOUR_REDUCTION_PERCENTAGE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedInstanceHourReductionPercentage")
            .getter(getter(AutoScalingGroupConfiguration::estimatedInstanceHourReductionPercentage))
            .setter(setter(Builder::estimatedInstanceHourReductionPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("estimatedInstanceHourReductionPercentage").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AutoScalingGroupConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<String>> MIXED_INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("mixedInstanceTypes")
            .getter(getter(AutoScalingGroupConfiguration::mixedInstanceTypes))
            .setter(setter(Builder::mixedInstanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mixedInstanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_CAPACITY_FIELD,
            MIN_SIZE_FIELD, MAX_SIZE_FIELD, INSTANCE_TYPE_FIELD, ALLOCATION_STRATEGY_FIELD,
            ESTIMATED_INSTANCE_HOUR_REDUCTION_PERCENTAGE_FIELD, TYPE_FIELD, MIXED_INSTANCE_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer desiredCapacity;

    private final Integer minSize;

    private final Integer maxSize;

    private final String instanceType;

    private final String allocationStrategy;

    private final Double estimatedInstanceHourReductionPercentage;

    private final String type;

    private final List<String> mixedInstanceTypes;

    private AutoScalingGroupConfiguration(BuilderImpl builder) {
        this.desiredCapacity = builder.desiredCapacity;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.instanceType = builder.instanceType;
        this.allocationStrategy = builder.allocationStrategy;
        this.estimatedInstanceHourReductionPercentage = builder.estimatedInstanceHourReductionPercentage;
        this.type = builder.type;
        this.mixedInstanceTypes = builder.mixedInstanceTypes;
    }

    /**
     * <p>
     * The desired capacity, or number of instances, for the EC2 Amazon EC2 Auto Scaling group.
     * </p>
     * 
     * @return The desired capacity, or number of instances, for the EC2 Amazon EC2 Auto Scaling group.
     */
    public final Integer desiredCapacity() {
        return desiredCapacity;
    }

    /**
     * <p>
     * The minimum size, or minimum number of instances, for the EC2 Amazon EC2 Auto Scaling group.
     * </p>
     * 
     * @return The minimum size, or minimum number of instances, for the EC2 Amazon EC2 Auto Scaling group.
     */
    public final Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum size, or maximum number of instances, for the EC2 Amazon EC2 Auto Scaling group.
     * </p>
     * 
     * @return The maximum size, or maximum number of instances, for the EC2 Amazon EC2 Auto Scaling group.
     */
    public final Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The instance type for the EC2 Amazon EC2 Auto Scaling group.
     * </p>
     * 
     * @return The instance type for the EC2 Amazon EC2 Auto Scaling group.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * Describes the allocation strategy that the EC2 Amazon EC2 Auto Scaling group uses. This field is only available
     * for EC2 Amazon EC2 Auto Scaling groups with mixed instance types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link AllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return Describes the allocation strategy that the EC2 Amazon EC2 Auto Scaling group uses. This field is only
     *         available for EC2 Amazon EC2 Auto Scaling groups with mixed instance types.
     * @see AllocationStrategy
     */
    public final AllocationStrategy allocationStrategy() {
        return AllocationStrategy.fromValue(allocationStrategy);
    }

    /**
     * <p>
     * Describes the allocation strategy that the EC2 Amazon EC2 Auto Scaling group uses. This field is only available
     * for EC2 Amazon EC2 Auto Scaling groups with mixed instance types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link AllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return Describes the allocation strategy that the EC2 Amazon EC2 Auto Scaling group uses. This field is only
     *         available for EC2 Amazon EC2 Auto Scaling groups with mixed instance types.
     * @see AllocationStrategy
     */
    public final String allocationStrategyAsString() {
        return allocationStrategy;
    }

    /**
     * <p>
     * Describes the projected percentage reduction in instance hours after adopting the recommended configuration. This
     * field is only available for EC2 Amazon EC2 Auto Scaling groups with scaling policies.
     * </p>
     * 
     * @return Describes the projected percentage reduction in instance hours after adopting the recommended
     *         configuration. This field is only available for EC2 Amazon EC2 Auto Scaling groups with scaling policies.
     */
    public final Double estimatedInstanceHourReductionPercentage() {
        return estimatedInstanceHourReductionPercentage;
    }

    /**
     * <p>
     * Describes whether the EC2 Amazon EC2 Auto Scaling group has a single instance type or a mixed instance type
     * configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AsgType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Describes whether the EC2 Amazon EC2 Auto Scaling group has a single instance type or a mixed instance
     *         type configuration.
     * @see AsgType
     */
    public final AsgType type() {
        return AsgType.fromValue(type);
    }

    /**
     * <p>
     * Describes whether the EC2 Amazon EC2 Auto Scaling group has a single instance type or a mixed instance type
     * configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AsgType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Describes whether the EC2 Amazon EC2 Auto Scaling group has a single instance type or a mixed instance
     *         type configuration.
     * @see AsgType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the MixedInstanceTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMixedInstanceTypes() {
        return mixedInstanceTypes != null && !(mixedInstanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List the instance types within an EC2 Amazon EC2 Auto Scaling group that has mixed instance types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMixedInstanceTypes} method.
     * </p>
     * 
     * @return List the instance types within an EC2 Amazon EC2 Auto Scaling group that has mixed instance types.
     */
    public final List<String> mixedInstanceTypes() {
        return mixedInstanceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedInstanceHourReductionPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMixedInstanceTypes() ? mixedInstanceTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupConfiguration)) {
            return false;
        }
        AutoScalingGroupConfiguration other = (AutoScalingGroupConfiguration) obj;
        return Objects.equals(desiredCapacity(), other.desiredCapacity()) && Objects.equals(minSize(), other.minSize())
                && Objects.equals(maxSize(), other.maxSize()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(allocationStrategyAsString(), other.allocationStrategyAsString())
                && Objects.equals(estimatedInstanceHourReductionPercentage(), other.estimatedInstanceHourReductionPercentage())
                && Objects.equals(typeAsString(), other.typeAsString())
                && hasMixedInstanceTypes() == other.hasMixedInstanceTypes()
                && Objects.equals(mixedInstanceTypes(), other.mixedInstanceTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingGroupConfiguration").add("DesiredCapacity", desiredCapacity())
                .add("MinSize", minSize()).add("MaxSize", maxSize()).add("InstanceType", instanceType())
                .add("AllocationStrategy", allocationStrategyAsString())
                .add("EstimatedInstanceHourReductionPercentage", estimatedInstanceHourReductionPercentage())
                .add("Type", typeAsString()).add("MixedInstanceTypes", hasMixedInstanceTypes() ? mixedInstanceTypes() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "desiredCapacity":
            return Optional.ofNullable(clazz.cast(desiredCapacity()));
        case "minSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "maxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "allocationStrategy":
            return Optional.ofNullable(clazz.cast(allocationStrategyAsString()));
        case "estimatedInstanceHourReductionPercentage":
            return Optional.ofNullable(clazz.cast(estimatedInstanceHourReductionPercentage()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "mixedInstanceTypes":
            return Optional.ofNullable(clazz.cast(mixedInstanceTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("desiredCapacity", DESIRED_CAPACITY_FIELD);
        map.put("minSize", MIN_SIZE_FIELD);
        map.put("maxSize", MAX_SIZE_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("allocationStrategy", ALLOCATION_STRATEGY_FIELD);
        map.put("estimatedInstanceHourReductionPercentage", ESTIMATED_INSTANCE_HOUR_REDUCTION_PERCENTAGE_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("mixedInstanceTypes", MIXED_INSTANCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroupConfiguration, T> g) {
        return obj -> g.apply((AutoScalingGroupConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingGroupConfiguration> {
        /**
         * <p>
         * The desired capacity, or number of instances, for the EC2 Amazon EC2 Auto Scaling group.
         * </p>
         * 
         * @param desiredCapacity
         *        The desired capacity, or number of instances, for the EC2 Amazon EC2 Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);

        /**
         * <p>
         * The minimum size, or minimum number of instances, for the EC2 Amazon EC2 Auto Scaling group.
         * </p>
         * 
         * @param minSize
         *        The minimum size, or minimum number of instances, for the EC2 Amazon EC2 Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum size, or maximum number of instances, for the EC2 Amazon EC2 Auto Scaling group.
         * </p>
         * 
         * @param maxSize
         *        The maximum size, or maximum number of instances, for the EC2 Amazon EC2 Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The instance type for the EC2 Amazon EC2 Auto Scaling group.
         * </p>
         * 
         * @param instanceType
         *        The instance type for the EC2 Amazon EC2 Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * Describes the allocation strategy that the EC2 Amazon EC2 Auto Scaling group uses. This field is only
         * available for EC2 Amazon EC2 Auto Scaling groups with mixed instance types.
         * </p>
         * 
         * @param allocationStrategy
         *        Describes the allocation strategy that the EC2 Amazon EC2 Auto Scaling group uses. This field is only
         *        available for EC2 Amazon EC2 Auto Scaling groups with mixed instance types.
         * @see AllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationStrategy
         */
        Builder allocationStrategy(String allocationStrategy);

        /**
         * <p>
         * Describes the allocation strategy that the EC2 Amazon EC2 Auto Scaling group uses. This field is only
         * available for EC2 Amazon EC2 Auto Scaling groups with mixed instance types.
         * </p>
         * 
         * @param allocationStrategy
         *        Describes the allocation strategy that the EC2 Amazon EC2 Auto Scaling group uses. This field is only
         *        available for EC2 Amazon EC2 Auto Scaling groups with mixed instance types.
         * @see AllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationStrategy
         */
        Builder allocationStrategy(AllocationStrategy allocationStrategy);

        /**
         * <p>
         * Describes the projected percentage reduction in instance hours after adopting the recommended configuration.
         * This field is only available for EC2 Amazon EC2 Auto Scaling groups with scaling policies.
         * </p>
         * 
         * @param estimatedInstanceHourReductionPercentage
         *        Describes the projected percentage reduction in instance hours after adopting the recommended
         *        configuration. This field is only available for EC2 Amazon EC2 Auto Scaling groups with scaling
         *        policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedInstanceHourReductionPercentage(Double estimatedInstanceHourReductionPercentage);

        /**
         * <p>
         * Describes whether the EC2 Amazon EC2 Auto Scaling group has a single instance type or a mixed instance type
         * configuration.
         * </p>
         * 
         * @param type
         *        Describes whether the EC2 Amazon EC2 Auto Scaling group has a single instance type or a mixed instance
         *        type configuration.
         * @see AsgType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsgType
         */
        Builder type(String type);

        /**
         * <p>
         * Describes whether the EC2 Amazon EC2 Auto Scaling group has a single instance type or a mixed instance type
         * configuration.
         * </p>
         * 
         * @param type
         *        Describes whether the EC2 Amazon EC2 Auto Scaling group has a single instance type or a mixed instance
         *        type configuration.
         * @see AsgType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsgType
         */
        Builder type(AsgType type);

        /**
         * <p>
         * List the instance types within an EC2 Amazon EC2 Auto Scaling group that has mixed instance types.
         * </p>
         * 
         * @param mixedInstanceTypes
         *        List the instance types within an EC2 Amazon EC2 Auto Scaling group that has mixed instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixedInstanceTypes(Collection<String> mixedInstanceTypes);

        /**
         * <p>
         * List the instance types within an EC2 Amazon EC2 Auto Scaling group that has mixed instance types.
         * </p>
         * 
         * @param mixedInstanceTypes
         *        List the instance types within an EC2 Amazon EC2 Auto Scaling group that has mixed instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixedInstanceTypes(String... mixedInstanceTypes);
    }

    static final class BuilderImpl implements Builder {
        private Integer desiredCapacity;

        private Integer minSize;

        private Integer maxSize;

        private String instanceType;

        private String allocationStrategy;

        private Double estimatedInstanceHourReductionPercentage;

        private String type;

        private List<String> mixedInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroupConfiguration model) {
            desiredCapacity(model.desiredCapacity);
            minSize(model.minSize);
            maxSize(model.maxSize);
            instanceType(model.instanceType);
            allocationStrategy(model.allocationStrategy);
            estimatedInstanceHourReductionPercentage(model.estimatedInstanceHourReductionPercentage);
            type(model.type);
            mixedInstanceTypes(model.mixedInstanceTypes);
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getAllocationStrategy() {
            return allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(AllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public final Double getEstimatedInstanceHourReductionPercentage() {
            return estimatedInstanceHourReductionPercentage;
        }

        public final void setEstimatedInstanceHourReductionPercentage(Double estimatedInstanceHourReductionPercentage) {
            this.estimatedInstanceHourReductionPercentage = estimatedInstanceHourReductionPercentage;
        }

        @Override
        public final Builder estimatedInstanceHourReductionPercentage(Double estimatedInstanceHourReductionPercentage) {
            this.estimatedInstanceHourReductionPercentage = estimatedInstanceHourReductionPercentage;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AsgType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getMixedInstanceTypes() {
            if (mixedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return mixedInstanceTypes;
        }

        public final void setMixedInstanceTypes(Collection<String> mixedInstanceTypes) {
            this.mixedInstanceTypes = MixedInstanceTypesCopier.copy(mixedInstanceTypes);
        }

        @Override
        public final Builder mixedInstanceTypes(Collection<String> mixedInstanceTypes) {
            this.mixedInstanceTypes = MixedInstanceTypesCopier.copy(mixedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mixedInstanceTypes(String... mixedInstanceTypes) {
            mixedInstanceTypes(Arrays.asList(mixedInstanceTypes));
            return this;
        }

        @Override
        public AutoScalingGroupConfiguration build() {
            return new AutoScalingGroupConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
