/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.EffectivePreferredResource;
import software.amazon.awssdk.services.computeoptimizer.model.EffectivePreferredResourcesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics;
import software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsPreference;
import software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesPreference;
import software.amazon.awssdk.services.computeoptimizer.model.LookBackPeriodPreference;
import software.amazon.awssdk.services.computeoptimizer.model.ResourceType;
import software.amazon.awssdk.services.computeoptimizer.model.SavingsEstimationMode;
import software.amazon.awssdk.services.computeoptimizer.model.Scope;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationPreference;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationPreferencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationPreferencesDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationPreferencesDetail> {
    private static final SdkField<Scope> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scope").getter(RecommendationPreferencesDetail.getter(RecommendationPreferencesDetail::scope)).setter(RecommendationPreferencesDetail.setter(Builder::scope)).constructor(Scope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(RecommendationPreferencesDetail.getter(RecommendationPreferencesDetail::resourceTypeAsString)).setter(RecommendationPreferencesDetail.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> ENHANCED_INFRASTRUCTURE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enhancedInfrastructureMetrics").getter(RecommendationPreferencesDetail.getter(RecommendationPreferencesDetail::enhancedInfrastructureMetricsAsString)).setter(RecommendationPreferencesDetail.setter(Builder::enhancedInfrastructureMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedInfrastructureMetrics").build()}).build();
    private static final SdkField<String> INFERRED_WORKLOAD_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inferredWorkloadTypes").getter(RecommendationPreferencesDetail.getter(RecommendationPreferencesDetail::inferredWorkloadTypesAsString)).setter(RecommendationPreferencesDetail.setter(Builder::inferredWorkloadTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferredWorkloadTypes").build()}).build();
    private static final SdkField<ExternalMetricsPreference> EXTERNAL_METRICS_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("externalMetricsPreference").getter(RecommendationPreferencesDetail.getter(RecommendationPreferencesDetail::externalMetricsPreference)).setter(RecommendationPreferencesDetail.setter(Builder::externalMetricsPreference)).constructor(ExternalMetricsPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalMetricsPreference").build()}).build();
    private static final SdkField<String> LOOK_BACK_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lookBackPeriod").getter(RecommendationPreferencesDetail.getter(RecommendationPreferencesDetail::lookBackPeriodAsString)).setter(RecommendationPreferencesDetail.setter(Builder::lookBackPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookBackPeriod").build()}).build();
    private static final SdkField<List<UtilizationPreference>> UTILIZATION_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("utilizationPreferences").getter(RecommendationPreferencesDetail.getter(RecommendationPreferencesDetail::utilizationPreferences)).setter(RecommendationPreferencesDetail.setter(Builder::utilizationPreferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationPreferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UtilizationPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EffectivePreferredResource>> PREFERRED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("preferredResources").getter(RecommendationPreferencesDetail.getter(RecommendationPreferencesDetail::preferredResources)).setter(RecommendationPreferencesDetail.setter(Builder::preferredResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EffectivePreferredResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SAVINGS_ESTIMATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("savingsEstimationMode").getter(RecommendationPreferencesDetail.getter(RecommendationPreferencesDetail::savingsEstimationModeAsString)).setter(RecommendationPreferencesDetail.setter(Builder::savingsEstimationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsEstimationMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD, RESOURCE_TYPE_FIELD, ENHANCED_INFRASTRUCTURE_METRICS_FIELD, INFERRED_WORKLOAD_TYPES_FIELD, EXTERNAL_METRICS_PREFERENCE_FIELD, LOOK_BACK_PERIOD_FIELD, UTILIZATION_PREFERENCES_FIELD, PREFERRED_RESOURCES_FIELD, SAVINGS_ESTIMATION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecommendationPreferencesDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Scope scope;
    private final String resourceType;
    private final String enhancedInfrastructureMetrics;
    private final String inferredWorkloadTypes;
    private final ExternalMetricsPreference externalMetricsPreference;
    private final String lookBackPeriod;
    private final List<UtilizationPreference> utilizationPreferences;
    private final List<EffectivePreferredResource> preferredResources;
    private final String savingsEstimationMode;

    private RecommendationPreferencesDetail(BuilderImpl builder) {
        this.scope = builder.scope;
        this.resourceType = builder.resourceType;
        this.enhancedInfrastructureMetrics = builder.enhancedInfrastructureMetrics;
        this.inferredWorkloadTypes = builder.inferredWorkloadTypes;
        this.externalMetricsPreference = builder.externalMetricsPreference;
        this.lookBackPeriod = builder.lookBackPeriod;
        this.utilizationPreferences = builder.utilizationPreferences;
        this.preferredResources = builder.preferredResources;
        this.savingsEstimationMode = builder.savingsEstimationMode;
    }

    public final Scope scope() {
        return this.scope;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final EnhancedInfrastructureMetrics enhancedInfrastructureMetrics() {
        return EnhancedInfrastructureMetrics.fromValue(this.enhancedInfrastructureMetrics);
    }

    public final String enhancedInfrastructureMetricsAsString() {
        return this.enhancedInfrastructureMetrics;
    }

    public final InferredWorkloadTypesPreference inferredWorkloadTypes() {
        return InferredWorkloadTypesPreference.fromValue(this.inferredWorkloadTypes);
    }

    public final String inferredWorkloadTypesAsString() {
        return this.inferredWorkloadTypes;
    }

    public final ExternalMetricsPreference externalMetricsPreference() {
        return this.externalMetricsPreference;
    }

    public final LookBackPeriodPreference lookBackPeriod() {
        return LookBackPeriodPreference.fromValue(this.lookBackPeriod);
    }

    public final String lookBackPeriodAsString() {
        return this.lookBackPeriod;
    }

    public final boolean hasUtilizationPreferences() {
        return this.utilizationPreferences != null && !(this.utilizationPreferences instanceof SdkAutoConstructList);
    }

    public final List<UtilizationPreference> utilizationPreferences() {
        return this.utilizationPreferences;
    }

    public final boolean hasPreferredResources() {
        return this.preferredResources != null && !(this.preferredResources instanceof SdkAutoConstructList);
    }

    public final List<EffectivePreferredResource> preferredResources() {
        return this.preferredResources;
    }

    public final SavingsEstimationMode savingsEstimationMode() {
        return SavingsEstimationMode.fromValue(this.savingsEstimationMode);
    }

    public final String savingsEstimationModeAsString() {
        return this.savingsEstimationMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedInfrastructureMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferredWorkloadTypesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalMetricsPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookBackPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUtilizationPreferences() ? this.utilizationPreferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPreferredResources() ? this.preferredResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsEstimationModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationPreferencesDetail)) {
            return false;
        }
        RecommendationPreferencesDetail other = (RecommendationPreferencesDetail)obj;
        return Objects.equals(this.scope(), other.scope()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.enhancedInfrastructureMetricsAsString(), other.enhancedInfrastructureMetricsAsString()) && Objects.equals(this.inferredWorkloadTypesAsString(), other.inferredWorkloadTypesAsString()) && Objects.equals(this.externalMetricsPreference(), other.externalMetricsPreference()) && Objects.equals(this.lookBackPeriodAsString(), other.lookBackPeriodAsString()) && this.hasUtilizationPreferences() == other.hasUtilizationPreferences() && Objects.equals(this.utilizationPreferences(), other.utilizationPreferences()) && this.hasPreferredResources() == other.hasPreferredResources() && Objects.equals(this.preferredResources(), other.preferredResources()) && Objects.equals(this.savingsEstimationModeAsString(), other.savingsEstimationModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationPreferencesDetail").add("Scope", (Object)this.scope()).add("ResourceType", (Object)this.resourceTypeAsString()).add("EnhancedInfrastructureMetrics", (Object)this.enhancedInfrastructureMetricsAsString()).add("InferredWorkloadTypes", (Object)this.inferredWorkloadTypesAsString()).add("ExternalMetricsPreference", (Object)this.externalMetricsPreference()).add("LookBackPeriod", (Object)this.lookBackPeriodAsString()).add("UtilizationPreferences", this.hasUtilizationPreferences() ? this.utilizationPreferences() : null).add("PreferredResources", this.hasPreferredResources() ? this.preferredResources() : null).add("SavingsEstimationMode", (Object)this.savingsEstimationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "enhancedInfrastructureMetrics": {
                return Optional.ofNullable(clazz.cast(this.enhancedInfrastructureMetricsAsString()));
            }
            case "inferredWorkloadTypes": {
                return Optional.ofNullable(clazz.cast(this.inferredWorkloadTypesAsString()));
            }
            case "externalMetricsPreference": {
                return Optional.ofNullable(clazz.cast(this.externalMetricsPreference()));
            }
            case "lookBackPeriod": {
                return Optional.ofNullable(clazz.cast(this.lookBackPeriodAsString()));
            }
            case "utilizationPreferences": {
                return Optional.ofNullable(clazz.cast(this.utilizationPreferences()));
            }
            case "preferredResources": {
                return Optional.ofNullable(clazz.cast(this.preferredResources()));
            }
            case "savingsEstimationMode": {
                return Optional.ofNullable(clazz.cast(this.savingsEstimationModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scope", SCOPE_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("enhancedInfrastructureMetrics", ENHANCED_INFRASTRUCTURE_METRICS_FIELD);
        map.put("inferredWorkloadTypes", INFERRED_WORKLOAD_TYPES_FIELD);
        map.put("externalMetricsPreference", EXTERNAL_METRICS_PREFERENCE_FIELD);
        map.put("lookBackPeriod", LOOK_BACK_PERIOD_FIELD);
        map.put("utilizationPreferences", UTILIZATION_PREFERENCES_FIELD);
        map.put("preferredResources", PREFERRED_RESOURCES_FIELD);
        map.put("savingsEstimationMode", SAVINGS_ESTIMATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationPreferencesDetail, T> g) {
        return obj -> g.apply((RecommendationPreferencesDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Scope scope;
        private String resourceType;
        private String enhancedInfrastructureMetrics;
        private String inferredWorkloadTypes;
        private ExternalMetricsPreference externalMetricsPreference;
        private String lookBackPeriod;
        private List<UtilizationPreference> utilizationPreferences = DefaultSdkAutoConstructList.getInstance();
        private List<EffectivePreferredResource> preferredResources = DefaultSdkAutoConstructList.getInstance();
        private String savingsEstimationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationPreferencesDetail model) {
            this.scope(model.scope);
            this.resourceType(model.resourceType);
            this.enhancedInfrastructureMetrics(model.enhancedInfrastructureMetrics);
            this.inferredWorkloadTypes(model.inferredWorkloadTypes);
            this.externalMetricsPreference(model.externalMetricsPreference);
            this.lookBackPeriod(model.lookBackPeriod);
            this.utilizationPreferences(model.utilizationPreferences);
            this.preferredResources(model.preferredResources);
            this.savingsEstimationMode(model.savingsEstimationMode);
        }

        public final Scope.Builder getScope() {
            return this.scope != null ? this.scope.toBuilder() : null;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getEnhancedInfrastructureMetrics() {
            return this.enhancedInfrastructureMetrics;
        }

        public final void setEnhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
            return this;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics(enhancedInfrastructureMetrics == null ? null : enhancedInfrastructureMetrics.toString());
            return this;
        }

        public final String getInferredWorkloadTypes() {
            return this.inferredWorkloadTypes;
        }

        public final void setInferredWorkloadTypes(String inferredWorkloadTypes) {
            this.inferredWorkloadTypes = inferredWorkloadTypes;
        }

        @Override
        public final Builder inferredWorkloadTypes(String inferredWorkloadTypes) {
            this.inferredWorkloadTypes = inferredWorkloadTypes;
            return this;
        }

        @Override
        public final Builder inferredWorkloadTypes(InferredWorkloadTypesPreference inferredWorkloadTypes) {
            this.inferredWorkloadTypes(inferredWorkloadTypes == null ? null : inferredWorkloadTypes.toString());
            return this;
        }

        public final ExternalMetricsPreference.Builder getExternalMetricsPreference() {
            return this.externalMetricsPreference != null ? this.externalMetricsPreference.toBuilder() : null;
        }

        public final void setExternalMetricsPreference(ExternalMetricsPreference.BuilderImpl externalMetricsPreference) {
            this.externalMetricsPreference = externalMetricsPreference != null ? externalMetricsPreference.build() : null;
        }

        @Override
        public final Builder externalMetricsPreference(ExternalMetricsPreference externalMetricsPreference) {
            this.externalMetricsPreference = externalMetricsPreference;
            return this;
        }

        public final String getLookBackPeriod() {
            return this.lookBackPeriod;
        }

        public final void setLookBackPeriod(String lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
        }

        @Override
        public final Builder lookBackPeriod(String lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
            return this;
        }

        @Override
        public final Builder lookBackPeriod(LookBackPeriodPreference lookBackPeriod) {
            this.lookBackPeriod(lookBackPeriod == null ? null : lookBackPeriod.toString());
            return this;
        }

        public final List<UtilizationPreference.Builder> getUtilizationPreferences() {
            List<UtilizationPreference.Builder> result = UtilizationPreferencesCopier.copyToBuilder(this.utilizationPreferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtilizationPreferences(Collection<UtilizationPreference.BuilderImpl> utilizationPreferences) {
            this.utilizationPreferences = UtilizationPreferencesCopier.copyFromBuilder(utilizationPreferences);
        }

        @Override
        public final Builder utilizationPreferences(Collection<UtilizationPreference> utilizationPreferences) {
            this.utilizationPreferences = UtilizationPreferencesCopier.copy(utilizationPreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationPreferences(UtilizationPreference ... utilizationPreferences) {
            this.utilizationPreferences(Arrays.asList(utilizationPreferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationPreferences(Consumer<UtilizationPreference.Builder> ... utilizationPreferences) {
            this.utilizationPreferences(Stream.of(utilizationPreferences).map(c -> (UtilizationPreference)((UtilizationPreference.Builder)UtilizationPreference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EffectivePreferredResource.Builder> getPreferredResources() {
            List<EffectivePreferredResource.Builder> result = EffectivePreferredResourcesCopier.copyToBuilder(this.preferredResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPreferredResources(Collection<EffectivePreferredResource.BuilderImpl> preferredResources) {
            this.preferredResources = EffectivePreferredResourcesCopier.copyFromBuilder(preferredResources);
        }

        @Override
        public final Builder preferredResources(Collection<EffectivePreferredResource> preferredResources) {
            this.preferredResources = EffectivePreferredResourcesCopier.copy(preferredResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredResources(EffectivePreferredResource ... preferredResources) {
            this.preferredResources(Arrays.asList(preferredResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredResources(Consumer<EffectivePreferredResource.Builder> ... preferredResources) {
            this.preferredResources(Stream.of(preferredResources).map(c -> (EffectivePreferredResource)((EffectivePreferredResource.Builder)EffectivePreferredResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSavingsEstimationMode() {
            return this.savingsEstimationMode;
        }

        public final void setSavingsEstimationMode(String savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode;
        }

        @Override
        public final Builder savingsEstimationMode(String savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode;
            return this;
        }

        @Override
        public final Builder savingsEstimationMode(SavingsEstimationMode savingsEstimationMode) {
            this.savingsEstimationMode(savingsEstimationMode == null ? null : savingsEstimationMode.toString());
            return this;
        }

        public RecommendationPreferencesDetail build() {
            return new RecommendationPreferencesDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationPreferencesDetail> {
        public Builder scope(Scope var1);

        default public Builder scope(Consumer<Scope.Builder> scope) {
            return this.scope((Scope)((Scope.Builder)Scope.builder().applyMutation(scope)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder enhancedInfrastructureMetrics(String var1);

        public Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics var1);

        public Builder inferredWorkloadTypes(String var1);

        public Builder inferredWorkloadTypes(InferredWorkloadTypesPreference var1);

        public Builder externalMetricsPreference(ExternalMetricsPreference var1);

        default public Builder externalMetricsPreference(Consumer<ExternalMetricsPreference.Builder> externalMetricsPreference) {
            return this.externalMetricsPreference((ExternalMetricsPreference)((ExternalMetricsPreference.Builder)ExternalMetricsPreference.builder().applyMutation(externalMetricsPreference)).build());
        }

        public Builder lookBackPeriod(String var1);

        public Builder lookBackPeriod(LookBackPeriodPreference var1);

        public Builder utilizationPreferences(Collection<UtilizationPreference> var1);

        public Builder utilizationPreferences(UtilizationPreference ... var1);

        public Builder utilizationPreferences(Consumer<UtilizationPreference.Builder> ... var1);

        public Builder preferredResources(Collection<EffectivePreferredResource> var1);

        public Builder preferredResources(EffectivePreferredResource ... var1);

        public Builder preferredResources(Consumer<EffectivePreferredResource.Builder> ... var1);

        public Builder savingsEstimationMode(String var1);

        public Builder savingsEstimationMode(SavingsEstimationMode var1);
    }
}

