/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RDSSavingsEstimationModeSource {
    PUBLIC_PRICING("PublicPricing"),
    COST_EXPLORER_RIGHTSIZING("CostExplorerRightsizing"),
    COST_OPTIMIZATION_HUB("CostOptimizationHub"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RDSSavingsEstimationModeSource> VALUE_MAP;
    private final String value;

    private RDSSavingsEstimationModeSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RDSSavingsEstimationModeSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RDSSavingsEstimationModeSource> knownValues() {
        EnumSet<RDSSavingsEstimationModeSource> knownValues = EnumSet.allOf(RDSSavingsEstimationModeSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RDSSavingsEstimationModeSource.class, RDSSavingsEstimationModeSource::toString);
    }
}

