/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.DBStorageConfiguration;
import software.amazon.awssdk.services.computeoptimizer.model.Idle;
import software.amazon.awssdk.services.computeoptimizer.model.RDSCurrentInstancePerformanceRisk;
import software.amazon.awssdk.services.computeoptimizer.model.RDSDBInstanceRecommendationOption;
import software.amazon.awssdk.services.computeoptimizer.model.RDSDBInstanceRecommendationOptionsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.RDSDBStorageRecommendationOption;
import software.amazon.awssdk.services.computeoptimizer.model.RDSDBStorageRecommendationOptionsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.RDSDBUtilizationMetric;
import software.amazon.awssdk.services.computeoptimizer.model.RDSDBUtilizationMetricsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.RDSEffectiveRecommendationPreferences;
import software.amazon.awssdk.services.computeoptimizer.model.RDSInstanceFinding;
import software.amazon.awssdk.services.computeoptimizer.model.RDSInstanceFindingReasonCode;
import software.amazon.awssdk.services.computeoptimizer.model.RDSInstanceFindingReasonCodesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.RDSStorageFinding;
import software.amazon.awssdk.services.computeoptimizer.model.RDSStorageFindingReasonCode;
import software.amazon.awssdk.services.computeoptimizer.model.RDSStorageFindingReasonCodesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.Tag;
import software.amazon.awssdk.services.computeoptimizer.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RDSDBRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RDSDBRecommendation> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(RDSDBRecommendation.getter(RDSDBRecommendation::resourceArn)).setter(RDSDBRecommendation.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(RDSDBRecommendation.getter(RDSDBRecommendation::accountId)).setter(RDSDBRecommendation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engine").getter(RDSDBRecommendation.getter(RDSDBRecommendation::engine)).setter(RDSDBRecommendation.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engineVersion").getter(RDSDBRecommendation.getter(RDSDBRecommendation::engineVersion)).setter(RDSDBRecommendation.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()}).build();
    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("promotionTier").getter(RDSDBRecommendation.getter(RDSDBRecommendation::promotionTier)).setter(RDSDBRecommendation.setter(Builder::promotionTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promotionTier").build()}).build();
    private static final SdkField<String> CURRENT_DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentDBInstanceClass").getter(RDSDBRecommendation.getter(RDSDBRecommendation::currentDBInstanceClass)).setter(RDSDBRecommendation.setter(Builder::currentDBInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentDBInstanceClass").build()}).build();
    private static final SdkField<DBStorageConfiguration> CURRENT_STORAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentStorageConfiguration").getter(RDSDBRecommendation.getter(RDSDBRecommendation::currentStorageConfiguration)).setter(RDSDBRecommendation.setter(Builder::currentStorageConfiguration)).constructor(DBStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentStorageConfiguration").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbClusterIdentifier").getter(RDSDBRecommendation.getter(RDSDBRecommendation::dbClusterIdentifier)).setter(RDSDBRecommendation.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbClusterIdentifier").build()}).build();
    private static final SdkField<String> IDLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("idle").getter(RDSDBRecommendation.getter(RDSDBRecommendation::idleAsString)).setter(RDSDBRecommendation.setter(Builder::idle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idle").build()}).build();
    private static final SdkField<String> INSTANCE_FINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceFinding").getter(RDSDBRecommendation.getter(RDSDBRecommendation::instanceFindingAsString)).setter(RDSDBRecommendation.setter(Builder::instanceFinding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceFinding").build()}).build();
    private static final SdkField<String> STORAGE_FINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageFinding").getter(RDSDBRecommendation.getter(RDSDBRecommendation::storageFindingAsString)).setter(RDSDBRecommendation.setter(Builder::storageFinding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageFinding").build()}).build();
    private static final SdkField<List<String>> INSTANCE_FINDING_REASON_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceFindingReasonCodes").getter(RDSDBRecommendation.getter(RDSDBRecommendation::instanceFindingReasonCodesAsStrings)).setter(RDSDBRecommendation.setter(Builder::instanceFindingReasonCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceFindingReasonCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CURRENT_INSTANCE_PERFORMANCE_RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentInstancePerformanceRisk").getter(RDSDBRecommendation.getter(RDSDBRecommendation::currentInstancePerformanceRiskAsString)).setter(RDSDBRecommendation.setter(Builder::currentInstancePerformanceRisk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentInstancePerformanceRisk").build()}).build();
    private static final SdkField<List<String>> STORAGE_FINDING_REASON_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("storageFindingReasonCodes").getter(RDSDBRecommendation.getter(RDSDBRecommendation::storageFindingReasonCodesAsStrings)).setter(RDSDBRecommendation.setter(Builder::storageFindingReasonCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageFindingReasonCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RDSDBInstanceRecommendationOption>> INSTANCE_RECOMMENDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceRecommendationOptions").getter(RDSDBRecommendation.getter(RDSDBRecommendation::instanceRecommendationOptions)).setter(RDSDBRecommendation.setter(Builder::instanceRecommendationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceRecommendationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RDSDBInstanceRecommendationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RDSDBStorageRecommendationOption>> STORAGE_RECOMMENDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("storageRecommendationOptions").getter(RDSDBRecommendation.getter(RDSDBRecommendation::storageRecommendationOptions)).setter(RDSDBRecommendation.setter(Builder::storageRecommendationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageRecommendationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RDSDBStorageRecommendationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RDSDBUtilizationMetric>> UTILIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("utilizationMetrics").getter(RDSDBRecommendation.getter(RDSDBRecommendation::utilizationMetrics)).setter(RDSDBRecommendation.setter(Builder::utilizationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RDSDBUtilizationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RDSEffectiveRecommendationPreferences> EFFECTIVE_RECOMMENDATION_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("effectiveRecommendationPreferences").getter(RDSDBRecommendation.getter(RDSDBRecommendation::effectiveRecommendationPreferences)).setter(RDSDBRecommendation.setter(Builder::effectiveRecommendationPreferences)).constructor(RDSEffectiveRecommendationPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveRecommendationPreferences").build()}).build();
    private static final SdkField<Double> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("lookbackPeriodInDays").getter(RDSDBRecommendation.getter(RDSDBRecommendation::lookbackPeriodInDays)).setter(RDSDBRecommendation.setter(Builder::lookbackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookbackPeriodInDays").build()}).build();
    private static final SdkField<Instant> LAST_REFRESH_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRefreshTimestamp").getter(RDSDBRecommendation.getter(RDSDBRecommendation::lastRefreshTimestamp)).setter(RDSDBRecommendation.setter(Builder::lastRefreshTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTimestamp").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(RDSDBRecommendation.getter(RDSDBRecommendation::tags)).setter(RDSDBRecommendation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, ACCOUNT_ID_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, PROMOTION_TIER_FIELD, CURRENT_DB_INSTANCE_CLASS_FIELD, CURRENT_STORAGE_CONFIGURATION_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, IDLE_FIELD, INSTANCE_FINDING_FIELD, STORAGE_FINDING_FIELD, INSTANCE_FINDING_REASON_CODES_FIELD, CURRENT_INSTANCE_PERFORMANCE_RISK_FIELD, STORAGE_FINDING_REASON_CODES_FIELD, INSTANCE_RECOMMENDATION_OPTIONS_FIELD, STORAGE_RECOMMENDATION_OPTIONS_FIELD, UTILIZATION_METRICS_FIELD, EFFECTIVE_RECOMMENDATION_PREFERENCES_FIELD, LOOKBACK_PERIOD_IN_DAYS_FIELD, LAST_REFRESH_TIMESTAMP_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceArn", RESOURCE_ARN_FIELD);
            this.put("accountId", ACCOUNT_ID_FIELD);
            this.put("engine", ENGINE_FIELD);
            this.put("engineVersion", ENGINE_VERSION_FIELD);
            this.put("promotionTier", PROMOTION_TIER_FIELD);
            this.put("currentDBInstanceClass", CURRENT_DB_INSTANCE_CLASS_FIELD);
            this.put("currentStorageConfiguration", CURRENT_STORAGE_CONFIGURATION_FIELD);
            this.put("dbClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
            this.put("idle", IDLE_FIELD);
            this.put("instanceFinding", INSTANCE_FINDING_FIELD);
            this.put("storageFinding", STORAGE_FINDING_FIELD);
            this.put("instanceFindingReasonCodes", INSTANCE_FINDING_REASON_CODES_FIELD);
            this.put("currentInstancePerformanceRisk", CURRENT_INSTANCE_PERFORMANCE_RISK_FIELD);
            this.put("storageFindingReasonCodes", STORAGE_FINDING_REASON_CODES_FIELD);
            this.put("instanceRecommendationOptions", INSTANCE_RECOMMENDATION_OPTIONS_FIELD);
            this.put("storageRecommendationOptions", STORAGE_RECOMMENDATION_OPTIONS_FIELD);
            this.put("utilizationMetrics", UTILIZATION_METRICS_FIELD);
            this.put("effectiveRecommendationPreferences", EFFECTIVE_RECOMMENDATION_PREFERENCES_FIELD);
            this.put("lookbackPeriodInDays", LOOKBACK_PERIOD_IN_DAYS_FIELD);
            this.put("lastRefreshTimestamp", LAST_REFRESH_TIMESTAMP_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final String accountId;
    private final String engine;
    private final String engineVersion;
    private final Integer promotionTier;
    private final String currentDBInstanceClass;
    private final DBStorageConfiguration currentStorageConfiguration;
    private final String dbClusterIdentifier;
    private final String idle;
    private final String instanceFinding;
    private final String storageFinding;
    private final List<String> instanceFindingReasonCodes;
    private final String currentInstancePerformanceRisk;
    private final List<String> storageFindingReasonCodes;
    private final List<RDSDBInstanceRecommendationOption> instanceRecommendationOptions;
    private final List<RDSDBStorageRecommendationOption> storageRecommendationOptions;
    private final List<RDSDBUtilizationMetric> utilizationMetrics;
    private final RDSEffectiveRecommendationPreferences effectiveRecommendationPreferences;
    private final Double lookbackPeriodInDays;
    private final Instant lastRefreshTimestamp;
    private final List<Tag> tags;

    private RDSDBRecommendation(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.accountId = builder.accountId;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.promotionTier = builder.promotionTier;
        this.currentDBInstanceClass = builder.currentDBInstanceClass;
        this.currentStorageConfiguration = builder.currentStorageConfiguration;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.idle = builder.idle;
        this.instanceFinding = builder.instanceFinding;
        this.storageFinding = builder.storageFinding;
        this.instanceFindingReasonCodes = builder.instanceFindingReasonCodes;
        this.currentInstancePerformanceRisk = builder.currentInstancePerformanceRisk;
        this.storageFindingReasonCodes = builder.storageFindingReasonCodes;
        this.instanceRecommendationOptions = builder.instanceRecommendationOptions;
        this.storageRecommendationOptions = builder.storageRecommendationOptions;
        this.utilizationMetrics = builder.utilizationMetrics;
        this.effectiveRecommendationPreferences = builder.effectiveRecommendationPreferences;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.lastRefreshTimestamp = builder.lastRefreshTimestamp;
        this.tags = builder.tags;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Integer promotionTier() {
        return this.promotionTier;
    }

    public final String currentDBInstanceClass() {
        return this.currentDBInstanceClass;
    }

    public final DBStorageConfiguration currentStorageConfiguration() {
        return this.currentStorageConfiguration;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final Idle idle() {
        return Idle.fromValue(this.idle);
    }

    public final String idleAsString() {
        return this.idle;
    }

    public final RDSInstanceFinding instanceFinding() {
        return RDSInstanceFinding.fromValue(this.instanceFinding);
    }

    public final String instanceFindingAsString() {
        return this.instanceFinding;
    }

    public final RDSStorageFinding storageFinding() {
        return RDSStorageFinding.fromValue(this.storageFinding);
    }

    public final String storageFindingAsString() {
        return this.storageFinding;
    }

    public final List<RDSInstanceFindingReasonCode> instanceFindingReasonCodes() {
        return RDSInstanceFindingReasonCodesCopier.copyStringToEnum(this.instanceFindingReasonCodes);
    }

    public final boolean hasInstanceFindingReasonCodes() {
        return this.instanceFindingReasonCodes != null && !(this.instanceFindingReasonCodes instanceof SdkAutoConstructList);
    }

    public final List<String> instanceFindingReasonCodesAsStrings() {
        return this.instanceFindingReasonCodes;
    }

    public final RDSCurrentInstancePerformanceRisk currentInstancePerformanceRisk() {
        return RDSCurrentInstancePerformanceRisk.fromValue(this.currentInstancePerformanceRisk);
    }

    public final String currentInstancePerformanceRiskAsString() {
        return this.currentInstancePerformanceRisk;
    }

    public final List<RDSStorageFindingReasonCode> storageFindingReasonCodes() {
        return RDSStorageFindingReasonCodesCopier.copyStringToEnum(this.storageFindingReasonCodes);
    }

    public final boolean hasStorageFindingReasonCodes() {
        return this.storageFindingReasonCodes != null && !(this.storageFindingReasonCodes instanceof SdkAutoConstructList);
    }

    public final List<String> storageFindingReasonCodesAsStrings() {
        return this.storageFindingReasonCodes;
    }

    public final boolean hasInstanceRecommendationOptions() {
        return this.instanceRecommendationOptions != null && !(this.instanceRecommendationOptions instanceof SdkAutoConstructList);
    }

    public final List<RDSDBInstanceRecommendationOption> instanceRecommendationOptions() {
        return this.instanceRecommendationOptions;
    }

    public final boolean hasStorageRecommendationOptions() {
        return this.storageRecommendationOptions != null && !(this.storageRecommendationOptions instanceof SdkAutoConstructList);
    }

    public final List<RDSDBStorageRecommendationOption> storageRecommendationOptions() {
        return this.storageRecommendationOptions;
    }

    public final boolean hasUtilizationMetrics() {
        return this.utilizationMetrics != null && !(this.utilizationMetrics instanceof SdkAutoConstructList);
    }

    public final List<RDSDBUtilizationMetric> utilizationMetrics() {
        return this.utilizationMetrics;
    }

    public final RDSEffectiveRecommendationPreferences effectiveRecommendationPreferences() {
        return this.effectiveRecommendationPreferences;
    }

    public final Double lookbackPeriodInDays() {
        return this.lookbackPeriodInDays;
    }

    public final Instant lastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.promotionTier());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentDBInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentStorageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFindingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageFindingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceFindingReasonCodes() ? this.instanceFindingReasonCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInstancePerformanceRiskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageFindingReasonCodes() ? this.storageFindingReasonCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceRecommendationOptions() ? this.instanceRecommendationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageRecommendationOptions() ? this.storageRecommendationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUtilizationMetrics() ? this.utilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveRecommendationPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDBRecommendation)) {
            return false;
        }
        RDSDBRecommendation other = (RDSDBRecommendation)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.promotionTier(), other.promotionTier()) && Objects.equals(this.currentDBInstanceClass(), other.currentDBInstanceClass()) && Objects.equals(this.currentStorageConfiguration(), other.currentStorageConfiguration()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.idleAsString(), other.idleAsString()) && Objects.equals(this.instanceFindingAsString(), other.instanceFindingAsString()) && Objects.equals(this.storageFindingAsString(), other.storageFindingAsString()) && this.hasInstanceFindingReasonCodes() == other.hasInstanceFindingReasonCodes() && Objects.equals(this.instanceFindingReasonCodesAsStrings(), other.instanceFindingReasonCodesAsStrings()) && Objects.equals(this.currentInstancePerformanceRiskAsString(), other.currentInstancePerformanceRiskAsString()) && this.hasStorageFindingReasonCodes() == other.hasStorageFindingReasonCodes() && Objects.equals(this.storageFindingReasonCodesAsStrings(), other.storageFindingReasonCodesAsStrings()) && this.hasInstanceRecommendationOptions() == other.hasInstanceRecommendationOptions() && Objects.equals(this.instanceRecommendationOptions(), other.instanceRecommendationOptions()) && this.hasStorageRecommendationOptions() == other.hasStorageRecommendationOptions() && Objects.equals(this.storageRecommendationOptions(), other.storageRecommendationOptions()) && this.hasUtilizationMetrics() == other.hasUtilizationMetrics() && Objects.equals(this.utilizationMetrics(), other.utilizationMetrics()) && Objects.equals(this.effectiveRecommendationPreferences(), other.effectiveRecommendationPreferences()) && Objects.equals(this.lookbackPeriodInDays(), other.lookbackPeriodInDays()) && Objects.equals(this.lastRefreshTimestamp(), other.lastRefreshTimestamp()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RDSDBRecommendation").add("ResourceArn", (Object)this.resourceArn()).add("AccountId", (Object)this.accountId()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("PromotionTier", (Object)this.promotionTier()).add("CurrentDBInstanceClass", (Object)this.currentDBInstanceClass()).add("CurrentStorageConfiguration", (Object)this.currentStorageConfiguration()).add("DbClusterIdentifier", (Object)this.dbClusterIdentifier()).add("Idle", (Object)this.idleAsString()).add("InstanceFinding", (Object)this.instanceFindingAsString()).add("StorageFinding", (Object)this.storageFindingAsString()).add("InstanceFindingReasonCodes", this.hasInstanceFindingReasonCodes() ? this.instanceFindingReasonCodesAsStrings() : null).add("CurrentInstancePerformanceRisk", (Object)this.currentInstancePerformanceRiskAsString()).add("StorageFindingReasonCodes", this.hasStorageFindingReasonCodes() ? this.storageFindingReasonCodesAsStrings() : null).add("InstanceRecommendationOptions", this.hasInstanceRecommendationOptions() ? this.instanceRecommendationOptions() : null).add("StorageRecommendationOptions", this.hasStorageRecommendationOptions() ? this.storageRecommendationOptions() : null).add("UtilizationMetrics", this.hasUtilizationMetrics() ? this.utilizationMetrics() : null).add("EffectiveRecommendationPreferences", (Object)this.effectiveRecommendationPreferences()).add("LookbackPeriodInDays", (Object)this.lookbackPeriodInDays()).add("LastRefreshTimestamp", (Object)this.lastRefreshTimestamp()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "engineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "promotionTier": {
                return Optional.ofNullable(clazz.cast(this.promotionTier()));
            }
            case "currentDBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.currentDBInstanceClass()));
            }
            case "currentStorageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.currentStorageConfiguration()));
            }
            case "dbClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "idle": {
                return Optional.ofNullable(clazz.cast(this.idleAsString()));
            }
            case "instanceFinding": {
                return Optional.ofNullable(clazz.cast(this.instanceFindingAsString()));
            }
            case "storageFinding": {
                return Optional.ofNullable(clazz.cast(this.storageFindingAsString()));
            }
            case "instanceFindingReasonCodes": {
                return Optional.ofNullable(clazz.cast(this.instanceFindingReasonCodesAsStrings()));
            }
            case "currentInstancePerformanceRisk": {
                return Optional.ofNullable(clazz.cast(this.currentInstancePerformanceRiskAsString()));
            }
            case "storageFindingReasonCodes": {
                return Optional.ofNullable(clazz.cast(this.storageFindingReasonCodesAsStrings()));
            }
            case "instanceRecommendationOptions": {
                return Optional.ofNullable(clazz.cast(this.instanceRecommendationOptions()));
            }
            case "storageRecommendationOptions": {
                return Optional.ofNullable(clazz.cast(this.storageRecommendationOptions()));
            }
            case "utilizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.utilizationMetrics()));
            }
            case "effectiveRecommendationPreferences": {
                return Optional.ofNullable(clazz.cast(this.effectiveRecommendationPreferences()));
            }
            case "lookbackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookbackPeriodInDays()));
            }
            case "lastRefreshTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshTimestamp()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RDSDBRecommendation, T> g) {
        return obj -> g.apply((RDSDBRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private String accountId;
        private String engine;
        private String engineVersion;
        private Integer promotionTier;
        private String currentDBInstanceClass;
        private DBStorageConfiguration currentStorageConfiguration;
        private String dbClusterIdentifier;
        private String idle;
        private String instanceFinding;
        private String storageFinding;
        private List<String> instanceFindingReasonCodes = DefaultSdkAutoConstructList.getInstance();
        private String currentInstancePerformanceRisk;
        private List<String> storageFindingReasonCodes = DefaultSdkAutoConstructList.getInstance();
        private List<RDSDBInstanceRecommendationOption> instanceRecommendationOptions = DefaultSdkAutoConstructList.getInstance();
        private List<RDSDBStorageRecommendationOption> storageRecommendationOptions = DefaultSdkAutoConstructList.getInstance();
        private List<RDSDBUtilizationMetric> utilizationMetrics = DefaultSdkAutoConstructList.getInstance();
        private RDSEffectiveRecommendationPreferences effectiveRecommendationPreferences;
        private Double lookbackPeriodInDays;
        private Instant lastRefreshTimestamp;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDBRecommendation model) {
            this.resourceArn(model.resourceArn);
            this.accountId(model.accountId);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.promotionTier(model.promotionTier);
            this.currentDBInstanceClass(model.currentDBInstanceClass);
            this.currentStorageConfiguration(model.currentStorageConfiguration);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.idle(model.idle);
            this.instanceFinding(model.instanceFinding);
            this.storageFinding(model.storageFinding);
            this.instanceFindingReasonCodesWithStrings(model.instanceFindingReasonCodes);
            this.currentInstancePerformanceRisk(model.currentInstancePerformanceRisk);
            this.storageFindingReasonCodesWithStrings(model.storageFindingReasonCodes);
            this.instanceRecommendationOptions(model.instanceRecommendationOptions);
            this.storageRecommendationOptions(model.storageRecommendationOptions);
            this.utilizationMetrics(model.utilizationMetrics);
            this.effectiveRecommendationPreferences(model.effectiveRecommendationPreferences);
            this.lookbackPeriodInDays(model.lookbackPeriodInDays);
            this.lastRefreshTimestamp(model.lastRefreshTimestamp);
            this.tags(model.tags);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Integer getPromotionTier() {
            return this.promotionTier;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final String getCurrentDBInstanceClass() {
            return this.currentDBInstanceClass;
        }

        public final void setCurrentDBInstanceClass(String currentDBInstanceClass) {
            this.currentDBInstanceClass = currentDBInstanceClass;
        }

        @Override
        public final Builder currentDBInstanceClass(String currentDBInstanceClass) {
            this.currentDBInstanceClass = currentDBInstanceClass;
            return this;
        }

        public final DBStorageConfiguration.Builder getCurrentStorageConfiguration() {
            return this.currentStorageConfiguration != null ? this.currentStorageConfiguration.toBuilder() : null;
        }

        public final void setCurrentStorageConfiguration(DBStorageConfiguration.BuilderImpl currentStorageConfiguration) {
            this.currentStorageConfiguration = currentStorageConfiguration != null ? currentStorageConfiguration.build() : null;
        }

        @Override
        public final Builder currentStorageConfiguration(DBStorageConfiguration currentStorageConfiguration) {
            this.currentStorageConfiguration = currentStorageConfiguration;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getIdle() {
            return this.idle;
        }

        public final void setIdle(String idle) {
            this.idle = idle;
        }

        @Override
        public final Builder idle(String idle) {
            this.idle = idle;
            return this;
        }

        @Override
        public final Builder idle(Idle idle) {
            this.idle(idle == null ? null : idle.toString());
            return this;
        }

        public final String getInstanceFinding() {
            return this.instanceFinding;
        }

        public final void setInstanceFinding(String instanceFinding) {
            this.instanceFinding = instanceFinding;
        }

        @Override
        public final Builder instanceFinding(String instanceFinding) {
            this.instanceFinding = instanceFinding;
            return this;
        }

        @Override
        public final Builder instanceFinding(RDSInstanceFinding instanceFinding) {
            this.instanceFinding(instanceFinding == null ? null : instanceFinding.toString());
            return this;
        }

        public final String getStorageFinding() {
            return this.storageFinding;
        }

        public final void setStorageFinding(String storageFinding) {
            this.storageFinding = storageFinding;
        }

        @Override
        public final Builder storageFinding(String storageFinding) {
            this.storageFinding = storageFinding;
            return this;
        }

        @Override
        public final Builder storageFinding(RDSStorageFinding storageFinding) {
            this.storageFinding(storageFinding == null ? null : storageFinding.toString());
            return this;
        }

        public final Collection<String> getInstanceFindingReasonCodes() {
            if (this.instanceFindingReasonCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceFindingReasonCodes;
        }

        public final void setInstanceFindingReasonCodes(Collection<String> instanceFindingReasonCodes) {
            this.instanceFindingReasonCodes = RDSInstanceFindingReasonCodesCopier.copy(instanceFindingReasonCodes);
        }

        @Override
        public final Builder instanceFindingReasonCodesWithStrings(Collection<String> instanceFindingReasonCodes) {
            this.instanceFindingReasonCodes = RDSInstanceFindingReasonCodesCopier.copy(instanceFindingReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceFindingReasonCodesWithStrings(String ... instanceFindingReasonCodes) {
            this.instanceFindingReasonCodesWithStrings(Arrays.asList(instanceFindingReasonCodes));
            return this;
        }

        @Override
        public final Builder instanceFindingReasonCodes(Collection<RDSInstanceFindingReasonCode> instanceFindingReasonCodes) {
            this.instanceFindingReasonCodes = RDSInstanceFindingReasonCodesCopier.copyEnumToString(instanceFindingReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceFindingReasonCodes(RDSInstanceFindingReasonCode ... instanceFindingReasonCodes) {
            this.instanceFindingReasonCodes(Arrays.asList(instanceFindingReasonCodes));
            return this;
        }

        public final String getCurrentInstancePerformanceRisk() {
            return this.currentInstancePerformanceRisk;
        }

        public final void setCurrentInstancePerformanceRisk(String currentInstancePerformanceRisk) {
            this.currentInstancePerformanceRisk = currentInstancePerformanceRisk;
        }

        @Override
        public final Builder currentInstancePerformanceRisk(String currentInstancePerformanceRisk) {
            this.currentInstancePerformanceRisk = currentInstancePerformanceRisk;
            return this;
        }

        @Override
        public final Builder currentInstancePerformanceRisk(RDSCurrentInstancePerformanceRisk currentInstancePerformanceRisk) {
            this.currentInstancePerformanceRisk(currentInstancePerformanceRisk == null ? null : currentInstancePerformanceRisk.toString());
            return this;
        }

        public final Collection<String> getStorageFindingReasonCodes() {
            if (this.storageFindingReasonCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.storageFindingReasonCodes;
        }

        public final void setStorageFindingReasonCodes(Collection<String> storageFindingReasonCodes) {
            this.storageFindingReasonCodes = RDSStorageFindingReasonCodesCopier.copy(storageFindingReasonCodes);
        }

        @Override
        public final Builder storageFindingReasonCodesWithStrings(Collection<String> storageFindingReasonCodes) {
            this.storageFindingReasonCodes = RDSStorageFindingReasonCodesCopier.copy(storageFindingReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageFindingReasonCodesWithStrings(String ... storageFindingReasonCodes) {
            this.storageFindingReasonCodesWithStrings(Arrays.asList(storageFindingReasonCodes));
            return this;
        }

        @Override
        public final Builder storageFindingReasonCodes(Collection<RDSStorageFindingReasonCode> storageFindingReasonCodes) {
            this.storageFindingReasonCodes = RDSStorageFindingReasonCodesCopier.copyEnumToString(storageFindingReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageFindingReasonCodes(RDSStorageFindingReasonCode ... storageFindingReasonCodes) {
            this.storageFindingReasonCodes(Arrays.asList(storageFindingReasonCodes));
            return this;
        }

        public final List<RDSDBInstanceRecommendationOption.Builder> getInstanceRecommendationOptions() {
            List<RDSDBInstanceRecommendationOption.Builder> result = RDSDBInstanceRecommendationOptionsCopier.copyToBuilder(this.instanceRecommendationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceRecommendationOptions(Collection<RDSDBInstanceRecommendationOption.BuilderImpl> instanceRecommendationOptions) {
            this.instanceRecommendationOptions = RDSDBInstanceRecommendationOptionsCopier.copyFromBuilder(instanceRecommendationOptions);
        }

        @Override
        public final Builder instanceRecommendationOptions(Collection<RDSDBInstanceRecommendationOption> instanceRecommendationOptions) {
            this.instanceRecommendationOptions = RDSDBInstanceRecommendationOptionsCopier.copy(instanceRecommendationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceRecommendationOptions(RDSDBInstanceRecommendationOption ... instanceRecommendationOptions) {
            this.instanceRecommendationOptions(Arrays.asList(instanceRecommendationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceRecommendationOptions(Consumer<RDSDBInstanceRecommendationOption.Builder> ... instanceRecommendationOptions) {
            this.instanceRecommendationOptions(Stream.of(instanceRecommendationOptions).map(c -> (RDSDBInstanceRecommendationOption)((RDSDBInstanceRecommendationOption.Builder)RDSDBInstanceRecommendationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RDSDBStorageRecommendationOption.Builder> getStorageRecommendationOptions() {
            List<RDSDBStorageRecommendationOption.Builder> result = RDSDBStorageRecommendationOptionsCopier.copyToBuilder(this.storageRecommendationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageRecommendationOptions(Collection<RDSDBStorageRecommendationOption.BuilderImpl> storageRecommendationOptions) {
            this.storageRecommendationOptions = RDSDBStorageRecommendationOptionsCopier.copyFromBuilder(storageRecommendationOptions);
        }

        @Override
        public final Builder storageRecommendationOptions(Collection<RDSDBStorageRecommendationOption> storageRecommendationOptions) {
            this.storageRecommendationOptions = RDSDBStorageRecommendationOptionsCopier.copy(storageRecommendationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageRecommendationOptions(RDSDBStorageRecommendationOption ... storageRecommendationOptions) {
            this.storageRecommendationOptions(Arrays.asList(storageRecommendationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageRecommendationOptions(Consumer<RDSDBStorageRecommendationOption.Builder> ... storageRecommendationOptions) {
            this.storageRecommendationOptions(Stream.of(storageRecommendationOptions).map(c -> (RDSDBStorageRecommendationOption)((RDSDBStorageRecommendationOption.Builder)RDSDBStorageRecommendationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RDSDBUtilizationMetric.Builder> getUtilizationMetrics() {
            List<RDSDBUtilizationMetric.Builder> result = RDSDBUtilizationMetricsCopier.copyToBuilder(this.utilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtilizationMetrics(Collection<RDSDBUtilizationMetric.BuilderImpl> utilizationMetrics) {
            this.utilizationMetrics = RDSDBUtilizationMetricsCopier.copyFromBuilder(utilizationMetrics);
        }

        @Override
        public final Builder utilizationMetrics(Collection<RDSDBUtilizationMetric> utilizationMetrics) {
            this.utilizationMetrics = RDSDBUtilizationMetricsCopier.copy(utilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(RDSDBUtilizationMetric ... utilizationMetrics) {
            this.utilizationMetrics(Arrays.asList(utilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(Consumer<RDSDBUtilizationMetric.Builder> ... utilizationMetrics) {
            this.utilizationMetrics(Stream.of(utilizationMetrics).map(c -> (RDSDBUtilizationMetric)((RDSDBUtilizationMetric.Builder)RDSDBUtilizationMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RDSEffectiveRecommendationPreferences.Builder getEffectiveRecommendationPreferences() {
            return this.effectiveRecommendationPreferences != null ? this.effectiveRecommendationPreferences.toBuilder() : null;
        }

        public final void setEffectiveRecommendationPreferences(RDSEffectiveRecommendationPreferences.BuilderImpl effectiveRecommendationPreferences) {
            this.effectiveRecommendationPreferences = effectiveRecommendationPreferences != null ? effectiveRecommendationPreferences.build() : null;
        }

        @Override
        public final Builder effectiveRecommendationPreferences(RDSEffectiveRecommendationPreferences effectiveRecommendationPreferences) {
            this.effectiveRecommendationPreferences = effectiveRecommendationPreferences;
            return this;
        }

        public final Double getLookbackPeriodInDays() {
            return this.lookbackPeriodInDays;
        }

        public final void setLookbackPeriodInDays(Double lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        @Override
        public final Builder lookbackPeriodInDays(Double lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        public final Instant getLastRefreshTimestamp() {
            return this.lastRefreshTimestamp;
        }

        public final void setLastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
        }

        @Override
        public final Builder lastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RDSDBRecommendation build() {
            return new RDSDBRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RDSDBRecommendation> {
        public Builder resourceArn(String var1);

        public Builder accountId(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder promotionTier(Integer var1);

        public Builder currentDBInstanceClass(String var1);

        public Builder currentStorageConfiguration(DBStorageConfiguration var1);

        default public Builder currentStorageConfiguration(Consumer<DBStorageConfiguration.Builder> currentStorageConfiguration) {
            return this.currentStorageConfiguration((DBStorageConfiguration)((DBStorageConfiguration.Builder)DBStorageConfiguration.builder().applyMutation(currentStorageConfiguration)).build());
        }

        public Builder dbClusterIdentifier(String var1);

        public Builder idle(String var1);

        public Builder idle(Idle var1);

        public Builder instanceFinding(String var1);

        public Builder instanceFinding(RDSInstanceFinding var1);

        public Builder storageFinding(String var1);

        public Builder storageFinding(RDSStorageFinding var1);

        public Builder instanceFindingReasonCodesWithStrings(Collection<String> var1);

        public Builder instanceFindingReasonCodesWithStrings(String ... var1);

        public Builder instanceFindingReasonCodes(Collection<RDSInstanceFindingReasonCode> var1);

        public Builder instanceFindingReasonCodes(RDSInstanceFindingReasonCode ... var1);

        public Builder currentInstancePerformanceRisk(String var1);

        public Builder currentInstancePerformanceRisk(RDSCurrentInstancePerformanceRisk var1);

        public Builder storageFindingReasonCodesWithStrings(Collection<String> var1);

        public Builder storageFindingReasonCodesWithStrings(String ... var1);

        public Builder storageFindingReasonCodes(Collection<RDSStorageFindingReasonCode> var1);

        public Builder storageFindingReasonCodes(RDSStorageFindingReasonCode ... var1);

        public Builder instanceRecommendationOptions(Collection<RDSDBInstanceRecommendationOption> var1);

        public Builder instanceRecommendationOptions(RDSDBInstanceRecommendationOption ... var1);

        public Builder instanceRecommendationOptions(Consumer<RDSDBInstanceRecommendationOption.Builder> ... var1);

        public Builder storageRecommendationOptions(Collection<RDSDBStorageRecommendationOption> var1);

        public Builder storageRecommendationOptions(RDSDBStorageRecommendationOption ... var1);

        public Builder storageRecommendationOptions(Consumer<RDSDBStorageRecommendationOption.Builder> ... var1);

        public Builder utilizationMetrics(Collection<RDSDBUtilizationMetric> var1);

        public Builder utilizationMetrics(RDSDBUtilizationMetric ... var1);

        public Builder utilizationMetrics(Consumer<RDSDBUtilizationMetric.Builder> ... var1);

        public Builder effectiveRecommendationPreferences(RDSEffectiveRecommendationPreferences var1);

        default public Builder effectiveRecommendationPreferences(Consumer<RDSEffectiveRecommendationPreferences.Builder> effectiveRecommendationPreferences) {
            return this.effectiveRecommendationPreferences((RDSEffectiveRecommendationPreferences)((RDSEffectiveRecommendationPreferences.Builder)RDSEffectiveRecommendationPreferences.builder().applyMutation(effectiveRecommendationPreferences)).build());
        }

        public Builder lookbackPeriodInDays(Double var1);

        public Builder lastRefreshTimestamp(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

