/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBStorageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBStorageConfiguration> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageType").getter(DBStorageConfiguration.getter(DBStorageConfiguration::storageType)).setter(DBStorageConfiguration.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("allocatedStorage").getter(DBStorageConfiguration.getter(DBStorageConfiguration::allocatedStorage)).setter(DBStorageConfiguration.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocatedStorage").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("iops").getter(DBStorageConfiguration.getter(DBStorageConfiguration::iops)).setter(DBStorageConfiguration.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()}).build();
    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxAllocatedStorage").getter(DBStorageConfiguration.getter(DBStorageConfiguration::maxAllocatedStorage)).setter(DBStorageConfiguration.setter(Builder::maxAllocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAllocatedStorage").build()}).build();
    private static final SdkField<Integer> STORAGE_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageThroughput").getter(DBStorageConfiguration.getter(DBStorageConfiguration::storageThroughput)).setter(DBStorageConfiguration.setter(Builder::storageThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageThroughput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD, ALLOCATED_STORAGE_FIELD, IOPS_FIELD, MAX_ALLOCATED_STORAGE_FIELD, STORAGE_THROUGHPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("storageType", STORAGE_TYPE_FIELD);
            this.put("allocatedStorage", ALLOCATED_STORAGE_FIELD);
            this.put("iops", IOPS_FIELD);
            this.put("maxAllocatedStorage", MAX_ALLOCATED_STORAGE_FIELD);
            this.put("storageThroughput", STORAGE_THROUGHPUT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String storageType;
    private final Integer allocatedStorage;
    private final Integer iops;
    private final Integer maxAllocatedStorage;
    private final Integer storageThroughput;

    private DBStorageConfiguration(BuilderImpl builder) {
        this.storageType = builder.storageType;
        this.allocatedStorage = builder.allocatedStorage;
        this.iops = builder.iops;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.storageThroughput = builder.storageThroughput;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final Integer maxAllocatedStorage() {
        return this.maxAllocatedStorage;
    }

    public final Integer storageThroughput() {
        return this.storageThroughput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageThroughput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBStorageConfiguration)) {
            return false;
        }
        DBStorageConfiguration other = (DBStorageConfiguration)obj;
        return Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.maxAllocatedStorage(), other.maxAllocatedStorage()) && Objects.equals(this.storageThroughput(), other.storageThroughput());
    }

    public final String toString() {
        return ToString.builder((String)"DBStorageConfiguration").add("StorageType", (Object)this.storageType()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("Iops", (Object)this.iops()).add("MaxAllocatedStorage", (Object)this.maxAllocatedStorage()).add("StorageThroughput", (Object)this.storageThroughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "storageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "allocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "maxAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.maxAllocatedStorage()));
            }
            case "storageThroughput": {
                return Optional.ofNullable(clazz.cast(this.storageThroughput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DBStorageConfiguration, T> g) {
        return obj -> g.apply((DBStorageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String storageType;
        private Integer allocatedStorage;
        private Integer iops;
        private Integer maxAllocatedStorage;
        private Integer storageThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(DBStorageConfiguration model) {
            this.storageType(model.storageType);
            this.allocatedStorage(model.allocatedStorage);
            this.iops(model.iops);
            this.maxAllocatedStorage(model.maxAllocatedStorage);
            this.storageThroughput(model.storageThroughput);
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getMaxAllocatedStorage() {
            return this.maxAllocatedStorage;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final Integer getStorageThroughput() {
            return this.storageThroughput;
        }

        public final void setStorageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
        }

        @Override
        public final Builder storageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
            return this;
        }

        public DBStorageConfiguration build() {
            return new DBStorageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBStorageConfiguration> {
        public Builder storageType(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder iops(Integer var1);

        public Builder maxAllocatedStorage(Integer var1);

        public Builder storageThroughput(Integer var1);
    }
}

