/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.DBStorageConfiguration;
import software.amazon.awssdk.services.computeoptimizer.model.RDSStorageSavingsOpportunityAfterDiscounts;
import software.amazon.awssdk.services.computeoptimizer.model.SavingsOpportunity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RDSDBStorageRecommendationOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RDSDBStorageRecommendationOption> {
    private static final SdkField<DBStorageConfiguration> STORAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageConfiguration").getter(RDSDBStorageRecommendationOption.getter(RDSDBStorageRecommendationOption::storageConfiguration)).setter(RDSDBStorageRecommendationOption.setter(Builder::storageConfiguration)).constructor(DBStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfiguration").build()}).build();
    private static final SdkField<Integer> RANK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("rank").getter(RDSDBStorageRecommendationOption.getter(RDSDBStorageRecommendationOption::rank)).setter(RDSDBStorageRecommendationOption.setter(Builder::rank)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()}).build();
    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunity").getter(RDSDBStorageRecommendationOption.getter(RDSDBStorageRecommendationOption::savingsOpportunity)).setter(RDSDBStorageRecommendationOption.setter(Builder::savingsOpportunity)).constructor(SavingsOpportunity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build()}).build();
    private static final SdkField<RDSStorageSavingsOpportunityAfterDiscounts> SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunityAfterDiscounts").getter(RDSDBStorageRecommendationOption.getter(RDSDBStorageRecommendationOption::savingsOpportunityAfterDiscounts)).setter(RDSDBStorageRecommendationOption.setter(Builder::savingsOpportunityAfterDiscounts)).constructor(RDSStorageSavingsOpportunityAfterDiscounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityAfterDiscounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_CONFIGURATION_FIELD, RANK_FIELD, SAVINGS_OPPORTUNITY_FIELD, SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("storageConfiguration", STORAGE_CONFIGURATION_FIELD);
            this.put("rank", RANK_FIELD);
            this.put("savingsOpportunity", SAVINGS_OPPORTUNITY_FIELD);
            this.put("savingsOpportunityAfterDiscounts", SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final DBStorageConfiguration storageConfiguration;
    private final Integer rank;
    private final SavingsOpportunity savingsOpportunity;
    private final RDSStorageSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

    private RDSDBStorageRecommendationOption(BuilderImpl builder) {
        this.storageConfiguration = builder.storageConfiguration;
        this.rank = builder.rank;
        this.savingsOpportunity = builder.savingsOpportunity;
        this.savingsOpportunityAfterDiscounts = builder.savingsOpportunityAfterDiscounts;
    }

    public final DBStorageConfiguration storageConfiguration() {
        return this.storageConfiguration;
    }

    public final Integer rank() {
        return this.rank;
    }

    public final SavingsOpportunity savingsOpportunity() {
        return this.savingsOpportunity;
    }

    public final RDSStorageSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts() {
        return this.savingsOpportunityAfterDiscounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.rank());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunityAfterDiscounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDBStorageRecommendationOption)) {
            return false;
        }
        RDSDBStorageRecommendationOption other = (RDSDBStorageRecommendationOption)obj;
        return Objects.equals(this.storageConfiguration(), other.storageConfiguration()) && Objects.equals(this.rank(), other.rank()) && Objects.equals(this.savingsOpportunity(), other.savingsOpportunity()) && Objects.equals(this.savingsOpportunityAfterDiscounts(), other.savingsOpportunityAfterDiscounts());
    }

    public final String toString() {
        return ToString.builder((String)"RDSDBStorageRecommendationOption").add("StorageConfiguration", (Object)this.storageConfiguration()).add("Rank", (Object)this.rank()).add("SavingsOpportunity", (Object)this.savingsOpportunity()).add("SavingsOpportunityAfterDiscounts", (Object)this.savingsOpportunityAfterDiscounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "storageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.storageConfiguration()));
            }
            case "rank": {
                return Optional.ofNullable(clazz.cast(this.rank()));
            }
            case "savingsOpportunity": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunity()));
            }
            case "savingsOpportunityAfterDiscounts": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunityAfterDiscounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RDSDBStorageRecommendationOption, T> g) {
        return obj -> g.apply((RDSDBStorageRecommendationOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DBStorageConfiguration storageConfiguration;
        private Integer rank;
        private SavingsOpportunity savingsOpportunity;
        private RDSStorageSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDBStorageRecommendationOption model) {
            this.storageConfiguration(model.storageConfiguration);
            this.rank(model.rank);
            this.savingsOpportunity(model.savingsOpportunity);
            this.savingsOpportunityAfterDiscounts(model.savingsOpportunityAfterDiscounts);
        }

        public final DBStorageConfiguration.Builder getStorageConfiguration() {
            return this.storageConfiguration != null ? this.storageConfiguration.toBuilder() : null;
        }

        public final void setStorageConfiguration(DBStorageConfiguration.BuilderImpl storageConfiguration) {
            this.storageConfiguration = storageConfiguration != null ? storageConfiguration.build() : null;
        }

        @Override
        public final Builder storageConfiguration(DBStorageConfiguration storageConfiguration) {
            this.storageConfiguration = storageConfiguration;
            return this;
        }

        public final Integer getRank() {
            return this.rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return this.savingsOpportunity != null ? this.savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public final RDSStorageSavingsOpportunityAfterDiscounts.Builder getSavingsOpportunityAfterDiscounts() {
            return this.savingsOpportunityAfterDiscounts != null ? this.savingsOpportunityAfterDiscounts.toBuilder() : null;
        }

        public final void setSavingsOpportunityAfterDiscounts(RDSStorageSavingsOpportunityAfterDiscounts.BuilderImpl savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts.build() : null;
        }

        @Override
        public final Builder savingsOpportunityAfterDiscounts(RDSStorageSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts;
            return this;
        }

        public RDSDBStorageRecommendationOption build() {
            return new RDSDBStorageRecommendationOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RDSDBStorageRecommendationOption> {
        public Builder storageConfiguration(DBStorageConfiguration var1);

        default public Builder storageConfiguration(Consumer<DBStorageConfiguration.Builder> storageConfiguration) {
            return this.storageConfiguration((DBStorageConfiguration)((DBStorageConfiguration.Builder)DBStorageConfiguration.builder().applyMutation(storageConfiguration)).build());
        }

        public Builder rank(Integer var1);

        public Builder savingsOpportunity(SavingsOpportunity var1);

        default public Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return this.savingsOpportunity((SavingsOpportunity)((SavingsOpportunity.Builder)SavingsOpportunity.builder().applyMutation(savingsOpportunity)).build());
        }

        public Builder savingsOpportunityAfterDiscounts(RDSStorageSavingsOpportunityAfterDiscounts var1);

        default public Builder savingsOpportunityAfterDiscounts(Consumer<RDSStorageSavingsOpportunityAfterDiscounts.Builder> savingsOpportunityAfterDiscounts) {
            return this.savingsOpportunityAfterDiscounts((RDSStorageSavingsOpportunityAfterDiscounts)((RDSStorageSavingsOpportunityAfterDiscounts.Builder)RDSStorageSavingsOpportunityAfterDiscounts.builder().applyMutation(savingsOpportunityAfterDiscounts)).build());
        }
    }
}

