/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerClient;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationSummary;

public class GetRecommendationSummariesIterable
implements SdkIterable<GetRecommendationSummariesResponse> {
    private final ComputeOptimizerClient client;
    private final GetRecommendationSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetRecommendationSummariesIterable(ComputeOptimizerClient client, GetRecommendationSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetRecommendationSummariesResponseFetcher();
    }

    public Iterator<GetRecommendationSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecommendationSummary> recommendationSummaries() {
        Function<GetRecommendationSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendationSummaries() != null) {
                return response.recommendationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetRecommendationSummariesResponseFetcher
    implements SyncPageFetcher<GetRecommendationSummariesResponse> {
        private GetRecommendationSummariesResponseFetcher() {
        }

        public boolean hasNextPage(GetRecommendationSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetRecommendationSummariesResponse nextPage(GetRecommendationSummariesResponse previousPage) {
            if (previousPage == null) {
                return GetRecommendationSummariesIterable.this.client.getRecommendationSummaries(GetRecommendationSummariesIterable.this.firstRequest);
            }
            return GetRecommendationSummariesIterable.this.client.getRecommendationSummaries((GetRecommendationSummariesRequest)((Object)GetRecommendationSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

