/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOptionsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFinding;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFindingReasonCode;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFindingReasonCodesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionUtilizationMetric;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionUtilizationMetricsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaFunctionRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaFunctionRecommendation> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("functionArn").getter(LambdaFunctionRecommendation.getter(LambdaFunctionRecommendation::functionArn)).setter(LambdaFunctionRecommendation.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionArn").build()}).build();
    private static final SdkField<String> FUNCTION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("functionVersion").getter(LambdaFunctionRecommendation.getter(LambdaFunctionRecommendation::functionVersion)).setter(LambdaFunctionRecommendation.setter(Builder::functionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionVersion").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(LambdaFunctionRecommendation.getter(LambdaFunctionRecommendation::accountId)).setter(LambdaFunctionRecommendation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Integer> CURRENT_MEMORY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("currentMemorySize").getter(LambdaFunctionRecommendation.getter(LambdaFunctionRecommendation::currentMemorySize)).setter(LambdaFunctionRecommendation.setter(Builder::currentMemorySize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentMemorySize").build()}).build();
    private static final SdkField<Long> NUMBER_OF_INVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfInvocations").getter(LambdaFunctionRecommendation.getter(LambdaFunctionRecommendation::numberOfInvocations)).setter(LambdaFunctionRecommendation.setter(Builder::numberOfInvocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfInvocations").build()}).build();
    private static final SdkField<List<LambdaFunctionUtilizationMetric>> UTILIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("utilizationMetrics").getter(LambdaFunctionRecommendation.getter(LambdaFunctionRecommendation::utilizationMetrics)).setter(LambdaFunctionRecommendation.setter(Builder::utilizationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LambdaFunctionUtilizationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("lookbackPeriodInDays").getter(LambdaFunctionRecommendation.getter(LambdaFunctionRecommendation::lookbackPeriodInDays)).setter(LambdaFunctionRecommendation.setter(Builder::lookbackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookbackPeriodInDays").build()}).build();
    private static final SdkField<Instant> LAST_REFRESH_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRefreshTimestamp").getter(LambdaFunctionRecommendation.getter(LambdaFunctionRecommendation::lastRefreshTimestamp)).setter(LambdaFunctionRecommendation.setter(Builder::lastRefreshTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTimestamp").build()}).build();
    private static final SdkField<String> FINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("finding").getter(LambdaFunctionRecommendation.getter(LambdaFunctionRecommendation::findingAsString)).setter(LambdaFunctionRecommendation.setter(Builder::finding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finding").build()}).build();
    private static final SdkField<List<String>> FINDING_REASON_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findingReasonCodes").getter(LambdaFunctionRecommendation.getter(LambdaFunctionRecommendation::findingReasonCodesAsStrings)).setter(LambdaFunctionRecommendation.setter(Builder::findingReasonCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingReasonCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LambdaFunctionMemoryRecommendationOption>> MEMORY_SIZE_RECOMMENDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("memorySizeRecommendationOptions").getter(LambdaFunctionRecommendation.getter(LambdaFunctionRecommendation::memorySizeRecommendationOptions)).setter(LambdaFunctionRecommendation.setter(Builder::memorySizeRecommendationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeRecommendationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LambdaFunctionMemoryRecommendationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CURRENT_PERFORMANCE_RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentPerformanceRisk").getter(LambdaFunctionRecommendation.getter(LambdaFunctionRecommendation::currentPerformanceRiskAsString)).setter(LambdaFunctionRecommendation.setter(Builder::currentPerformanceRisk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPerformanceRisk").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD, FUNCTION_VERSION_FIELD, ACCOUNT_ID_FIELD, CURRENT_MEMORY_SIZE_FIELD, NUMBER_OF_INVOCATIONS_FIELD, UTILIZATION_METRICS_FIELD, LOOKBACK_PERIOD_IN_DAYS_FIELD, LAST_REFRESH_TIMESTAMP_FIELD, FINDING_FIELD, FINDING_REASON_CODES_FIELD, MEMORY_SIZE_RECOMMENDATION_OPTIONS_FIELD, CURRENT_PERFORMANCE_RISK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String functionArn;
    private final String functionVersion;
    private final String accountId;
    private final Integer currentMemorySize;
    private final Long numberOfInvocations;
    private final List<LambdaFunctionUtilizationMetric> utilizationMetrics;
    private final Double lookbackPeriodInDays;
    private final Instant lastRefreshTimestamp;
    private final String finding;
    private final List<String> findingReasonCodes;
    private final List<LambdaFunctionMemoryRecommendationOption> memorySizeRecommendationOptions;
    private final String currentPerformanceRisk;

    private LambdaFunctionRecommendation(BuilderImpl builder) {
        this.functionArn = builder.functionArn;
        this.functionVersion = builder.functionVersion;
        this.accountId = builder.accountId;
        this.currentMemorySize = builder.currentMemorySize;
        this.numberOfInvocations = builder.numberOfInvocations;
        this.utilizationMetrics = builder.utilizationMetrics;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.lastRefreshTimestamp = builder.lastRefreshTimestamp;
        this.finding = builder.finding;
        this.findingReasonCodes = builder.findingReasonCodes;
        this.memorySizeRecommendationOptions = builder.memorySizeRecommendationOptions;
        this.currentPerformanceRisk = builder.currentPerformanceRisk;
    }

    public final String functionArn() {
        return this.functionArn;
    }

    public final String functionVersion() {
        return this.functionVersion;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Integer currentMemorySize() {
        return this.currentMemorySize;
    }

    public final Long numberOfInvocations() {
        return this.numberOfInvocations;
    }

    public final boolean hasUtilizationMetrics() {
        return this.utilizationMetrics != null && !(this.utilizationMetrics instanceof SdkAutoConstructList);
    }

    public final List<LambdaFunctionUtilizationMetric> utilizationMetrics() {
        return this.utilizationMetrics;
    }

    public final Double lookbackPeriodInDays() {
        return this.lookbackPeriodInDays;
    }

    public final Instant lastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public final LambdaFunctionRecommendationFinding finding() {
        return LambdaFunctionRecommendationFinding.fromValue(this.finding);
    }

    public final String findingAsString() {
        return this.finding;
    }

    public final List<LambdaFunctionRecommendationFindingReasonCode> findingReasonCodes() {
        return LambdaFunctionRecommendationFindingReasonCodesCopier.copyStringToEnum(this.findingReasonCodes);
    }

    public final boolean hasFindingReasonCodes() {
        return this.findingReasonCodes != null && !(this.findingReasonCodes instanceof SdkAutoConstructList);
    }

    public final List<String> findingReasonCodesAsStrings() {
        return this.findingReasonCodes;
    }

    public final boolean hasMemorySizeRecommendationOptions() {
        return this.memorySizeRecommendationOptions != null && !(this.memorySizeRecommendationOptions instanceof SdkAutoConstructList);
    }

    public final List<LambdaFunctionMemoryRecommendationOption> memorySizeRecommendationOptions() {
        return this.memorySizeRecommendationOptions;
    }

    public final CurrentPerformanceRisk currentPerformanceRisk() {
        return CurrentPerformanceRisk.fromValue(this.currentPerformanceRisk);
    }

    public final String currentPerformanceRiskAsString() {
        return this.currentPerformanceRisk;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentMemorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfInvocations());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUtilizationMetrics() ? this.utilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingReasonCodes() ? this.findingReasonCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemorySizeRecommendationOptions() ? this.memorySizeRecommendationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPerformanceRiskAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionRecommendation)) {
            return false;
        }
        LambdaFunctionRecommendation other = (LambdaFunctionRecommendation)obj;
        return Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.functionVersion(), other.functionVersion()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.currentMemorySize(), other.currentMemorySize()) && Objects.equals(this.numberOfInvocations(), other.numberOfInvocations()) && this.hasUtilizationMetrics() == other.hasUtilizationMetrics() && Objects.equals(this.utilizationMetrics(), other.utilizationMetrics()) && Objects.equals(this.lookbackPeriodInDays(), other.lookbackPeriodInDays()) && Objects.equals(this.lastRefreshTimestamp(), other.lastRefreshTimestamp()) && Objects.equals(this.findingAsString(), other.findingAsString()) && this.hasFindingReasonCodes() == other.hasFindingReasonCodes() && Objects.equals(this.findingReasonCodesAsStrings(), other.findingReasonCodesAsStrings()) && this.hasMemorySizeRecommendationOptions() == other.hasMemorySizeRecommendationOptions() && Objects.equals(this.memorySizeRecommendationOptions(), other.memorySizeRecommendationOptions()) && Objects.equals(this.currentPerformanceRiskAsString(), other.currentPerformanceRiskAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaFunctionRecommendation").add("FunctionArn", (Object)this.functionArn()).add("FunctionVersion", (Object)this.functionVersion()).add("AccountId", (Object)this.accountId()).add("CurrentMemorySize", (Object)this.currentMemorySize()).add("NumberOfInvocations", (Object)this.numberOfInvocations()).add("UtilizationMetrics", this.hasUtilizationMetrics() ? this.utilizationMetrics() : null).add("LookbackPeriodInDays", (Object)this.lookbackPeriodInDays()).add("LastRefreshTimestamp", (Object)this.lastRefreshTimestamp()).add("Finding", (Object)this.findingAsString()).add("FindingReasonCodes", this.hasFindingReasonCodes() ? this.findingReasonCodesAsStrings() : null).add("MemorySizeRecommendationOptions", this.hasMemorySizeRecommendationOptions() ? this.memorySizeRecommendationOptions() : null).add("CurrentPerformanceRisk", (Object)this.currentPerformanceRiskAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "functionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "functionVersion": {
                return Optional.ofNullable(clazz.cast(this.functionVersion()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "currentMemorySize": {
                return Optional.ofNullable(clazz.cast(this.currentMemorySize()));
            }
            case "numberOfInvocations": {
                return Optional.ofNullable(clazz.cast(this.numberOfInvocations()));
            }
            case "utilizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.utilizationMetrics()));
            }
            case "lookbackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookbackPeriodInDays()));
            }
            case "lastRefreshTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshTimestamp()));
            }
            case "finding": {
                return Optional.ofNullable(clazz.cast(this.findingAsString()));
            }
            case "findingReasonCodes": {
                return Optional.ofNullable(clazz.cast(this.findingReasonCodesAsStrings()));
            }
            case "memorySizeRecommendationOptions": {
                return Optional.ofNullable(clazz.cast(this.memorySizeRecommendationOptions()));
            }
            case "currentPerformanceRisk": {
                return Optional.ofNullable(clazz.cast(this.currentPerformanceRiskAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionRecommendation, T> g) {
        return obj -> g.apply((LambdaFunctionRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionArn;
        private String functionVersion;
        private String accountId;
        private Integer currentMemorySize;
        private Long numberOfInvocations;
        private List<LambdaFunctionUtilizationMetric> utilizationMetrics = DefaultSdkAutoConstructList.getInstance();
        private Double lookbackPeriodInDays;
        private Instant lastRefreshTimestamp;
        private String finding;
        private List<String> findingReasonCodes = DefaultSdkAutoConstructList.getInstance();
        private List<LambdaFunctionMemoryRecommendationOption> memorySizeRecommendationOptions = DefaultSdkAutoConstructList.getInstance();
        private String currentPerformanceRisk;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionRecommendation model) {
            this.functionArn(model.functionArn);
            this.functionVersion(model.functionVersion);
            this.accountId(model.accountId);
            this.currentMemorySize(model.currentMemorySize);
            this.numberOfInvocations(model.numberOfInvocations);
            this.utilizationMetrics(model.utilizationMetrics);
            this.lookbackPeriodInDays(model.lookbackPeriodInDays);
            this.lastRefreshTimestamp(model.lastRefreshTimestamp);
            this.finding(model.finding);
            this.findingReasonCodesWithStrings(model.findingReasonCodes);
            this.memorySizeRecommendationOptions(model.memorySizeRecommendationOptions);
            this.currentPerformanceRisk(model.currentPerformanceRisk);
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        @Transient
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final String getFunctionVersion() {
            return this.functionVersion;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        @Override
        @Transient
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Integer getCurrentMemorySize() {
            return this.currentMemorySize;
        }

        public final void setCurrentMemorySize(Integer currentMemorySize) {
            this.currentMemorySize = currentMemorySize;
        }

        @Override
        @Transient
        public final Builder currentMemorySize(Integer currentMemorySize) {
            this.currentMemorySize = currentMemorySize;
            return this;
        }

        public final Long getNumberOfInvocations() {
            return this.numberOfInvocations;
        }

        public final void setNumberOfInvocations(Long numberOfInvocations) {
            this.numberOfInvocations = numberOfInvocations;
        }

        @Override
        @Transient
        public final Builder numberOfInvocations(Long numberOfInvocations) {
            this.numberOfInvocations = numberOfInvocations;
            return this;
        }

        public final List<LambdaFunctionUtilizationMetric.Builder> getUtilizationMetrics() {
            List<LambdaFunctionUtilizationMetric.Builder> result = LambdaFunctionUtilizationMetricsCopier.copyToBuilder(this.utilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtilizationMetrics(Collection<LambdaFunctionUtilizationMetric.BuilderImpl> utilizationMetrics) {
            this.utilizationMetrics = LambdaFunctionUtilizationMetricsCopier.copyFromBuilder(utilizationMetrics);
        }

        @Override
        @Transient
        public final Builder utilizationMetrics(Collection<LambdaFunctionUtilizationMetric> utilizationMetrics) {
            this.utilizationMetrics = LambdaFunctionUtilizationMetricsCopier.copy(utilizationMetrics);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder utilizationMetrics(LambdaFunctionUtilizationMetric ... utilizationMetrics) {
            this.utilizationMetrics(Arrays.asList(utilizationMetrics));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder utilizationMetrics(Consumer<LambdaFunctionUtilizationMetric.Builder> ... utilizationMetrics) {
            this.utilizationMetrics(Stream.of(utilizationMetrics).map(c -> (LambdaFunctionUtilizationMetric)((LambdaFunctionUtilizationMetric.Builder)LambdaFunctionUtilizationMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getLookbackPeriodInDays() {
            return this.lookbackPeriodInDays;
        }

        public final void setLookbackPeriodInDays(Double lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        @Override
        @Transient
        public final Builder lookbackPeriodInDays(Double lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        public final Instant getLastRefreshTimestamp() {
            return this.lastRefreshTimestamp;
        }

        public final void setLastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
        }

        @Override
        @Transient
        public final Builder lastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
            return this;
        }

        public final String getFinding() {
            return this.finding;
        }

        public final void setFinding(String finding) {
            this.finding = finding;
        }

        @Override
        @Transient
        public final Builder finding(String finding) {
            this.finding = finding;
            return this;
        }

        @Override
        @Transient
        public final Builder finding(LambdaFunctionRecommendationFinding finding) {
            this.finding(finding == null ? null : finding.toString());
            return this;
        }

        public final Collection<String> getFindingReasonCodes() {
            if (this.findingReasonCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findingReasonCodes;
        }

        public final void setFindingReasonCodes(Collection<String> findingReasonCodes) {
            this.findingReasonCodes = LambdaFunctionRecommendationFindingReasonCodesCopier.copy(findingReasonCodes);
        }

        @Override
        @Transient
        public final Builder findingReasonCodesWithStrings(Collection<String> findingReasonCodes) {
            this.findingReasonCodes = LambdaFunctionRecommendationFindingReasonCodesCopier.copy(findingReasonCodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder findingReasonCodesWithStrings(String ... findingReasonCodes) {
            this.findingReasonCodesWithStrings(Arrays.asList(findingReasonCodes));
            return this;
        }

        @Override
        @Transient
        public final Builder findingReasonCodes(Collection<LambdaFunctionRecommendationFindingReasonCode> findingReasonCodes) {
            this.findingReasonCodes = LambdaFunctionRecommendationFindingReasonCodesCopier.copyEnumToString(findingReasonCodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder findingReasonCodes(LambdaFunctionRecommendationFindingReasonCode ... findingReasonCodes) {
            this.findingReasonCodes(Arrays.asList(findingReasonCodes));
            return this;
        }

        public final List<LambdaFunctionMemoryRecommendationOption.Builder> getMemorySizeRecommendationOptions() {
            List<LambdaFunctionMemoryRecommendationOption.Builder> result = LambdaFunctionMemoryRecommendationOptionsCopier.copyToBuilder(this.memorySizeRecommendationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemorySizeRecommendationOptions(Collection<LambdaFunctionMemoryRecommendationOption.BuilderImpl> memorySizeRecommendationOptions) {
            this.memorySizeRecommendationOptions = LambdaFunctionMemoryRecommendationOptionsCopier.copyFromBuilder(memorySizeRecommendationOptions);
        }

        @Override
        @Transient
        public final Builder memorySizeRecommendationOptions(Collection<LambdaFunctionMemoryRecommendationOption> memorySizeRecommendationOptions) {
            this.memorySizeRecommendationOptions = LambdaFunctionMemoryRecommendationOptionsCopier.copy(memorySizeRecommendationOptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder memorySizeRecommendationOptions(LambdaFunctionMemoryRecommendationOption ... memorySizeRecommendationOptions) {
            this.memorySizeRecommendationOptions(Arrays.asList(memorySizeRecommendationOptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder memorySizeRecommendationOptions(Consumer<LambdaFunctionMemoryRecommendationOption.Builder> ... memorySizeRecommendationOptions) {
            this.memorySizeRecommendationOptions(Stream.of(memorySizeRecommendationOptions).map(c -> (LambdaFunctionMemoryRecommendationOption)((LambdaFunctionMemoryRecommendationOption.Builder)LambdaFunctionMemoryRecommendationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCurrentPerformanceRisk() {
            return this.currentPerformanceRisk;
        }

        public final void setCurrentPerformanceRisk(String currentPerformanceRisk) {
            this.currentPerformanceRisk = currentPerformanceRisk;
        }

        @Override
        @Transient
        public final Builder currentPerformanceRisk(String currentPerformanceRisk) {
            this.currentPerformanceRisk = currentPerformanceRisk;
            return this;
        }

        @Override
        @Transient
        public final Builder currentPerformanceRisk(CurrentPerformanceRisk currentPerformanceRisk) {
            this.currentPerformanceRisk(currentPerformanceRisk == null ? null : currentPerformanceRisk.toString());
            return this;
        }

        public LambdaFunctionRecommendation build() {
            return new LambdaFunctionRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaFunctionRecommendation> {
        public Builder functionArn(String var1);

        public Builder functionVersion(String var1);

        public Builder accountId(String var1);

        public Builder currentMemorySize(Integer var1);

        public Builder numberOfInvocations(Long var1);

        public Builder utilizationMetrics(Collection<LambdaFunctionUtilizationMetric> var1);

        public Builder utilizationMetrics(LambdaFunctionUtilizationMetric ... var1);

        public Builder utilizationMetrics(Consumer<LambdaFunctionUtilizationMetric.Builder> ... var1);

        public Builder lookbackPeriodInDays(Double var1);

        public Builder lastRefreshTimestamp(Instant var1);

        public Builder finding(String var1);

        public Builder finding(LambdaFunctionRecommendationFinding var1);

        public Builder findingReasonCodesWithStrings(Collection<String> var1);

        public Builder findingReasonCodesWithStrings(String ... var1);

        public Builder findingReasonCodes(Collection<LambdaFunctionRecommendationFindingReasonCode> var1);

        public Builder findingReasonCodes(LambdaFunctionRecommendationFindingReasonCode ... var1);

        public Builder memorySizeRecommendationOptions(Collection<LambdaFunctionMemoryRecommendationOption> var1);

        public Builder memorySizeRecommendationOptions(LambdaFunctionMemoryRecommendationOption ... var1);

        public Builder memorySizeRecommendationOptions(Consumer<LambdaFunctionMemoryRecommendationOption.Builder> ... var1);

        public Builder currentPerformanceRisk(String var1);

        public Builder currentPerformanceRisk(CurrentPerformanceRisk var1);
    }
}

