/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecommendationSummariesResponse extends ComputeOptimizerResponse implements
        ToCopyableBuilder<GetRecommendationSummariesResponse.Builder, GetRecommendationSummariesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRecommendationSummariesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<RecommendationSummary>> RECOMMENDATION_SUMMARIES_FIELD = SdkField
            .<List<RecommendationSummary>> builder(MarshallingType.LIST)
            .getter(getter(GetRecommendationSummariesResponse::recommendationSummaries))
            .setter(setter(Builder::recommendationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RECOMMENDATION_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<RecommendationSummary> recommendationSummaries;

    private GetRecommendationSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.recommendationSummaries = builder.recommendationSummaries;
    }

    /**
     * <p>
     * The token to use to advance to the next page of recommendation summaries.
     * </p>
     * <p>
     * This value is null when there are no more pages of recommendation summaries to return.
     * </p>
     * 
     * @return The token to use to advance to the next page of recommendation summaries.</p>
     *         <p>
     *         This value is null when there are no more pages of recommendation summaries to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the RecommendationSummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRecommendationSummaries() {
        return recommendationSummaries != null && !(recommendationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that summarize a recommendation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecommendationSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that summarize a recommendation.
     */
    public List<RecommendationSummary> recommendationSummaries() {
        return recommendationSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationSummaries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationSummariesResponse)) {
            return false;
        }
        GetRecommendationSummariesResponse other = (GetRecommendationSummariesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(recommendationSummaries(), other.recommendationSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetRecommendationSummariesResponse").add("NextToken", nextToken())
                .add("RecommendationSummaries", recommendationSummaries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "recommendationSummaries":
            return Optional.ofNullable(clazz.cast(recommendationSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationSummariesResponse, T> g) {
        return obj -> g.apply((GetRecommendationSummariesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecommendationSummariesResponse> {
        /**
         * <p>
         * The token to use to advance to the next page of recommendation summaries.
         * </p>
         * <p>
         * This value is null when there are no more pages of recommendation summaries to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to advance to the next page of recommendation summaries.</p>
         *        <p>
         *        This value is null when there are no more pages of recommendation summaries to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of objects that summarize a recommendation.
         * </p>
         * 
         * @param recommendationSummaries
         *        An array of objects that summarize a recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationSummaries(Collection<RecommendationSummary> recommendationSummaries);

        /**
         * <p>
         * An array of objects that summarize a recommendation.
         * </p>
         * 
         * @param recommendationSummaries
         *        An array of objects that summarize a recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationSummaries(RecommendationSummary... recommendationSummaries);

        /**
         * <p>
         * An array of objects that summarize a recommendation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecommendationSummary>.Builder} avoiding
         * the need to create one manually via {@link List<RecommendationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecommendationSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #recommendationSummaries(List<RecommendationSummary>)}.
         * 
         * @param recommendationSummaries
         *        a consumer that will call methods on {@link List<RecommendationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationSummaries(List<RecommendationSummary>)
         */
        Builder recommendationSummaries(Consumer<RecommendationSummary.Builder>... recommendationSummaries);
    }

    static final class BuilderImpl extends ComputeOptimizerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RecommendationSummary> recommendationSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationSummariesResponse model) {
            super(model);
            nextToken(model.nextToken);
            recommendationSummaries(model.recommendationSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<RecommendationSummary.Builder> getRecommendationSummaries() {
            return recommendationSummaries != null ? recommendationSummaries.stream().map(RecommendationSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recommendationSummaries(Collection<RecommendationSummary> recommendationSummaries) {
            this.recommendationSummaries = RecommendationSummariesCopier.copy(recommendationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationSummaries(RecommendationSummary... recommendationSummaries) {
            recommendationSummaries(Arrays.asList(recommendationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationSummaries(Consumer<RecommendationSummary.Builder>... recommendationSummaries) {
            recommendationSummaries(Stream.of(recommendationSummaries)
                    .map(c -> RecommendationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendationSummaries(Collection<RecommendationSummary.BuilderImpl> recommendationSummaries) {
            this.recommendationSummaries = RecommendationSummariesCopier.copyFromBuilder(recommendationSummaries);
        }

        @Override
        public GetRecommendationSummariesResponse build() {
            return new GetRecommendationSummariesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
