/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAutoScalingGroupRecommendationsResponse extends ComputeOptimizerResponse implements
        ToCopyableBuilder<GetAutoScalingGroupRecommendationsResponse.Builder, GetAutoScalingGroupRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAutoScalingGroupRecommendationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<AutoScalingGroupRecommendation>> AUTO_SCALING_GROUP_RECOMMENDATIONS_FIELD = SdkField
            .<List<AutoScalingGroupRecommendation>> builder(MarshallingType.LIST)
            .getter(getter(GetAutoScalingGroupRecommendationsResponse::autoScalingGroupRecommendations))
            .setter(setter(Builder::autoScalingGroupRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupRecommendations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoScalingGroupRecommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoScalingGroupRecommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GetRecommendationError>> ERRORS_FIELD = SdkField
            .<List<GetRecommendationError>> builder(MarshallingType.LIST)
            .getter(getter(GetAutoScalingGroupRecommendationsResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GetRecommendationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(GetRecommendationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            AUTO_SCALING_GROUP_RECOMMENDATIONS_FIELD, ERRORS_FIELD));

    private final String nextToken;

    private final List<AutoScalingGroupRecommendation> autoScalingGroupRecommendations;

    private final List<GetRecommendationError> errors;

    private GetAutoScalingGroupRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.autoScalingGroupRecommendations = builder.autoScalingGroupRecommendations;
        this.errors = builder.errors;
    }

    /**
     * <p>
     * The token to use to advance to the next page of Auto Scaling group recommendations.
     * </p>
     * <p>
     * This value is null when there are no more pages of Auto Scaling group recommendations to return.
     * </p>
     * 
     * @return The token to use to advance to the next page of Auto Scaling group recommendations.</p>
     *         <p>
     *         This value is null when there are no more pages of Auto Scaling group recommendations to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the AutoScalingGroupRecommendations property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasAutoScalingGroupRecommendations() {
        return autoScalingGroupRecommendations != null && !(autoScalingGroupRecommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe Auto Scaling group recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAutoScalingGroupRecommendations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe Auto Scaling group recommendations.
     */
    public List<AutoScalingGroupRecommendation> autoScalingGroupRecommendations() {
        return autoScalingGroupRecommendations;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe errors of the request.
     * </p>
     * <p>
     * For example, an error is returned if you request recommendations for an unsupported Auto Scaling group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe errors of the request.</p>
     *         <p>
     *         For example, an error is returned if you request recommendations for an unsupported Auto Scaling group.
     */
    public List<GetRecommendationError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupRecommendations());
        hashCode = 31 * hashCode + Objects.hashCode(errors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutoScalingGroupRecommendationsResponse)) {
            return false;
        }
        GetAutoScalingGroupRecommendationsResponse other = (GetAutoScalingGroupRecommendationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(autoScalingGroupRecommendations(), other.autoScalingGroupRecommendations())
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAutoScalingGroupRecommendationsResponse").add("NextToken", nextToken())
                .add("AutoScalingGroupRecommendations", autoScalingGroupRecommendations()).add("Errors", errors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "autoScalingGroupRecommendations":
            return Optional.ofNullable(clazz.cast(autoScalingGroupRecommendations()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAutoScalingGroupRecommendationsResponse, T> g) {
        return obj -> g.apply((GetAutoScalingGroupRecommendationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAutoScalingGroupRecommendationsResponse> {
        /**
         * <p>
         * The token to use to advance to the next page of Auto Scaling group recommendations.
         * </p>
         * <p>
         * This value is null when there are no more pages of Auto Scaling group recommendations to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to advance to the next page of Auto Scaling group recommendations.</p>
         *        <p>
         *        This value is null when there are no more pages of Auto Scaling group recommendations to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of objects that describe Auto Scaling group recommendations.
         * </p>
         * 
         * @param autoScalingGroupRecommendations
         *        An array of objects that describe Auto Scaling group recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupRecommendations(Collection<AutoScalingGroupRecommendation> autoScalingGroupRecommendations);

        /**
         * <p>
         * An array of objects that describe Auto Scaling group recommendations.
         * </p>
         * 
         * @param autoScalingGroupRecommendations
         *        An array of objects that describe Auto Scaling group recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupRecommendations(AutoScalingGroupRecommendation... autoScalingGroupRecommendations);

        /**
         * <p>
         * An array of objects that describe Auto Scaling group recommendations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AutoScalingGroupRecommendation>.Builder}
         * avoiding the need to create one manually via {@link List<AutoScalingGroupRecommendation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutoScalingGroupRecommendation>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #autoScalingGroupRecommendations(List<AutoScalingGroupRecommendation>)}.
         * 
         * @param autoScalingGroupRecommendations
         *        a consumer that will call methods on {@link List<AutoScalingGroupRecommendation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingGroupRecommendations(List<AutoScalingGroupRecommendation>)
         */
        Builder autoScalingGroupRecommendations(
                Consumer<AutoScalingGroupRecommendation.Builder>... autoScalingGroupRecommendations);

        /**
         * <p>
         * An array of objects that describe errors of the request.
         * </p>
         * <p>
         * For example, an error is returned if you request recommendations for an unsupported Auto Scaling group.
         * </p>
         * 
         * @param errors
         *        An array of objects that describe errors of the request.</p>
         *        <p>
         *        For example, an error is returned if you request recommendations for an unsupported Auto Scaling
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<GetRecommendationError> errors);

        /**
         * <p>
         * An array of objects that describe errors of the request.
         * </p>
         * <p>
         * For example, an error is returned if you request recommendations for an unsupported Auto Scaling group.
         * </p>
         * 
         * @param errors
         *        An array of objects that describe errors of the request.</p>
         *        <p>
         *        For example, an error is returned if you request recommendations for an unsupported Auto Scaling
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(GetRecommendationError... errors);

        /**
         * <p>
         * An array of objects that describe errors of the request.
         * </p>
         * <p>
         * For example, an error is returned if you request recommendations for an unsupported Auto Scaling group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GetRecommendationError>.Builder} avoiding
         * the need to create one manually via {@link List<GetRecommendationError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GetRecommendationError>.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<GetRecommendationError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<GetRecommendationError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<GetRecommendationError>)
         */
        Builder errors(Consumer<GetRecommendationError.Builder>... errors);
    }

    static final class BuilderImpl extends ComputeOptimizerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<AutoScalingGroupRecommendation> autoScalingGroupRecommendations = DefaultSdkAutoConstructList.getInstance();

        private List<GetRecommendationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutoScalingGroupRecommendationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            autoScalingGroupRecommendations(model.autoScalingGroupRecommendations);
            errors(model.errors);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<AutoScalingGroupRecommendation.Builder> getAutoScalingGroupRecommendations() {
            return autoScalingGroupRecommendations != null ? autoScalingGroupRecommendations.stream()
                    .map(AutoScalingGroupRecommendation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder autoScalingGroupRecommendations(
                Collection<AutoScalingGroupRecommendation> autoScalingGroupRecommendations) {
            this.autoScalingGroupRecommendations = AutoScalingGroupRecommendationsCopier.copy(autoScalingGroupRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroupRecommendations(AutoScalingGroupRecommendation... autoScalingGroupRecommendations) {
            autoScalingGroupRecommendations(Arrays.asList(autoScalingGroupRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroupRecommendations(
                Consumer<AutoScalingGroupRecommendation.Builder>... autoScalingGroupRecommendations) {
            autoScalingGroupRecommendations(Stream.of(autoScalingGroupRecommendations)
                    .map(c -> AutoScalingGroupRecommendation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAutoScalingGroupRecommendations(
                Collection<AutoScalingGroupRecommendation.BuilderImpl> autoScalingGroupRecommendations) {
            this.autoScalingGroupRecommendations = AutoScalingGroupRecommendationsCopier
                    .copyFromBuilder(autoScalingGroupRecommendations);
        }

        public final Collection<GetRecommendationError.Builder> getErrors() {
            return errors != null ? errors.stream().map(GetRecommendationError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<GetRecommendationError> errors) {
            this.errors = GetRecommendationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(GetRecommendationError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<GetRecommendationError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> GetRecommendationError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<GetRecommendationError.BuilderImpl> errors) {
            this.errors = GetRecommendationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public GetAutoScalingGroupRecommendationsResponse build() {
            return new GetAutoScalingGroupRecommendationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
