/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAutoScalingGroupRecommendationsRequest extends ComputeOptimizerRequest implements
        ToCopyableBuilder<GetAutoScalingGroupRecommendationsRequest.Builder, GetAutoScalingGroupRecommendationsRequest> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetAutoScalingGroupRecommendationsRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTO_SCALING_GROUP_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetAutoScalingGroupRecommendationsRequest::autoScalingGroupArns))
            .setter(setter(Builder::autoScalingGroupArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAutoScalingGroupRecommendationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetAutoScalingGroupRecommendationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(GetAutoScalingGroupRecommendationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD,
            AUTO_SCALING_GROUP_ARNS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD));

    private final List<String> accountIds;

    private final List<String> autoScalingGroupArns;

    private final String nextToken;

    private final Integer maxResults;

    private final List<Filter> filters;

    private GetAutoScalingGroupRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.autoScalingGroupArns = builder.autoScalingGroupArns;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
    }

    /**
     * Returns true if the AccountIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS account IDs for which to return Auto Scaling group recommendations.
     * </p>
     * <p>
     * Only one account ID can be specified per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The AWS account IDs for which to return Auto Scaling group recommendations.</p>
     *         <p>
     *         Only one account ID can be specified per request.
     */
    public List<String> accountIds() {
        return accountIds;
    }

    /**
     * Returns true if the AutoScalingGroupArns property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAutoScalingGroupArns() {
        return autoScalingGroupArns != null && !(autoScalingGroupArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAutoScalingGroupArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return recommendations.
     */
    public List<String> autoScalingGroupArns() {
        return autoScalingGroupArns;
    }

    /**
     * <p>
     * The token to advance to the next page of Auto Scaling group recommendations.
     * </p>
     * 
     * @return The token to advance to the next page of Auto Scaling group recommendations.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of Auto Scaling group recommendations to return with a single call.
     * </p>
     * <p>
     * To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of Auto Scaling group recommendations to return with a single call.</p>
     *         <p>
     *         To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe a filter that returns a more specific list of Auto Scaling group
     * recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe a filter that returns a more specific list of Auto Scaling group
     *         recommendations.
     */
    public List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountIds());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupArns());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutoScalingGroupRecommendationsRequest)) {
            return false;
        }
        GetAutoScalingGroupRecommendationsRequest other = (GetAutoScalingGroupRecommendationsRequest) obj;
        return Objects.equals(accountIds(), other.accountIds())
                && Objects.equals(autoScalingGroupArns(), other.autoScalingGroupArns())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAutoScalingGroupRecommendationsRequest").add("AccountIds", accountIds())
                .add("AutoScalingGroupArns", autoScalingGroupArns()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Filters", filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "autoScalingGroupArns":
            return Optional.ofNullable(clazz.cast(autoScalingGroupArns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAutoScalingGroupRecommendationsRequest, T> g) {
        return obj -> g.apply((GetAutoScalingGroupRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAutoScalingGroupRecommendationsRequest> {
        /**
         * <p>
         * The AWS account IDs for which to return Auto Scaling group recommendations.
         * </p>
         * <p>
         * Only one account ID can be specified per request.
         * </p>
         * 
         * @param accountIds
         *        The AWS account IDs for which to return Auto Scaling group recommendations.</p>
         *        <p>
         *        Only one account ID can be specified per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The AWS account IDs for which to return Auto Scaling group recommendations.
         * </p>
         * <p>
         * Only one account ID can be specified per request.
         * </p>
         * 
         * @param accountIds
         *        The AWS account IDs for which to return Auto Scaling group recommendations.</p>
         *        <p>
         *        Only one account ID can be specified per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return recommendations.
         * </p>
         * 
         * @param autoScalingGroupArns
         *        The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupArns(Collection<String> autoScalingGroupArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return recommendations.
         * </p>
         * 
         * @param autoScalingGroupArns
         *        The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupArns(String... autoScalingGroupArns);

        /**
         * <p>
         * The token to advance to the next page of Auto Scaling group recommendations.
         * </p>
         * 
         * @param nextToken
         *        The token to advance to the next page of Auto Scaling group recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of Auto Scaling group recommendations to return with a single call.
         * </p>
         * <p>
         * To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of Auto Scaling group recommendations to return with a single call.</p>
         *        <p>
         *        To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An array of objects that describe a filter that returns a more specific list of Auto Scaling group
         * recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects that describe a filter that returns a more specific list of Auto Scaling group
         *        recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * An array of objects that describe a filter that returns a more specific list of Auto Scaling group
         * recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects that describe a filter that returns a more specific list of Auto Scaling group
         *        recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * An array of objects that describe a filter that returns a more specific list of Auto Scaling group
         * recommendations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComputeOptimizerRequest.BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> autoScalingGroupArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutoScalingGroupRecommendationsRequest model) {
            super(model);
            accountIds(model.accountIds);
            autoScalingGroupArns(model.autoScalingGroupArns);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
        }

        public final Collection<String> getAccountIds() {
            return accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        public final Collection<String> getAutoScalingGroupArns() {
            return autoScalingGroupArns;
        }

        @Override
        public final Builder autoScalingGroupArns(Collection<String> autoScalingGroupArns) {
            this.autoScalingGroupArns = AutoScalingGroupArnsCopier.copy(autoScalingGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroupArns(String... autoScalingGroupArns) {
            autoScalingGroupArns(Arrays.asList(autoScalingGroupArns));
            return this;
        }

        public final void setAutoScalingGroupArns(Collection<String> autoScalingGroupArns) {
            this.autoScalingGroupArns = AutoScalingGroupArnsCopier.copy(autoScalingGroupArns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAutoScalingGroupRecommendationsRequest build() {
            return new GetAutoScalingGroupRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
