/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationError;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationErrorsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendation;
import software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEc2InstanceRecommendationsResponse
extends ComputeOptimizerResponse
implements ToCopyableBuilder<Builder, GetEc2InstanceRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetEc2InstanceRecommendationsResponse.getter(GetEc2InstanceRecommendationsResponse::nextToken)).setter(GetEc2InstanceRecommendationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<InstanceRecommendation>> INSTANCE_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetEc2InstanceRecommendationsResponse.getter(GetEc2InstanceRecommendationsResponse::instanceRecommendations)).setter(GetEc2InstanceRecommendationsResponse.setter(Builder::instanceRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GetRecommendationError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetEc2InstanceRecommendationsResponse.getter(GetEc2InstanceRecommendationsResponse::errors)).setter(GetEc2InstanceRecommendationsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetRecommendationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, INSTANCE_RECOMMENDATIONS_FIELD, ERRORS_FIELD));
    private final String nextToken;
    private final List<InstanceRecommendation> instanceRecommendations;
    private final List<GetRecommendationError> errors;

    private GetEc2InstanceRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.instanceRecommendations = builder.instanceRecommendations;
        this.errors = builder.errors;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<InstanceRecommendation> instanceRecommendations() {
        return this.instanceRecommendations;
    }

    public List<GetRecommendationError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRecommendations());
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEc2InstanceRecommendationsResponse)) {
            return false;
        }
        GetEc2InstanceRecommendationsResponse other = (GetEc2InstanceRecommendationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.instanceRecommendations(), other.instanceRecommendations()) && Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"GetEc2InstanceRecommendationsResponse").add("NextToken", (Object)this.nextToken()).add("InstanceRecommendations", this.instanceRecommendations()).add("Errors", this.errors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "instanceRecommendations": {
                return Optional.ofNullable(clazz.cast(this.instanceRecommendations()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEc2InstanceRecommendationsResponse, T> g) {
        return obj -> g.apply((GetEc2InstanceRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<InstanceRecommendation> instanceRecommendations = DefaultSdkAutoConstructList.getInstance();
        private List<GetRecommendationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEc2InstanceRecommendationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.instanceRecommendations(model.instanceRecommendations);
            this.errors(model.errors);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<InstanceRecommendation.Builder> getInstanceRecommendations() {
            return this.instanceRecommendations != null ? (Collection)this.instanceRecommendations.stream().map(InstanceRecommendation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceRecommendations(Collection<InstanceRecommendation> instanceRecommendations) {
            this.instanceRecommendations = InstanceRecommendationsCopier.copy(instanceRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceRecommendations(InstanceRecommendation ... instanceRecommendations) {
            this.instanceRecommendations(Arrays.asList(instanceRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceRecommendations(Consumer<InstanceRecommendation.Builder> ... instanceRecommendations) {
            this.instanceRecommendations(Stream.of(instanceRecommendations).map(c -> (InstanceRecommendation)((InstanceRecommendation.Builder)InstanceRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceRecommendations(Collection<InstanceRecommendation.BuilderImpl> instanceRecommendations) {
            this.instanceRecommendations = InstanceRecommendationsCopier.copyFromBuilder(instanceRecommendations);
        }

        public final Collection<GetRecommendationError.Builder> getErrors() {
            return this.errors != null ? (Collection)this.errors.stream().map(GetRecommendationError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<GetRecommendationError> errors) {
            this.errors = GetRecommendationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(GetRecommendationError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<GetRecommendationError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (GetRecommendationError)((GetRecommendationError.Builder)GetRecommendationError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<GetRecommendationError.BuilderImpl> errors) {
            this.errors = GetRecommendationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public GetEc2InstanceRecommendationsResponse build() {
            return new GetEc2InstanceRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComputeOptimizerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEc2InstanceRecommendationsResponse> {
        public Builder nextToken(String var1);

        public Builder instanceRecommendations(Collection<InstanceRecommendation> var1);

        public Builder instanceRecommendations(InstanceRecommendation ... var1);

        public Builder instanceRecommendations(Consumer<InstanceRecommendation.Builder> ... var1);

        public Builder errors(Collection<GetRecommendationError> var1);

        public Builder errors(GetRecommendationError ... var1);

        public Builder errors(Consumer<GetRecommendationError.Builder> ... var1);
    }
}

