/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehendmedical.model.InputDataConfig;
import software.amazon.awssdk.services.comprehendmedical.model.JobStatus;
import software.amazon.awssdk.services.comprehendmedical.model.LanguageCode;
import software.amazon.awssdk.services.comprehendmedical.model.OutputDataConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComprehendMedicalAsyncJobProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComprehendMedicalAsyncJobProperties> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(ComprehendMedicalAsyncJobProperties.getter(ComprehendMedicalAsyncJobProperties::jobId)).setter(ComprehendMedicalAsyncJobProperties.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(ComprehendMedicalAsyncJobProperties.getter(ComprehendMedicalAsyncJobProperties::jobName)).setter(ComprehendMedicalAsyncJobProperties.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(ComprehendMedicalAsyncJobProperties.getter(ComprehendMedicalAsyncJobProperties::jobStatusAsString)).setter(ComprehendMedicalAsyncJobProperties.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(ComprehendMedicalAsyncJobProperties.getter(ComprehendMedicalAsyncJobProperties::message)).setter(ComprehendMedicalAsyncJobProperties.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmitTime").getter(ComprehendMedicalAsyncJobProperties.getter(ComprehendMedicalAsyncJobProperties::submitTime)).setter(ComprehendMedicalAsyncJobProperties.setter(Builder::submitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ComprehendMedicalAsyncJobProperties.getter(ComprehendMedicalAsyncJobProperties::endTime)).setter(ComprehendMedicalAsyncJobProperties.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationTime").getter(ComprehendMedicalAsyncJobProperties.getter(ComprehendMedicalAsyncJobProperties::expirationTime)).setter(ComprehendMedicalAsyncJobProperties.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()}).build();
    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputDataConfig").getter(ComprehendMedicalAsyncJobProperties.getter(ComprehendMedicalAsyncJobProperties::inputDataConfig)).setter(ComprehendMedicalAsyncJobProperties.setter(Builder::inputDataConfig)).constructor(InputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputDataConfig").getter(ComprehendMedicalAsyncJobProperties.getter(ComprehendMedicalAsyncJobProperties::outputDataConfig)).setter(ComprehendMedicalAsyncJobProperties.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(ComprehendMedicalAsyncJobProperties.getter(ComprehendMedicalAsyncJobProperties::languageCodeAsString)).setter(ComprehendMedicalAsyncJobProperties.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(ComprehendMedicalAsyncJobProperties.getter(ComprehendMedicalAsyncJobProperties::dataAccessRoleArn)).setter(ComprehendMedicalAsyncJobProperties.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<String> MANIFEST_FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestFilePath").getter(ComprehendMedicalAsyncJobProperties.getter(ComprehendMedicalAsyncJobProperties::manifestFilePath)).setter(ComprehendMedicalAsyncJobProperties.setter(Builder::manifestFilePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestFilePath").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKey").getter(ComprehendMedicalAsyncJobProperties.getter(ComprehendMedicalAsyncJobProperties::kmsKey)).setter(ComprehendMedicalAsyncJobProperties.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(ComprehendMedicalAsyncJobProperties.getter(ComprehendMedicalAsyncJobProperties::modelVersion)).setter(ComprehendMedicalAsyncJobProperties.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_NAME_FIELD, JOB_STATUS_FIELD, MESSAGE_FIELD, SUBMIT_TIME_FIELD, END_TIME_FIELD, EXPIRATION_TIME_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, LANGUAGE_CODE_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, MANIFEST_FILE_PATH_FIELD, KMS_KEY_FIELD, MODEL_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("JobId", JOB_ID_FIELD);
            this.put("JobName", JOB_NAME_FIELD);
            this.put("JobStatus", JOB_STATUS_FIELD);
            this.put("Message", MESSAGE_FIELD);
            this.put("SubmitTime", SUBMIT_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
            this.put("ExpirationTime", EXPIRATION_TIME_FIELD);
            this.put("InputDataConfig", INPUT_DATA_CONFIG_FIELD);
            this.put("OutputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
            this.put("LanguageCode", LANGUAGE_CODE_FIELD);
            this.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
            this.put("ManifestFilePath", MANIFEST_FILE_PATH_FIELD);
            this.put("KMSKey", KMS_KEY_FIELD);
            this.put("ModelVersion", MODEL_VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String jobName;
    private final String jobStatus;
    private final String message;
    private final Instant submitTime;
    private final Instant endTime;
    private final Instant expirationTime;
    private final InputDataConfig inputDataConfig;
    private final OutputDataConfig outputDataConfig;
    private final String languageCode;
    private final String dataAccessRoleArn;
    private final String manifestFilePath;
    private final String kmsKey;
    private final String modelVersion;

    private ComprehendMedicalAsyncJobProperties(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.message = builder.message;
        this.submitTime = builder.submitTime;
        this.endTime = builder.endTime;
        this.expirationTime = builder.expirationTime;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.languageCode = builder.languageCode;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.manifestFilePath = builder.manifestFilePath;
        this.kmsKey = builder.kmsKey;
        this.modelVersion = builder.modelVersion;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final String message() {
        return this.message;
    }

    public final Instant submitTime() {
        return this.submitTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant expirationTime() {
        return this.expirationTime;
    }

    public final InputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public final OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final String manifestFilePath() {
        return this.manifestFilePath;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final String modelVersion() {
        return this.modelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestFilePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComprehendMedicalAsyncJobProperties)) {
            return false;
        }
        ComprehendMedicalAsyncJobProperties other = (ComprehendMedicalAsyncJobProperties)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.submitTime(), other.submitTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.expirationTime(), other.expirationTime()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.manifestFilePath(), other.manifestFilePath()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.modelVersion(), other.modelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ComprehendMedicalAsyncJobProperties").add("JobId", (Object)this.jobId()).add("JobName", (Object)this.jobName()).add("JobStatus", (Object)this.jobStatusAsString()).add("Message", (Object)this.message()).add("SubmitTime", (Object)this.submitTime()).add("EndTime", (Object)this.endTime()).add("ExpirationTime", (Object)this.expirationTime()).add("InputDataConfig", (Object)this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("LanguageCode", (Object)this.languageCodeAsString()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("ManifestFilePath", (Object)this.manifestFilePath()).add("KMSKey", (Object)this.kmsKey()).add("ModelVersion", (Object)this.modelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "SubmitTime": {
                return Optional.ofNullable(clazz.cast(this.submitTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "ManifestFilePath": {
                return Optional.ofNullable(clazz.cast(this.manifestFilePath()));
            }
            case "KMSKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ComprehendMedicalAsyncJobProperties, T> g) {
        return obj -> g.apply((ComprehendMedicalAsyncJobProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String jobName;
        private String jobStatus;
        private String message;
        private Instant submitTime;
        private Instant endTime;
        private Instant expirationTime;
        private InputDataConfig inputDataConfig;
        private OutputDataConfig outputDataConfig;
        private String languageCode;
        private String dataAccessRoleArn;
        private String manifestFilePath;
        private String kmsKey;
        private String modelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ComprehendMedicalAsyncJobProperties model) {
            this.jobId(model.jobId);
            this.jobName(model.jobName);
            this.jobStatus(model.jobStatus);
            this.message(model.message);
            this.submitTime(model.submitTime);
            this.endTime(model.endTime);
            this.expirationTime(model.expirationTime);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.languageCode(model.languageCode);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.manifestFilePath(model.manifestFilePath);
            this.kmsKey(model.kmsKey);
            this.modelVersion(model.modelVersion);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getSubmitTime() {
            return this.submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getManifestFilePath() {
            return this.manifestFilePath;
        }

        public final void setManifestFilePath(String manifestFilePath) {
            this.manifestFilePath = manifestFilePath;
        }

        @Override
        public final Builder manifestFilePath(String manifestFilePath) {
            this.manifestFilePath = manifestFilePath;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public ComprehendMedicalAsyncJobProperties build() {
            return new ComprehendMedicalAsyncJobProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComprehendMedicalAsyncJobProperties> {
        public Builder jobId(String var1);

        public Builder jobName(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder message(String var1);

        public Builder submitTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder expirationTime(Instant var1);

        public Builder inputDataConfig(InputDataConfig var1);

        default public Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((InputDataConfig)((InputDataConfig.Builder)InputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder manifestFilePath(String var1);

        public Builder kmsKey(String var1);

        public Builder modelVersion(String var1);
    }
}

