/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ICD10CMEntityType {
    DX_NAME("DX_NAME"),
    TIME_EXPRESSION("TIME_EXPRESSION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ICD10CMEntityType> VALUE_MAP;
    private final String value;

    private ICD10CMEntityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ICD10CMEntityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ICD10CMEntityType> knownValues() {
        EnumSet<ICD10CMEntityType> knownValues = EnumSet.allOf(ICD10CMEntityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ICD10CMEntityType.class, ICD10CMEntityType::toString);
    }
}

