/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SNOMEDCTRelationshipType {
    ACUITY("ACUITY"),
    QUALITY("QUALITY"),
    TEST_VALUE("TEST_VALUE"),
    TEST_UNITS("TEST_UNITS"),
    DIRECTION("DIRECTION"),
    SYSTEM_ORGAN_SITE("SYSTEM_ORGAN_SITE"),
    TEST_UNIT("TEST_UNIT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SNOMEDCTRelationshipType> VALUE_MAP;
    private final String value;

    private SNOMEDCTRelationshipType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SNOMEDCTRelationshipType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SNOMEDCTRelationshipType> knownValues() {
        EnumSet<SNOMEDCTRelationshipType> knownValues = EnumSet.allOf(SNOMEDCTRelationshipType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SNOMEDCTRelationshipType.class, SNOMEDCTRelationshipType::toString);
    }
}

