/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a detection job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComprehendMedicalAsyncJobProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ComprehendMedicalAsyncJobProperties.Builder, ComprehendMedicalAsyncJobProperties> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(ComprehendMedicalAsyncJobProperties::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(ComprehendMedicalAsyncJobProperties::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(ComprehendMedicalAsyncJobProperties::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ComprehendMedicalAsyncJobProperties::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmitTime").getter(getter(ComprehendMedicalAsyncJobProperties::submitTime))
            .setter(setter(Builder::submitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ComprehendMedicalAsyncJobProperties::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationTime").getter(getter(ComprehendMedicalAsyncJobProperties::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()).build();

    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<InputDataConfig> builder(MarshallingType.SDK_POJO).memberName("InputDataConfig")
            .getter(getter(ComprehendMedicalAsyncJobProperties::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(InputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("OutputDataConfig")
            .getter(getter(ComprehendMedicalAsyncJobProperties::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(ComprehendMedicalAsyncJobProperties::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(ComprehendMedicalAsyncJobProperties::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<String> MANIFEST_FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestFilePath").getter(getter(ComprehendMedicalAsyncJobProperties::manifestFilePath))
            .setter(setter(Builder::manifestFilePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestFilePath").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KMSKey")
            .getter(getter(ComprehendMedicalAsyncJobProperties::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(ComprehendMedicalAsyncJobProperties::modelVersion))
            .setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_NAME_FIELD,
            JOB_STATUS_FIELD, MESSAGE_FIELD, SUBMIT_TIME_FIELD, END_TIME_FIELD, EXPIRATION_TIME_FIELD, INPUT_DATA_CONFIG_FIELD,
            OUTPUT_DATA_CONFIG_FIELD, LANGUAGE_CODE_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, MANIFEST_FILE_PATH_FIELD, KMS_KEY_FIELD,
            MODEL_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String jobName;

    private final String jobStatus;

    private final String message;

    private final Instant submitTime;

    private final Instant endTime;

    private final Instant expirationTime;

    private final InputDataConfig inputDataConfig;

    private final OutputDataConfig outputDataConfig;

    private final String languageCode;

    private final String dataAccessRoleArn;

    private final String manifestFilePath;

    private final String kmsKey;

    private final String modelVersion;

    private ComprehendMedicalAsyncJobProperties(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.message = builder.message;
        this.submitTime = builder.submitTime;
        this.endTime = builder.endTime;
        this.expirationTime = builder.expirationTime;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.languageCode = builder.languageCode;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.manifestFilePath = builder.manifestFilePath;
        this.kmsKey = builder.kmsKey;
        this.modelVersion = builder.modelVersion;
    }

    /**
     * <p>
     * The identifier assigned to the detection job.
     * </p>
     * 
     * @return The identifier assigned to the detection job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The name that you assigned to the detection job.
     * </p>
     * 
     * @return The name that you assigned to the detection job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The current status of the detection job. If the status is <code>FAILED</code>, the <code>Message</code> field
     * shows the reason for the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the detection job. If the status is <code>FAILED</code>, the <code>Message</code>
     *         field shows the reason for the failure.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the detection job. If the status is <code>FAILED</code>, the <code>Message</code> field
     * shows the reason for the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the detection job. If the status is <code>FAILED</code>, the <code>Message</code>
     *         field shows the reason for the failure.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * A description of the status of a job.
     * </p>
     * 
     * @return A description of the status of a job.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The time that the detection job was submitted for processing.
     * </p>
     * 
     * @return The time that the detection job was submitted for processing.
     */
    public final Instant submitTime() {
        return submitTime;
    }

    /**
     * <p>
     * The time that the detection job completed.
     * </p>
     * 
     * @return The time that the detection job completed.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The date and time that job metadata is deleted from the server. Output files in your S3 bucket will not be
     * deleted. After the metadata is deleted, the job will no longer appear in the results of the
     * <code>ListEntitiesDetectionV2Job</code> or the <code>ListPHIDetectionJobs</code> operation.
     * </p>
     * 
     * @return The date and time that job metadata is deleted from the server. Output files in your S3 bucket will not
     *         be deleted. After the metadata is deleted, the job will no longer appear in the results of the
     *         <code>ListEntitiesDetectionV2Job</code> or the <code>ListPHIDetectionJobs</code> operation.
     */
    public final Instant expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * The input data configuration that you supplied when you created the detection job.
     * </p>
     * 
     * @return The input data configuration that you supplied when you created the detection job.
     */
    public final InputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * The output data configuration that you supplied when you created the detection job.
     * </p>
     * 
     * @return The output data configuration that you supplied when you created the detection job.
     */
    public final OutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The language code of the input documents.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the input documents.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code of the input documents.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the input documents.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that gives Amazon Comprehend Medical read access to your input data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that gives Amazon Comprehend Medical read access to your input data.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * The path to the file that describes the results of a batch job.
     * </p>
     * 
     * @return The path to the file that describes the results of a batch job.
     */
    public final String manifestFilePath() {
        return manifestFilePath;
    }

    /**
     * <p>
     * The AWS Key Management Service key, if any, used to encrypt the output files.
     * </p>
     * 
     * @return The AWS Key Management Service key, if any, used to encrypt the output files.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The version of the model used to analyze the documents. The version number looks like X.X.X. You can use this
     * information to track the model used for a particular batch of documents.
     * </p>
     * 
     * @return The version of the model used to analyze the documents. The version number looks like X.X.X. You can use
     *         this information to track the model used for a particular batch of documents.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(manifestFilePath());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComprehendMedicalAsyncJobProperties)) {
            return false;
        }
        ComprehendMedicalAsyncJobProperties other = (ComprehendMedicalAsyncJobProperties) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(submitTime(), other.submitTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(expirationTime(), other.expirationTime())
                && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn())
                && Objects.equals(manifestFilePath(), other.manifestFilePath()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(modelVersion(), other.modelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComprehendMedicalAsyncJobProperties").add("JobId", jobId()).add("JobName", jobName())
                .add("JobStatus", jobStatusAsString()).add("Message", message()).add("SubmitTime", submitTime())
                .add("EndTime", endTime()).add("ExpirationTime", expirationTime()).add("InputDataConfig", inputDataConfig())
                .add("OutputDataConfig", outputDataConfig()).add("LanguageCode", languageCodeAsString())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("ManifestFilePath", manifestFilePath())
                .add("KMSKey", kmsKey()).add("ModelVersion", modelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "SubmitTime":
            return Optional.ofNullable(clazz.cast(submitTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "ManifestFilePath":
            return Optional.ofNullable(clazz.cast(manifestFilePath()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComprehendMedicalAsyncJobProperties, T> g) {
        return obj -> g.apply((ComprehendMedicalAsyncJobProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComprehendMedicalAsyncJobProperties> {
        /**
         * <p>
         * The identifier assigned to the detection job.
         * </p>
         * 
         * @param jobId
         *        The identifier assigned to the detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The name that you assigned to the detection job.
         * </p>
         * 
         * @param jobName
         *        The name that you assigned to the detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The current status of the detection job. If the status is <code>FAILED</code>, the <code>Message</code> field
         * shows the reason for the failure.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the detection job. If the status is <code>FAILED</code>, the
         *        <code>Message</code> field shows the reason for the failure.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the detection job. If the status is <code>FAILED</code>, the <code>Message</code> field
         * shows the reason for the failure.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the detection job. If the status is <code>FAILED</code>, the
         *        <code>Message</code> field shows the reason for the failure.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * A description of the status of a job.
         * </p>
         * 
         * @param message
         *        A description of the status of a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The time that the detection job was submitted for processing.
         * </p>
         * 
         * @param submitTime
         *        The time that the detection job was submitted for processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTime(Instant submitTime);

        /**
         * <p>
         * The time that the detection job completed.
         * </p>
         * 
         * @param endTime
         *        The time that the detection job completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The date and time that job metadata is deleted from the server. Output files in your S3 bucket will not be
         * deleted. After the metadata is deleted, the job will no longer appear in the results of the
         * <code>ListEntitiesDetectionV2Job</code> or the <code>ListPHIDetectionJobs</code> operation.
         * </p>
         * 
         * @param expirationTime
         *        The date and time that job metadata is deleted from the server. Output files in your S3 bucket will
         *        not be deleted. After the metadata is deleted, the job will no longer appear in the results of the
         *        <code>ListEntitiesDetectionV2Job</code> or the <code>ListPHIDetectionJobs</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * <p>
         * The input data configuration that you supplied when you created the detection job.
         * </p>
         * 
         * @param inputDataConfig
         *        The input data configuration that you supplied when you created the detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(InputDataConfig inputDataConfig);

        /**
         * <p>
         * The input data configuration that you supplied when you created the detection job.
         * </p>
         * This is a convenience that creates an instance of the {@link InputDataConfig.Builder} avoiding the need to
         * create one manually via {@link InputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(InputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link InputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(InputDataConfig)
         */
        default Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(InputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * <p>
         * The output data configuration that you supplied when you created the detection job.
         * </p>
         * 
         * @param outputDataConfig
         *        The output data configuration that you supplied when you created the detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(OutputDataConfig outputDataConfig);

        /**
         * <p>
         * The output data configuration that you supplied when you created the detection job.
         * </p>
         * This is a convenience that creates an instance of the {@link OutputDataConfig.Builder} avoiding the need to
         * create one manually via {@link OutputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDataConfig(OutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(OutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(OutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The language code of the input documents.
         * </p>
         * 
         * @param languageCode
         *        The language code of the input documents.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code of the input documents.
         * </p>
         * 
         * @param languageCode
         *        The language code of the input documents.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that gives Amazon Comprehend Medical read access to your input data.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) that gives Amazon Comprehend Medical read access to your input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * The path to the file that describes the results of a batch job.
         * </p>
         * 
         * @param manifestFilePath
         *        The path to the file that describes the results of a batch job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestFilePath(String manifestFilePath);

        /**
         * <p>
         * The AWS Key Management Service key, if any, used to encrypt the output files.
         * </p>
         * 
         * @param kmsKey
         *        The AWS Key Management Service key, if any, used to encrypt the output files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The version of the model used to analyze the documents. The version number looks like X.X.X. You can use this
         * information to track the model used for a particular batch of documents.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model used to analyze the documents. The version number looks like X.X.X. You can
         *        use this information to track the model used for a particular batch of documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String jobName;

        private String jobStatus;

        private String message;

        private Instant submitTime;

        private Instant endTime;

        private Instant expirationTime;

        private InputDataConfig inputDataConfig;

        private OutputDataConfig outputDataConfig;

        private String languageCode;

        private String dataAccessRoleArn;

        private String manifestFilePath;

        private String kmsKey;

        private String modelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ComprehendMedicalAsyncJobProperties model) {
            jobId(model.jobId);
            jobName(model.jobName);
            jobStatus(model.jobStatus);
            message(model.message);
            submitTime(model.submitTime);
            endTime(model.endTime);
            expirationTime(model.expirationTime);
            inputDataConfig(model.inputDataConfig);
            outputDataConfig(model.outputDataConfig);
            languageCode(model.languageCode);
            dataAccessRoleArn(model.dataAccessRoleArn);
            manifestFilePath(model.manifestFilePath);
            kmsKey(model.kmsKey);
            modelVersion(model.modelVersion);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        @Transient
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        @Transient
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getSubmitTime() {
            return submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        @Transient
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        @Transient
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        @Transient
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getManifestFilePath() {
            return manifestFilePath;
        }

        public final void setManifestFilePath(String manifestFilePath) {
            this.manifestFilePath = manifestFilePath;
        }

        @Override
        @Transient
        public final Builder manifestFilePath(String manifestFilePath) {
            this.manifestFilePath = manifestFilePath;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        @Transient
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        @Transient
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        @Override
        public ComprehendMedicalAsyncJobProperties build() {
            return new ComprehendMedicalAsyncJobProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
