/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contextual information for an entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SNOMEDCTTrait implements SdkPojo, Serializable, ToCopyableBuilder<SNOMEDCTTrait.Builder, SNOMEDCTTrait> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SNOMEDCTTrait::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Float> SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Score")
            .getter(getter(SNOMEDCTTrait::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Float score;

    private SNOMEDCTTrait(BuilderImpl builder) {
        this.name = builder.name;
        this.score = builder.score;
    }

    /**
     * <p>
     * The name or contextual description of a detected trait.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SNOMEDCTTraitName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name or contextual description of a detected trait.
     * @see SNOMEDCTTraitName
     */
    public final SNOMEDCTTraitName name() {
        return SNOMEDCTTraitName.fromValue(name);
    }

    /**
     * <p>
     * The name or contextual description of a detected trait.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SNOMEDCTTraitName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name or contextual description of a detected trait.
     * @see SNOMEDCTTraitName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The level of confidence that Comprehend Medical has in the accuracy of a detected trait.
     * </p>
     * 
     * @return The level of confidence that Comprehend Medical has in the accuracy of a detected trait.
     */
    public final Float score() {
        return score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SNOMEDCTTrait)) {
            return false;
        }
        SNOMEDCTTrait other = (SNOMEDCTTrait) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(score(), other.score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SNOMEDCTTrait").add("Name", nameAsString()).add("Score", score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SNOMEDCTTrait, T> g) {
        return obj -> g.apply((SNOMEDCTTrait) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SNOMEDCTTrait> {
        /**
         * <p>
         * The name or contextual description of a detected trait.
         * </p>
         * 
         * @param name
         *        The name or contextual description of a detected trait.
         * @see SNOMEDCTTraitName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SNOMEDCTTraitName
         */
        Builder name(String name);

        /**
         * <p>
         * The name or contextual description of a detected trait.
         * </p>
         * 
         * @param name
         *        The name or contextual description of a detected trait.
         * @see SNOMEDCTTraitName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SNOMEDCTTraitName
         */
        Builder name(SNOMEDCTTraitName name);

        /**
         * <p>
         * The level of confidence that Comprehend Medical has in the accuracy of a detected trait.
         * </p>
         * 
         * @param score
         *        The level of confidence that Comprehend Medical has in the accuracy of a detected trait.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Float score);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Float score;

        private BuilderImpl() {
        }

        private BuilderImpl(SNOMEDCTTrait model) {
            name(model.name);
            score(model.score);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(SNOMEDCTTraitName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Float getScore() {
            return score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        @Override
        public SNOMEDCTTrait build() {
            return new SNOMEDCTTrait(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
