/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ICD10CMTraitName {
    NEGATION("NEGATION"),
    DIAGNOSIS("DIAGNOSIS"),
    SIGN("SIGN"),
    SYMPTOM("SYMPTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ICD10CMTraitName> VALUE_MAP;
    private final String value;

    private ICD10CMTraitName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ICD10CMTraitName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ICD10CMTraitName> knownValues() {
        EnumSet<ICD10CMTraitName> knownValues = EnumSet.allOf(ICD10CMTraitName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ICD10CMTraitName.class, ICD10CMTraitName::toString);
    }
}

