/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferSnomedctResponse extends ComprehendMedicalResponse implements
        ToCopyableBuilder<InferSnomedctResponse.Builder, InferSnomedctResponse> {
    private static final SdkField<List<SNOMEDCTEntity>> ENTITIES_FIELD = SdkField
            .<List<SNOMEDCTEntity>> builder(MarshallingType.LIST)
            .memberName("Entities")
            .getter(getter(InferSnomedctResponse::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SNOMEDCTEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(SNOMEDCTEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaginationToken").getter(getter(InferSnomedctResponse::paginationToken))
            .setter(setter(Builder::paginationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(InferSnomedctResponse::modelVersion)).setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final SdkField<SNOMEDCTDetails> SNOMEDCT_DETAILS_FIELD = SdkField
            .<SNOMEDCTDetails> builder(MarshallingType.SDK_POJO).memberName("SNOMEDCTDetails")
            .getter(getter(InferSnomedctResponse::snomedctDetails)).setter(setter(Builder::snomedctDetails))
            .constructor(SNOMEDCTDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNOMEDCTDetails").build()).build();

    private static final SdkField<Characters> CHARACTERS_FIELD = SdkField.<Characters> builder(MarshallingType.SDK_POJO)
            .memberName("Characters").getter(getter(InferSnomedctResponse::characters)).setter(setter(Builder::characters))
            .constructor(Characters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Characters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD,
            PAGINATION_TOKEN_FIELD, MODEL_VERSION_FIELD, SNOMEDCT_DETAILS_FIELD, CHARACTERS_FIELD));

    private final List<SNOMEDCTEntity> entities;

    private final String paginationToken;

    private final String modelVersion;

    private final SNOMEDCTDetails snomedctDetails;

    private final Characters characters;

    private InferSnomedctResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.paginationToken = builder.paginationToken;
        this.modelVersion = builder.modelVersion;
        this.snomedctDetails = builder.snomedctDetails;
        this.characters = builder.characters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The collection of medical concept entities extracted from the input text and their associated information. For
     * each entity, the response provides the entity text, the entity category, where the entity text begins and ends,
     * and the level of confidence that Comprehend Medical has in the detection and analysis. Attributes and traits of
     * the entity are also returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return The collection of medical concept entities extracted from the input text and their associated
     *         information. For each entity, the response provides the entity text, the entity category, where the
     *         entity text begins and ends, and the level of confidence that Comprehend Medical has in the detection and
     *         analysis. Attributes and traits of the entity are also returned.
     */
    public final List<SNOMEDCTEntity> entities() {
        return entities;
    }

    /**
     * <p>
     * If the result of the request is truncated, the pagination token can be used to fetch the next page of entities.
     * </p>
     * 
     * @return If the result of the request is truncated, the pagination token can be used to fetch the next page of
     *         entities.
     */
    public final String paginationToken() {
        return paginationToken;
    }

    /**
     * <p>
     * The version of the model used to analyze the documents, in the format n.n.n You can use this information to track
     * the model used for a particular batch of documents.
     * </p>
     * 
     * @return The version of the model used to analyze the documents, in the format n.n.n You can use this information
     *         to track the model used for a particular batch of documents.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The details of the SNOMED-CT revision, including the edition, language, and version date.
     * </p>
     * 
     * @return The details of the SNOMED-CT revision, including the edition, language, and version date.
     */
    public final SNOMEDCTDetails snomedctDetails() {
        return snomedctDetails;
    }

    /**
     * <p>
     * The number of characters in the input request documentation.
     * </p>
     * 
     * @return The number of characters in the input request documentation.
     */
    public final Characters characters() {
        return characters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(snomedctDetails());
        hashCode = 31 * hashCode + Objects.hashCode(characters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferSnomedctResponse)) {
            return false;
        }
        InferSnomedctResponse other = (InferSnomedctResponse) obj;
        return hasEntities() == other.hasEntities() && Objects.equals(entities(), other.entities())
                && Objects.equals(paginationToken(), other.paginationToken())
                && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(snomedctDetails(), other.snomedctDetails()) && Objects.equals(characters(), other.characters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferSnomedctResponse").add("Entities", hasEntities() ? entities() : null)
                .add("PaginationToken", paginationToken()).add("ModelVersion", modelVersion())
                .add("SNOMEDCTDetails", snomedctDetails()).add("Characters", characters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entities":
            return Optional.ofNullable(clazz.cast(entities()));
        case "PaginationToken":
            return Optional.ofNullable(clazz.cast(paginationToken()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "SNOMEDCTDetails":
            return Optional.ofNullable(clazz.cast(snomedctDetails()));
        case "Characters":
            return Optional.ofNullable(clazz.cast(characters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferSnomedctResponse, T> g) {
        return obj -> g.apply((InferSnomedctResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendMedicalResponse.Builder, SdkPojo, CopyableBuilder<Builder, InferSnomedctResponse> {
        /**
         * <p>
         * The collection of medical concept entities extracted from the input text and their associated information.
         * For each entity, the response provides the entity text, the entity category, where the entity text begins and
         * ends, and the level of confidence that Comprehend Medical has in the detection and analysis. Attributes and
         * traits of the entity are also returned.
         * </p>
         * 
         * @param entities
         *        The collection of medical concept entities extracted from the input text and their associated
         *        information. For each entity, the response provides the entity text, the entity category, where the
         *        entity text begins and ends, and the level of confidence that Comprehend Medical has in the detection
         *        and analysis. Attributes and traits of the entity are also returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<SNOMEDCTEntity> entities);

        /**
         * <p>
         * The collection of medical concept entities extracted from the input text and their associated information.
         * For each entity, the response provides the entity text, the entity category, where the entity text begins and
         * ends, and the level of confidence that Comprehend Medical has in the detection and analysis. Attributes and
         * traits of the entity are also returned.
         * </p>
         * 
         * @param entities
         *        The collection of medical concept entities extracted from the input text and their associated
         *        information. For each entity, the response provides the entity text, the entity category, where the
         *        entity text begins and ends, and the level of confidence that Comprehend Medical has in the detection
         *        and analysis. Attributes and traits of the entity are also returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(SNOMEDCTEntity... entities);

        /**
         * <p>
         * The collection of medical concept entities extracted from the input text and their associated information.
         * For each entity, the response provides the entity text, the entity category, where the entity text begins and
         * ends, and the level of confidence that Comprehend Medical has in the detection and analysis. Attributes and
         * traits of the entity are also returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<SNOMEDCTEntity>.Builder} avoiding
         * the need to create one manually via {@link List<SNOMEDCTEntity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SNOMEDCTEntity>.Builder#build()} is called immediately and
         * its result is passed to {@link #entities(List<SNOMEDCTEntity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on {@link List<SNOMEDCTEntity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(List<SNOMEDCTEntity>)
         */
        Builder entities(Consumer<SNOMEDCTEntity.Builder>... entities);

        /**
         * <p>
         * If the result of the request is truncated, the pagination token can be used to fetch the next page of
         * entities.
         * </p>
         * 
         * @param paginationToken
         *        If the result of the request is truncated, the pagination token can be used to fetch the next page of
         *        entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationToken(String paginationToken);

        /**
         * <p>
         * The version of the model used to analyze the documents, in the format n.n.n You can use this information to
         * track the model used for a particular batch of documents.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model used to analyze the documents, in the format n.n.n You can use this
         *        information to track the model used for a particular batch of documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);

        /**
         * <p>
         * The details of the SNOMED-CT revision, including the edition, language, and version date.
         * </p>
         * 
         * @param snomedctDetails
         *        The details of the SNOMED-CT revision, including the edition, language, and version date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snomedctDetails(SNOMEDCTDetails snomedctDetails);

        /**
         * <p>
         * The details of the SNOMED-CT revision, including the edition, language, and version date.
         * </p>
         * This is a convenience method that creates an instance of the {@link SNOMEDCTDetails.Builder} avoiding the
         * need to create one manually via {@link SNOMEDCTDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link SNOMEDCTDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #snomedctDetails(SNOMEDCTDetails)}.
         * 
         * @param snomedctDetails
         *        a consumer that will call methods on {@link SNOMEDCTDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snomedctDetails(SNOMEDCTDetails)
         */
        default Builder snomedctDetails(Consumer<SNOMEDCTDetails.Builder> snomedctDetails) {
            return snomedctDetails(SNOMEDCTDetails.builder().applyMutation(snomedctDetails).build());
        }

        /**
         * <p>
         * The number of characters in the input request documentation.
         * </p>
         * 
         * @param characters
         *        The number of characters in the input request documentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characters(Characters characters);

        /**
         * <p>
         * The number of characters in the input request documentation.
         * </p>
         * This is a convenience method that creates an instance of the {@link Characters.Builder} avoiding the need to
         * create one manually via {@link Characters#builder()}.
         *
         * When the {@link Consumer} completes, {@link Characters.Builder#build()} is called immediately and its result
         * is passed to {@link #characters(Characters)}.
         * 
         * @param characters
         *        a consumer that will call methods on {@link Characters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #characters(Characters)
         */
        default Builder characters(Consumer<Characters.Builder> characters) {
            return characters(Characters.builder().applyMutation(characters).build());
        }
    }

    static final class BuilderImpl extends ComprehendMedicalResponse.BuilderImpl implements Builder {
        private List<SNOMEDCTEntity> entities = DefaultSdkAutoConstructList.getInstance();

        private String paginationToken;

        private String modelVersion;

        private SNOMEDCTDetails snomedctDetails;

        private Characters characters;

        private BuilderImpl() {
        }

        private BuilderImpl(InferSnomedctResponse model) {
            super(model);
            entities(model.entities);
            paginationToken(model.paginationToken);
            modelVersion(model.modelVersion);
            snomedctDetails(model.snomedctDetails);
            characters(model.characters);
        }

        public final List<SNOMEDCTEntity.Builder> getEntities() {
            List<SNOMEDCTEntity.Builder> result = SNOMEDCTEntityListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<SNOMEDCTEntity.BuilderImpl> entities) {
            this.entities = SNOMEDCTEntityListCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<SNOMEDCTEntity> entities) {
            this.entities = SNOMEDCTEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(SNOMEDCTEntity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<SNOMEDCTEntity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> SNOMEDCTEntity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPaginationToken() {
            return paginationToken;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final SNOMEDCTDetails.Builder getSnomedctDetails() {
            return snomedctDetails != null ? snomedctDetails.toBuilder() : null;
        }

        public final void setSnomedctDetails(SNOMEDCTDetails.BuilderImpl snomedctDetails) {
            this.snomedctDetails = snomedctDetails != null ? snomedctDetails.build() : null;
        }

        @Override
        public final Builder snomedctDetails(SNOMEDCTDetails snomedctDetails) {
            this.snomedctDetails = snomedctDetails;
            return this;
        }

        public final Characters.Builder getCharacters() {
            return characters != null ? characters.toBuilder() : null;
        }

        public final void setCharacters(Characters.BuilderImpl characters) {
            this.characters = characters != null ? characters.build() : null;
        }

        @Override
        public final Builder characters(Characters characters) {
            this.characters = characters;
            return this;
        }

        @Override
        public InferSnomedctResponse build() {
            return new InferSnomedctResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
