/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ICD10CMEntityListCopier {
    static List<ICD10CMEntity> copy(Collection<? extends ICD10CMEntity> icd10CMEntityListParam) {
        List<ICD10CMEntity> list;
        if (icd10CMEntityListParam == null || icd10CMEntityListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ICD10CMEntity> modifiableList = new ArrayList<>();
            icd10CMEntityListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ICD10CMEntity> copyFromBuilder(Collection<? extends ICD10CMEntity.Builder> icd10CMEntityListParam) {
        List<ICD10CMEntity> list;
        if (icd10CMEntityListParam == null || icd10CMEntityListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ICD10CMEntity> modifiableList = new ArrayList<>();
            icd10CMEntityListParam.forEach(entry -> {
                ICD10CMEntity member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ICD10CMEntity.Builder> copyToBuilder(Collection<? extends ICD10CMEntity> icd10CMEntityListParam) {
        List<ICD10CMEntity.Builder> list;
        if (icd10CMEntityListParam == null || icd10CMEntityListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ICD10CMEntity.Builder> modifiableList = new ArrayList<>();
            icd10CMEntityListParam.forEach(entry -> {
                ICD10CMEntity.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
