/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An attribute that was extracted, but Comprehend Medical; was unable to relate to an entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnmappedAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<UnmappedAttribute.Builder, UnmappedAttribute> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(UnmappedAttribute::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Attribute> ATTRIBUTE_FIELD = SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
            .memberName("Attribute").getter(getter(UnmappedAttribute::attribute)).setter(setter(Builder::attribute))
            .constructor(Attribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ATTRIBUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Attribute attribute;

    private UnmappedAttribute(BuilderImpl builder) {
        this.type = builder.type;
        this.attribute = builder.attribute;
    }

    /**
     * <p>
     * The type of the unmapped attribute, could be one of the following values: "MEDICATION", "MEDICAL_CONDITION",
     * "ANATOMY", "TEST_AND_TREATMENT_PROCEDURE" or "PROTECTED_HEALTH_INFORMATION".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the unmapped attribute, could be one of the following values: "MEDICATION",
     *         "MEDICAL_CONDITION", "ANATOMY", "TEST_AND_TREATMENT_PROCEDURE" or "PROTECTED_HEALTH_INFORMATION".
     * @see EntityType
     */
    public final EntityType type() {
        return EntityType.fromValue(type);
    }

    /**
     * <p>
     * The type of the unmapped attribute, could be one of the following values: "MEDICATION", "MEDICAL_CONDITION",
     * "ANATOMY", "TEST_AND_TREATMENT_PROCEDURE" or "PROTECTED_HEALTH_INFORMATION".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the unmapped attribute, could be one of the following values: "MEDICATION",
     *         "MEDICAL_CONDITION", "ANATOMY", "TEST_AND_TREATMENT_PROCEDURE" or "PROTECTED_HEALTH_INFORMATION".
     * @see EntityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The specific attribute that has been extracted but not mapped to an entity.
     * </p>
     * 
     * @return The specific attribute that has been extracted but not mapped to an entity.
     */
    public final Attribute attribute() {
        return attribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnmappedAttribute)) {
            return false;
        }
        UnmappedAttribute other = (UnmappedAttribute) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(attribute(), other.attribute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnmappedAttribute").add("Type", typeAsString()).add("Attribute", attribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnmappedAttribute, T> g) {
        return obj -> g.apply((UnmappedAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnmappedAttribute> {
        /**
         * <p>
         * The type of the unmapped attribute, could be one of the following values: "MEDICATION", "MEDICAL_CONDITION",
         * "ANATOMY", "TEST_AND_TREATMENT_PROCEDURE" or "PROTECTED_HEALTH_INFORMATION".
         * </p>
         * 
         * @param type
         *        The type of the unmapped attribute, could be one of the following values: "MEDICATION",
         *        "MEDICAL_CONDITION", "ANATOMY", "TEST_AND_TREATMENT_PROCEDURE" or "PROTECTED_HEALTH_INFORMATION".
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the unmapped attribute, could be one of the following values: "MEDICATION", "MEDICAL_CONDITION",
         * "ANATOMY", "TEST_AND_TREATMENT_PROCEDURE" or "PROTECTED_HEALTH_INFORMATION".
         * </p>
         * 
         * @param type
         *        The type of the unmapped attribute, could be one of the following values: "MEDICATION",
         *        "MEDICAL_CONDITION", "ANATOMY", "TEST_AND_TREATMENT_PROCEDURE" or "PROTECTED_HEALTH_INFORMATION".
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder type(EntityType type);

        /**
         * <p>
         * The specific attribute that has been extracted but not mapped to an entity.
         * </p>
         * 
         * @param attribute
         *        The specific attribute that has been extracted but not mapped to an entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(Attribute attribute);

        /**
         * <p>
         * The specific attribute that has been extracted but not mapped to an entity.
         * </p>
         * This is a convenience that creates an instance of the {@link Attribute.Builder} avoiding the need to create
         * one manually via {@link Attribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link Attribute.Builder#build()} is called immediately and its result
         * is passed to {@link #attribute(Attribute)}.
         * 
         * @param attribute
         *        a consumer that will call methods on {@link Attribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attribute(Attribute)
         */
        default Builder attribute(Consumer<Attribute.Builder> attribute) {
            return attribute(Attribute.builder().applyMutation(attribute).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Attribute attribute;

        private BuilderImpl() {
        }

        private BuilderImpl(UnmappedAttribute model) {
            type(model.type);
            attribute(model.attribute);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(EntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Attribute.Builder getAttribute() {
            return attribute != null ? attribute.toBuilder() : null;
        }

        public final void setAttribute(Attribute.BuilderImpl attribute) {
            this.attribute = attribute != null ? attribute.build() : null;
        }

        @Override
        @Transient
        public final Builder attribute(Attribute attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public UnmappedAttribute build() {
            return new UnmappedAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
