/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehendmedical.model.Characters;
import software.amazon.awssdk.services.comprehendmedical.model.ComprehendMedicalResponse;
import software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTDetails;
import software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTEntity;
import software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTEntityListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferSnomedctResponse
extends ComprehendMedicalResponse
implements ToCopyableBuilder<Builder, InferSnomedctResponse> {
    private static final SdkField<List<SNOMEDCTEntity>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entities").getter(InferSnomedctResponse.getter(InferSnomedctResponse::entities)).setter(InferSnomedctResponse.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SNOMEDCTEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaginationToken").getter(InferSnomedctResponse.getter(InferSnomedctResponse::paginationToken)).setter(InferSnomedctResponse.setter(Builder::paginationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(InferSnomedctResponse.getter(InferSnomedctResponse::modelVersion)).setter(InferSnomedctResponse.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<SNOMEDCTDetails> SNOMEDCT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SNOMEDCTDetails").getter(InferSnomedctResponse.getter(InferSnomedctResponse::snomedctDetails)).setter(InferSnomedctResponse.setter(Builder::snomedctDetails)).constructor(SNOMEDCTDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNOMEDCTDetails").build()}).build();
    private static final SdkField<Characters> CHARACTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Characters").getter(InferSnomedctResponse.getter(InferSnomedctResponse::characters)).setter(InferSnomedctResponse.setter(Builder::characters)).constructor(Characters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Characters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD, PAGINATION_TOKEN_FIELD, MODEL_VERSION_FIELD, SNOMEDCT_DETAILS_FIELD, CHARACTERS_FIELD));
    private final List<SNOMEDCTEntity> entities;
    private final String paginationToken;
    private final String modelVersion;
    private final SNOMEDCTDetails snomedctDetails;
    private final Characters characters;

    private InferSnomedctResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.paginationToken = builder.paginationToken;
        this.modelVersion = builder.modelVersion;
        this.snomedctDetails = builder.snomedctDetails;
        this.characters = builder.characters;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<SNOMEDCTEntity> entities() {
        return this.entities;
    }

    public final String paginationToken() {
        return this.paginationToken;
    }

    public final String modelVersion() {
        return this.modelVersion;
    }

    public final SNOMEDCTDetails snomedctDetails() {
        return this.snomedctDetails;
    }

    public final Characters characters() {
        return this.characters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.snomedctDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.characters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferSnomedctResponse)) {
            return false;
        }
        InferSnomedctResponse other = (InferSnomedctResponse)((Object)obj);
        return this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities()) && Objects.equals(this.paginationToken(), other.paginationToken()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.snomedctDetails(), other.snomedctDetails()) && Objects.equals(this.characters(), other.characters());
    }

    public final String toString() {
        return ToString.builder((String)"InferSnomedctResponse").add("Entities", this.hasEntities() ? this.entities() : null).add("PaginationToken", (Object)this.paginationToken()).add("ModelVersion", (Object)this.modelVersion()).add("SNOMEDCTDetails", (Object)this.snomedctDetails()).add("Characters", (Object)this.characters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "SNOMEDCTDetails": {
                return Optional.ofNullable(clazz.cast(this.snomedctDetails()));
            }
            case "Characters": {
                return Optional.ofNullable(clazz.cast(this.characters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferSnomedctResponse, T> g) {
        return obj -> g.apply((InferSnomedctResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendMedicalResponse.BuilderImpl
    implements Builder {
        private List<SNOMEDCTEntity> entities = DefaultSdkAutoConstructList.getInstance();
        private String paginationToken;
        private String modelVersion;
        private SNOMEDCTDetails snomedctDetails;
        private Characters characters;

        private BuilderImpl() {
        }

        private BuilderImpl(InferSnomedctResponse model) {
            super(model);
            this.entities(model.entities);
            this.paginationToken(model.paginationToken);
            this.modelVersion(model.modelVersion);
            this.snomedctDetails(model.snomedctDetails);
            this.characters(model.characters);
        }

        public final List<SNOMEDCTEntity.Builder> getEntities() {
            List<SNOMEDCTEntity.Builder> result = SNOMEDCTEntityListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<SNOMEDCTEntity.BuilderImpl> entities) {
            this.entities = SNOMEDCTEntityListCopier.copyFromBuilder(entities);
        }

        @Override
        @Transient
        public final Builder entities(Collection<SNOMEDCTEntity> entities) {
            this.entities = SNOMEDCTEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entities(SNOMEDCTEntity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entities(Consumer<SNOMEDCTEntity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (SNOMEDCTEntity)((SNOMEDCTEntity.Builder)SNOMEDCTEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        @Transient
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        @Transient
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final SNOMEDCTDetails.Builder getSnomedctDetails() {
            return this.snomedctDetails != null ? this.snomedctDetails.toBuilder() : null;
        }

        public final void setSnomedctDetails(SNOMEDCTDetails.BuilderImpl snomedctDetails) {
            this.snomedctDetails = snomedctDetails != null ? snomedctDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder snomedctDetails(SNOMEDCTDetails snomedctDetails) {
            this.snomedctDetails = snomedctDetails;
            return this;
        }

        public final Characters.Builder getCharacters() {
            return this.characters != null ? this.characters.toBuilder() : null;
        }

        public final void setCharacters(Characters.BuilderImpl characters) {
            this.characters = characters != null ? characters.build() : null;
        }

        @Override
        @Transient
        public final Builder characters(Characters characters) {
            this.characters = characters;
            return this;
        }

        @Override
        public InferSnomedctResponse build() {
            return new InferSnomedctResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendMedicalResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InferSnomedctResponse> {
        public Builder entities(Collection<SNOMEDCTEntity> var1);

        public Builder entities(SNOMEDCTEntity ... var1);

        public Builder entities(Consumer<SNOMEDCTEntity.Builder> ... var1);

        public Builder paginationToken(String var1);

        public Builder modelVersion(String var1);

        public Builder snomedctDetails(SNOMEDCTDetails var1);

        default public Builder snomedctDetails(Consumer<SNOMEDCTDetails.Builder> snomedctDetails) {
            return this.snomedctDetails((SNOMEDCTDetails)((SNOMEDCTDetails.Builder)SNOMEDCTDetails.builder().applyMutation(snomedctDetails)).build());
        }

        public Builder characters(Characters var1);

        default public Builder characters(Consumer<Characters.Builder> characters) {
            return this.characters((Characters)((Characters.Builder)Characters.builder().applyMutation(characters)).build());
        }
    }
}

