/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTTraitName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SNOMEDCTTrait
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SNOMEDCTTrait> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SNOMEDCTTrait.getter(SNOMEDCTTrait::nameAsString)).setter(SNOMEDCTTrait.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Float> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Score").getter(SNOMEDCTTrait.getter(SNOMEDCTTrait::score)).setter(SNOMEDCTTrait.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Float score;

    private SNOMEDCTTrait(BuilderImpl builder) {
        this.name = builder.name;
        this.score = builder.score;
    }

    public final SNOMEDCTTraitName name() {
        return SNOMEDCTTraitName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final Float score() {
        return this.score;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SNOMEDCTTrait)) {
            return false;
        }
        SNOMEDCTTrait other = (SNOMEDCTTrait)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.score(), other.score());
    }

    public final String toString() {
        return ToString.builder((String)"SNOMEDCTTrait").add("Name", (Object)this.nameAsString()).add("Score", (Object)this.score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SNOMEDCTTrait, T> g) {
        return obj -> g.apply((SNOMEDCTTrait)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Float score;

        private BuilderImpl() {
        }

        private BuilderImpl(SNOMEDCTTrait model) {
            this.name(model.name);
            this.score(model.score);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @Transient
        public final Builder name(SNOMEDCTTraitName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Float getScore() {
            return this.score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        @Transient
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public SNOMEDCTTrait build() {
            return new SNOMEDCTTrait(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SNOMEDCTTrait> {
        public Builder name(String var1);

        public Builder name(SNOMEDCTTraitName var1);

        public Builder score(Float var1);
    }
}

