/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ICD10CMAttributeType {
    ACUITY("ACUITY"),
    DIRECTION("DIRECTION"),
    SYSTEM_ORGAN_SITE("SYSTEM_ORGAN_SITE"),
    QUALITY("QUALITY"),
    QUANTITY("QUANTITY"),
    TIME_TO_DX_NAME("TIME_TO_DX_NAME"),
    TIME_EXPRESSION("TIME_EXPRESSION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ICD10CMAttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ICD10CMAttributeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ICD10CMAttributeType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ICD10CMAttributeType> knownValues() {
        return Stream.of(ICD10CMAttributeType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

