/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehendmedical.model.ComprehendMedicalResponse;
import software.amazon.awssdk.services.comprehendmedical.model.RxNormEntity;
import software.amazon.awssdk.services.comprehendmedical.model.RxNormEntityListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferRxNormResponse
extends ComprehendMedicalResponse
implements ToCopyableBuilder<Builder, InferRxNormResponse> {
    private static final SdkField<List<RxNormEntity>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entities").getter(InferRxNormResponse.getter(InferRxNormResponse::entities)).setter(InferRxNormResponse.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RxNormEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaginationToken").getter(InferRxNormResponse.getter(InferRxNormResponse::paginationToken)).setter(InferRxNormResponse.setter(Builder::paginationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(InferRxNormResponse.getter(InferRxNormResponse::modelVersion)).setter(InferRxNormResponse.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD, PAGINATION_TOKEN_FIELD, MODEL_VERSION_FIELD));
    private final List<RxNormEntity> entities;
    private final String paginationToken;
    private final String modelVersion;

    private InferRxNormResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.paginationToken = builder.paginationToken;
        this.modelVersion = builder.modelVersion;
    }

    public boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public List<RxNormEntity> entities() {
        return this.entities;
    }

    public String paginationToken() {
        return this.paginationToken;
    }

    public String modelVersion() {
        return this.modelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferRxNormResponse)) {
            return false;
        }
        InferRxNormResponse other = (InferRxNormResponse)((Object)obj);
        return this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities()) && Objects.equals(this.paginationToken(), other.paginationToken()) && Objects.equals(this.modelVersion(), other.modelVersion());
    }

    public String toString() {
        return ToString.builder((String)"InferRxNormResponse").add("Entities", this.hasEntities() ? this.entities() : null).add("PaginationToken", (Object)this.paginationToken()).add("ModelVersion", (Object)this.modelVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferRxNormResponse, T> g) {
        return obj -> g.apply((InferRxNormResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendMedicalResponse.BuilderImpl
    implements Builder {
        private List<RxNormEntity> entities = DefaultSdkAutoConstructList.getInstance();
        private String paginationToken;
        private String modelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(InferRxNormResponse model) {
            super(model);
            this.entities(model.entities);
            this.paginationToken(model.paginationToken);
            this.modelVersion(model.modelVersion);
        }

        public final Collection<RxNormEntity.Builder> getEntities() {
            if (this.entities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entities != null ? (Collection)this.entities.stream().map(RxNormEntity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entities(Collection<RxNormEntity> entities) {
            this.entities = RxNormEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(RxNormEntity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<RxNormEntity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (RxNormEntity)((RxNormEntity.Builder)RxNormEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntities(Collection<RxNormEntity.BuilderImpl> entities) {
            this.entities = RxNormEntityListCopier.copyFromBuilder(entities);
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public InferRxNormResponse build() {
            return new InferRxNormResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendMedicalResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InferRxNormResponse> {
        public Builder entities(Collection<RxNormEntity> var1);

        public Builder entities(RxNormEntity ... var1);

        public Builder entities(Consumer<RxNormEntity.Builder> ... var1);

        public Builder paginationToken(String var1);

        public Builder modelVersion(String var1);
    }
}

