/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum EntitySubType {
    NAME("NAME"),

    DOSAGE("DOSAGE"),

    ROUTE_OR_MODE("ROUTE_OR_MODE"),

    FORM("FORM"),

    FREQUENCY("FREQUENCY"),

    DURATION("DURATION"),

    GENERIC_NAME("GENERIC_NAME"),

    BRAND_NAME("BRAND_NAME"),

    STRENGTH("STRENGTH"),

    RATE("RATE"),

    ACUITY("ACUITY"),

    TEST_NAME("TEST_NAME"),

    TEST_VALUE("TEST_VALUE"),

    TEST_UNITS("TEST_UNITS"),

    PROCEDURE_NAME("PROCEDURE_NAME"),

    TREATMENT_NAME("TREATMENT_NAME"),

    DATE("DATE"),

    AGE("AGE"),

    CONTACT_POINT("CONTACT_POINT"),

    EMAIL("EMAIL"),

    IDENTIFIER("IDENTIFIER"),

    URL("URL"),

    ADDRESS("ADDRESS"),

    PROFESSION("PROFESSION"),

    SYSTEM_ORGAN_SITE("SYSTEM_ORGAN_SITE"),

    DIRECTION("DIRECTION"),

    QUALITY("QUALITY"),

    QUANTITY("QUANTITY"),

    TIME_EXPRESSION("TIME_EXPRESSION"),

    TIME_TO_MEDICATION_NAME("TIME_TO_MEDICATION_NAME"),

    TIME_TO_DX_NAME("TIME_TO_DX_NAME"),

    TIME_TO_TEST_NAME("TIME_TO_TEST_NAME"),

    TIME_TO_PROCEDURE_NAME("TIME_TO_PROCEDURE_NAME"),

    TIME_TO_TREATMENT_NAME("TIME_TO_TREATMENT_NAME"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EntitySubType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return EntitySubType corresponding to the value
     */
    public static EntitySubType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EntitySubType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link EntitySubType}s
     */
    public static Set<EntitySubType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
