/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ICD-10-CM concepts that the entity could refer to, along with a score indicating the likelihood of the match.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ICD10CMConcept implements SdkPojo, Serializable, ToCopyableBuilder<ICD10CMConcept.Builder, ICD10CMConcept> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ICD10CMConcept::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(ICD10CMConcept::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<Float> SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Score")
            .getter(getter(ICD10CMConcept::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, CODE_FIELD,
            SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String code;

    private final Float score;

    private ICD10CMConcept(BuilderImpl builder) {
        this.description = builder.description;
        this.code = builder.code;
        this.score = builder.score;
    }

    /**
     * <p>
     * The long description of the ICD-10-CM code in the ontology.
     * </p>
     * 
     * @return The long description of the ICD-10-CM code in the ontology.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ICD-10-CM code that identifies the concept found in the knowledge base from the Centers for Disease Control.
     * </p>
     * 
     * @return The ICD-10-CM code that identifies the concept found in the knowledge base from the Centers for Disease
     *         Control.
     */
    public String code() {
        return code;
    }

    /**
     * <p>
     * The level of confidence that Amazon Comprehend Medical has that the entity is accurately linked to an ICD-10-CM
     * concept.
     * </p>
     * 
     * @return The level of confidence that Amazon Comprehend Medical has that the entity is accurately linked to an
     *         ICD-10-CM concept.
     */
    public Float score() {
        return score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ICD10CMConcept)) {
            return false;
        }
        ICD10CMConcept other = (ICD10CMConcept) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(code(), other.code())
                && Objects.equals(score(), other.score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ICD10CMConcept").add("Description", description()).add("Code", code()).add("Score", score())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ICD10CMConcept, T> g) {
        return obj -> g.apply((ICD10CMConcept) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ICD10CMConcept> {
        /**
         * <p>
         * The long description of the ICD-10-CM code in the ontology.
         * </p>
         * 
         * @param description
         *        The long description of the ICD-10-CM code in the ontology.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ICD-10-CM code that identifies the concept found in the knowledge base from the Centers for Disease
         * Control.
         * </p>
         * 
         * @param code
         *        The ICD-10-CM code that identifies the concept found in the knowledge base from the Centers for
         *        Disease Control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The level of confidence that Amazon Comprehend Medical has that the entity is accurately linked to an
         * ICD-10-CM concept.
         * </p>
         * 
         * @param score
         *        The level of confidence that Amazon Comprehend Medical has that the entity is accurately linked to an
         *        ICD-10-CM concept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Float score);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String code;

        private Float score;

        private BuilderImpl() {
        }

        private BuilderImpl(ICD10CMConcept model) {
            description(model.description);
            code(model.code);
            score(model.score);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final Float getScore() {
            return score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        public ICD10CMConcept build() {
            return new ICD10CMConcept(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
