/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehendmedical.model.Attribute;
import software.amazon.awssdk.services.comprehendmedical.model.EntityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnmappedAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UnmappedAttribute> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UnmappedAttribute.getter(UnmappedAttribute::typeAsString)).setter(UnmappedAttribute.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Attribute> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UnmappedAttribute.getter(UnmappedAttribute::attribute)).setter(UnmappedAttribute.setter(Builder::attribute)).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ATTRIBUTE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Attribute attribute;

    private UnmappedAttribute(BuilderImpl builder) {
        this.type = builder.type;
        this.attribute = builder.attribute;
    }

    public EntityType type() {
        return EntityType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Attribute attribute() {
        return this.attribute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attribute());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnmappedAttribute)) {
            return false;
        }
        UnmappedAttribute other = (UnmappedAttribute)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.attribute(), other.attribute());
    }

    public String toString() {
        return ToString.builder((String)"UnmappedAttribute").add("Type", (Object)this.typeAsString()).add("Attribute", (Object)this.attribute()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attribute()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnmappedAttribute, T> g) {
        return obj -> g.apply((UnmappedAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Attribute attribute;

        private BuilderImpl() {
        }

        private BuilderImpl(UnmappedAttribute model) {
            this.type(model.type);
            this.attribute(model.attribute);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Attribute.Builder getAttribute() {
            return this.attribute != null ? this.attribute.toBuilder() : null;
        }

        @Override
        public final Builder attribute(Attribute attribute) {
            this.attribute = attribute;
            return this;
        }

        public final void setAttribute(Attribute.BuilderImpl attribute) {
            this.attribute = attribute != null ? attribute.build() : null;
        }

        public UnmappedAttribute build() {
            return new UnmappedAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UnmappedAttribute> {
        public Builder type(String var1);

        public Builder type(EntityType var1);

        public Builder attribute(Attribute var1);

        default public Builder attribute(Consumer<Attribute.Builder> attribute) {
            return this.attribute((Attribute)((Attribute.Builder)Attribute.builder().applyMutation(attribute)).build());
        }
    }
}

