/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RelationshipType {
    EVERY("EVERY"),
    WITH_DOSAGE("WITH_DOSAGE"),
    ADMINISTERED_VIA("ADMINISTERED_VIA"),
    FOR("FOR"),
    NEGATIVE("NEGATIVE"),
    OVERLAP("OVERLAP"),
    DOSAGE("DOSAGE"),
    ROUTE_OR_MODE("ROUTE_OR_MODE"),
    FORM("FORM"),
    FREQUENCY("FREQUENCY"),
    DURATION("DURATION"),
    STRENGTH("STRENGTH"),
    RATE("RATE"),
    ACUITY("ACUITY"),
    TEST_VALUE("TEST_VALUE"),
    TEST_UNITS("TEST_UNITS"),
    DIRECTION("DIRECTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RelationshipType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RelationshipType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RelationshipType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RelationshipType> knownValues() {
        return Stream.of(RelationshipType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

