/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AttributeName {
    SIGN("SIGN"),
    SYMPTOM("SYMPTOM"),
    DIAGNOSIS("DIAGNOSIS"),
    NEGATION("NEGATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AttributeName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttributeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AttributeName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AttributeName> knownValues() {
        return Stream.of(AttributeName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

