/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeEntitiesDetectionV2JobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeEntitiesDetectionV2JobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DescribePhiDetectionJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribePhiDetectionJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesV2Request;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesV2Response;
import software.amazon.awssdk.services.comprehendmedical.model.DetectPhiRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DetectPhiResponse;
import software.amazon.awssdk.services.comprehendmedical.model.InferIcd10CmRequest;
import software.amazon.awssdk.services.comprehendmedical.model.InferIcd10CmResponse;
import software.amazon.awssdk.services.comprehendmedical.model.InferRxNormRequest;
import software.amazon.awssdk.services.comprehendmedical.model.InferRxNormResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ListEntitiesDetectionV2JobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListEntitiesDetectionV2JobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ListPhiDetectionJobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListPhiDetectionJobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StartEntitiesDetectionV2JobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartEntitiesDetectionV2JobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StartPhiDetectionJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartPhiDetectionJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopEntitiesDetectionV2JobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopEntitiesDetectionV2JobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopPhiDetectionJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopPhiDetectionJobResponse;

/**
 * Service client for accessing ComprehendMedical asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon Comprehend Medical extracts structured information from unstructured clinical text. Use these actions to gain
 * insight in your documents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ComprehendMedicalAsyncClient extends SdkClient {
    String SERVICE_NAME = "comprehendmedical";

    /**
     * Create a {@link ComprehendMedicalAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ComprehendMedicalAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ComprehendMedicalAsyncClient}.
     */
    static ComprehendMedicalAsyncClientBuilder builder() {
        return new DefaultComprehendMedicalAsyncClientBuilder();
    }

    /**
     * <p>
     * Gets the properties associated with a medical entities detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeEntitiesDetectionV2JobRequest
     * @return A Java Future containing the result of the DescribeEntitiesDetectionV2Job operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>ResourceNotFoundException The resource identified by the specified Amazon Resource Name (ARN) was not
     *         found. Check the ARN and try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.DescribeEntitiesDetectionV2Job
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEntitiesDetectionV2JobResponse> describeEntitiesDetectionV2Job(
            DescribeEntitiesDetectionV2JobRequest describeEntitiesDetectionV2JobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a medical entities detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntitiesDetectionV2JobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEntitiesDetectionV2JobRequest#builder()}
     * </p>
     *
     * @param describeEntitiesDetectionV2JobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEntitiesDetectionV2JobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEntitiesDetectionV2Job operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>ResourceNotFoundException The resource identified by the specified Amazon Resource Name (ARN) was not
     *         found. Check the ARN and try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.DescribeEntitiesDetectionV2Job
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEntitiesDetectionV2JobResponse> describeEntitiesDetectionV2Job(
            Consumer<DescribeEntitiesDetectionV2JobRequest.Builder> describeEntitiesDetectionV2JobRequest) {
        return describeEntitiesDetectionV2Job(DescribeEntitiesDetectionV2JobRequest.builder()
                .applyMutation(describeEntitiesDetectionV2JobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a protected health information (PHI) detection job. Use this operation to get
     * the status of a detection job.
     * </p>
     *
     * @param describePhiDetectionJobRequest
     * @return A Java Future containing the result of the DescribePHIDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>ResourceNotFoundException The resource identified by the specified Amazon Resource Name (ARN) was not
     *         found. Check the ARN and try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.DescribePHIDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribePHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePhiDetectionJobResponse> describePHIDetectionJob(
            DescribePhiDetectionJobRequest describePhiDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a protected health information (PHI) detection job. Use this operation to get
     * the status of a detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePhiDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePhiDetectionJobRequest#builder()}
     * </p>
     *
     * @param describePhiDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribePHIDetectionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePHIDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>ResourceNotFoundException The resource identified by the specified Amazon Resource Name (ARN) was not
     *         found. Check the ARN and try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.DescribePHIDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribePHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePhiDetectionJobResponse> describePHIDetectionJob(
            Consumer<DescribePhiDetectionJobRequest.Builder> describePhiDetectionJobRequest) {
        return describePHIDetectionJob(DescribePhiDetectionJobRequest.builder().applyMutation(describePhiDetectionJobRequest)
                .build());
    }

    /**
     * <p>
     * The <code>DetectEntities</code> operation is deprecated. You should use the <a>DetectEntitiesV2</a> operation
     * instead.
     * </p>
     * <p>
     * Inspects the clinical text for a variety of medical entities and returns specific information about them such as
     * entity category, location, and confidence score on that information .
     * </p>
     *
     * @param detectEntitiesRequest
     * @return A Java Future containing the result of the DetectEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceUnavailableException The Amazon Comprehend Medical service is temporarily unavailable. Please
     *         wait and then retry your request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>InvalidEncodingException The input text was not in valid UTF-8 character encoding. Check your text
     *         then retry your request.</li>
     *         <li>TextSizeLimitExceededException The size of the text you submitted exceeds the size limit. Reduce the
     *         size of the text or use a smaller document and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.DetectEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectEntitiesResponse> detectEntities(DetectEntitiesRequest detectEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>DetectEntities</code> operation is deprecated. You should use the <a>DetectEntitiesV2</a> operation
     * instead.
     * </p>
     * <p>
     * Inspects the clinical text for a variety of medical entities and returns specific information about them such as
     * entity category, location, and confidence score on that information .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link DetectEntitiesRequest#builder()}
     * </p>
     *
     * @param detectEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link DetectEntitiesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetectEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceUnavailableException The Amazon Comprehend Medical service is temporarily unavailable. Please
     *         wait and then retry your request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>InvalidEncodingException The input text was not in valid UTF-8 character encoding. Check your text
     *         then retry your request.</li>
     *         <li>TextSizeLimitExceededException The size of the text you submitted exceeds the size limit. Reduce the
     *         size of the text or use a smaller document and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.DetectEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectEntitiesResponse> detectEntities(Consumer<DetectEntitiesRequest.Builder> detectEntitiesRequest) {
        return detectEntities(DetectEntitiesRequest.builder().applyMutation(detectEntitiesRequest).build());
    }

    /**
     * <p>
     * Inspects the clinical text for a variety of medical entities and returns specific information about them such as
     * entity category, location, and confidence score on that information. Amazon Comprehend Medical only detects
     * medical entities in English language texts.
     * </p>
     * <p>
     * The <code>DetectEntitiesV2</code> operation replaces the <a>DetectEntities</a> operation. This new action uses a
     * different model for determining the entities in your medical text and changes the way that some entities are
     * returned in the output. You should use the <code>DetectEntitiesV2</code> operation in all new applications.
     * </p>
     * <p>
     * The <code>DetectEntitiesV2</code> operation returns the <code>Acuity</code> and <code>Direction</code> entities
     * as attributes instead of types.
     * </p>
     *
     * @param detectEntitiesV2Request
     * @return A Java Future containing the result of the DetectEntitiesV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceUnavailableException The Amazon Comprehend Medical service is temporarily unavailable. Please
     *         wait and then retry your request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>InvalidEncodingException The input text was not in valid UTF-8 character encoding. Check your text
     *         then retry your request.</li>
     *         <li>TextSizeLimitExceededException The size of the text you submitted exceeds the size limit. Reduce the
     *         size of the text or use a smaller document and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.DetectEntitiesV2
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntitiesV2"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectEntitiesV2Response> detectEntitiesV2(DetectEntitiesV2Request detectEntitiesV2Request) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects the clinical text for a variety of medical entities and returns specific information about them such as
     * entity category, location, and confidence score on that information. Amazon Comprehend Medical only detects
     * medical entities in English language texts.
     * </p>
     * <p>
     * The <code>DetectEntitiesV2</code> operation replaces the <a>DetectEntities</a> operation. This new action uses a
     * different model for determining the entities in your medical text and changes the way that some entities are
     * returned in the output. You should use the <code>DetectEntitiesV2</code> operation in all new applications.
     * </p>
     * <p>
     * The <code>DetectEntitiesV2</code> operation returns the <code>Acuity</code> and <code>Direction</code> entities
     * as attributes instead of types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectEntitiesV2Request.Builder} avoiding the need
     * to create one manually via {@link DetectEntitiesV2Request#builder()}
     * </p>
     *
     * @param detectEntitiesV2Request
     *        A {@link Consumer} that will call methods on {@link DetectEntitiesV2Request.Builder} to create a request.
     * @return A Java Future containing the result of the DetectEntitiesV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceUnavailableException The Amazon Comprehend Medical service is temporarily unavailable. Please
     *         wait and then retry your request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>InvalidEncodingException The input text was not in valid UTF-8 character encoding. Check your text
     *         then retry your request.</li>
     *         <li>TextSizeLimitExceededException The size of the text you submitted exceeds the size limit. Reduce the
     *         size of the text or use a smaller document and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.DetectEntitiesV2
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntitiesV2"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectEntitiesV2Response> detectEntitiesV2(
            Consumer<DetectEntitiesV2Request.Builder> detectEntitiesV2Request) {
        return detectEntitiesV2(DetectEntitiesV2Request.builder().applyMutation(detectEntitiesV2Request).build());
    }

    /**
     * <p>
     * Inspects the clinical text for protected health information (PHI) entities and returns the entity category,
     * location, and confidence score for each entity. Amazon Comprehend Medical only detects entities in English
     * language texts.
     * </p>
     *
     * @param detectPhiRequest
     * @return A Java Future containing the result of the DetectPHI operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceUnavailableException The Amazon Comprehend Medical service is temporarily unavailable. Please
     *         wait and then retry your request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>InvalidEncodingException The input text was not in valid UTF-8 character encoding. Check your text
     *         then retry your request.</li>
     *         <li>TextSizeLimitExceededException The size of the text you submitted exceeds the size limit. Reduce the
     *         size of the text or use a smaller document and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.DetectPHI
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectPHI" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetectPhiResponse> detectPHI(DetectPhiRequest detectPhiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects the clinical text for protected health information (PHI) entities and returns the entity category,
     * location, and confidence score for each entity. Amazon Comprehend Medical only detects entities in English
     * language texts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectPhiRequest.Builder} avoiding the need to
     * create one manually via {@link DetectPhiRequest#builder()}
     * </p>
     *
     * @param detectPhiRequest
     *        A {@link Consumer} that will call methods on {@link DetectPHIRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetectPHI operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceUnavailableException The Amazon Comprehend Medical service is temporarily unavailable. Please
     *         wait and then retry your request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>InvalidEncodingException The input text was not in valid UTF-8 character encoding. Check your text
     *         then retry your request.</li>
     *         <li>TextSizeLimitExceededException The size of the text you submitted exceeds the size limit. Reduce the
     *         size of the text or use a smaller document and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.DetectPHI
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectPHI" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetectPhiResponse> detectPHI(Consumer<DetectPhiRequest.Builder> detectPhiRequest) {
        return detectPHI(DetectPhiRequest.builder().applyMutation(detectPhiRequest).build());
    }

    /**
     * <p>
     * InferICD10CM detects medical conditions as entities listed in a patient record and links those entities to
     * normalized concept identifiers in the ICD-10-CM knowledge base from the Centers for Disease Control. Amazon
     * Comprehend Medical only detects medical entities in English language texts.
     * </p>
     *
     * @param inferIcd10CmRequest
     * @return A Java Future containing the result of the InferICD10CM operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceUnavailableException The Amazon Comprehend Medical service is temporarily unavailable. Please
     *         wait and then retry your request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>InvalidEncodingException The input text was not in valid UTF-8 character encoding. Check your text
     *         then retry your request.</li>
     *         <li>TextSizeLimitExceededException The size of the text you submitted exceeds the size limit. Reduce the
     *         size of the text or use a smaller document and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.InferICD10CM
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferICD10CM" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<InferIcd10CmResponse> inferICD10CM(InferIcd10CmRequest inferIcd10CmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * InferICD10CM detects medical conditions as entities listed in a patient record and links those entities to
     * normalized concept identifiers in the ICD-10-CM knowledge base from the Centers for Disease Control. Amazon
     * Comprehend Medical only detects medical entities in English language texts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InferIcd10CmRequest.Builder} avoiding the need to
     * create one manually via {@link InferIcd10CmRequest#builder()}
     * </p>
     *
     * @param inferIcd10CmRequest
     *        A {@link Consumer} that will call methods on {@link InferICD10CMRequest.Builder} to create a request.
     * @return A Java Future containing the result of the InferICD10CM operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceUnavailableException The Amazon Comprehend Medical service is temporarily unavailable. Please
     *         wait and then retry your request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>InvalidEncodingException The input text was not in valid UTF-8 character encoding. Check your text
     *         then retry your request.</li>
     *         <li>TextSizeLimitExceededException The size of the text you submitted exceeds the size limit. Reduce the
     *         size of the text or use a smaller document and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.InferICD10CM
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferICD10CM" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<InferIcd10CmResponse> inferICD10CM(Consumer<InferIcd10CmRequest.Builder> inferIcd10CmRequest) {
        return inferICD10CM(InferIcd10CmRequest.builder().applyMutation(inferIcd10CmRequest).build());
    }

    /**
     * <p>
     * InferRxNorm detects medications as entities listed in a patient record and links to the normalized concept
     * identifiers in the RxNorm database from the National Library of Medicine. Amazon Comprehend Medical only detects
     * medical entities in English language texts.
     * </p>
     *
     * @param inferRxNormRequest
     * @return A Java Future containing the result of the InferRxNorm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceUnavailableException The Amazon Comprehend Medical service is temporarily unavailable. Please
     *         wait and then retry your request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>InvalidEncodingException The input text was not in valid UTF-8 character encoding. Check your text
     *         then retry your request.</li>
     *         <li>TextSizeLimitExceededException The size of the text you submitted exceeds the size limit. Reduce the
     *         size of the text or use a smaller document and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.InferRxNorm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferRxNorm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<InferRxNormResponse> inferRxNorm(InferRxNormRequest inferRxNormRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * InferRxNorm detects medications as entities listed in a patient record and links to the normalized concept
     * identifiers in the RxNorm database from the National Library of Medicine. Amazon Comprehend Medical only detects
     * medical entities in English language texts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InferRxNormRequest.Builder} avoiding the need to
     * create one manually via {@link InferRxNormRequest#builder()}
     * </p>
     *
     * @param inferRxNormRequest
     *        A {@link Consumer} that will call methods on {@link InferRxNormRequest.Builder} to create a request.
     * @return A Java Future containing the result of the InferRxNorm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceUnavailableException The Amazon Comprehend Medical service is temporarily unavailable. Please
     *         wait and then retry your request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>InvalidEncodingException The input text was not in valid UTF-8 character encoding. Check your text
     *         then retry your request.</li>
     *         <li>TextSizeLimitExceededException The size of the text you submitted exceeds the size limit. Reduce the
     *         size of the text or use a smaller document and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.InferRxNorm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferRxNorm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<InferRxNormResponse> inferRxNorm(Consumer<InferRxNormRequest.Builder> inferRxNormRequest) {
        return inferRxNorm(InferRxNormRequest.builder().applyMutation(inferRxNormRequest).build());
    }

    /**
     * <p>
     * Gets a list of medical entity detection jobs that you have submitted.
     * </p>
     *
     * @param listEntitiesDetectionV2JobsRequest
     * @return A Java Future containing the result of the ListEntitiesDetectionV2Jobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>ValidationException The filter that you specified for the operation is invalid. Check the filter
     *         values that you entered and try your request again.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.ListEntitiesDetectionV2Jobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListEntitiesDetectionV2Jobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEntitiesDetectionV2JobsResponse> listEntitiesDetectionV2Jobs(
            ListEntitiesDetectionV2JobsRequest listEntitiesDetectionV2JobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of medical entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesDetectionV2JobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEntitiesDetectionV2JobsRequest#builder()}
     * </p>
     *
     * @param listEntitiesDetectionV2JobsRequest
     *        A {@link Consumer} that will call methods on {@link ListEntitiesDetectionV2JobsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListEntitiesDetectionV2Jobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>ValidationException The filter that you specified for the operation is invalid. Check the filter
     *         values that you entered and try your request again.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.ListEntitiesDetectionV2Jobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListEntitiesDetectionV2Jobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEntitiesDetectionV2JobsResponse> listEntitiesDetectionV2Jobs(
            Consumer<ListEntitiesDetectionV2JobsRequest.Builder> listEntitiesDetectionV2JobsRequest) {
        return listEntitiesDetectionV2Jobs(ListEntitiesDetectionV2JobsRequest.builder()
                .applyMutation(listEntitiesDetectionV2JobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of protected health information (PHI) detection jobs that you have submitted.
     * </p>
     *
     * @param listPhiDetectionJobsRequest
     * @return A Java Future containing the result of the ListPHIDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>ValidationException The filter that you specified for the operation is invalid. Check the filter
     *         values that you entered and try your request again.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.ListPHIDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListPHIDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPhiDetectionJobsResponse> listPHIDetectionJobs(
            ListPhiDetectionJobsRequest listPhiDetectionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of protected health information (PHI) detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhiDetectionJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPhiDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listPhiDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListPHIDetectionJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPHIDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>ValidationException The filter that you specified for the operation is invalid. Check the filter
     *         values that you entered and try your request again.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.ListPHIDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListPHIDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPhiDetectionJobsResponse> listPHIDetectionJobs(
            Consumer<ListPhiDetectionJobsRequest.Builder> listPhiDetectionJobsRequest) {
        return listPHIDetectionJobs(ListPhiDetectionJobsRequest.builder().applyMutation(listPhiDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous medical entity detection job for a collection of documents. Use the
     * <code>DescribeEntitiesDetectionV2Job</code> operation to track the status of a job.
     * </p>
     *
     * @param startEntitiesDetectionV2JobRequest
     * @return A Java Future containing the result of the StartEntitiesDetectionV2Job operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>ResourceNotFoundException The resource identified by the specified Amazon Resource Name (ARN) was not
     *         found. Check the ARN and try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.StartEntitiesDetectionV2Job
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartEntitiesDetectionV2JobResponse> startEntitiesDetectionV2Job(
            StartEntitiesDetectionV2JobRequest startEntitiesDetectionV2JobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous medical entity detection job for a collection of documents. Use the
     * <code>DescribeEntitiesDetectionV2Job</code> operation to track the status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartEntitiesDetectionV2JobRequest.Builder}
     * avoiding the need to create one manually via {@link StartEntitiesDetectionV2JobRequest#builder()}
     * </p>
     *
     * @param startEntitiesDetectionV2JobRequest
     *        A {@link Consumer} that will call methods on {@link StartEntitiesDetectionV2JobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartEntitiesDetectionV2Job operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>ResourceNotFoundException The resource identified by the specified Amazon Resource Name (ARN) was not
     *         found. Check the ARN and try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.StartEntitiesDetectionV2Job
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartEntitiesDetectionV2JobResponse> startEntitiesDetectionV2Job(
            Consumer<StartEntitiesDetectionV2JobRequest.Builder> startEntitiesDetectionV2JobRequest) {
        return startEntitiesDetectionV2Job(StartEntitiesDetectionV2JobRequest.builder()
                .applyMutation(startEntitiesDetectionV2JobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous job to detect protected health information (PHI). Use the
     * <code>DescribePHIDetectionJob</code> operation to track the status of a job.
     * </p>
     *
     * @param startPhiDetectionJobRequest
     * @return A Java Future containing the result of the StartPHIDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>ResourceNotFoundException The resource identified by the specified Amazon Resource Name (ARN) was not
     *         found. Check the ARN and try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.StartPHIDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartPHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartPhiDetectionJobResponse> startPHIDetectionJob(
            StartPhiDetectionJobRequest startPhiDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous job to detect protected health information (PHI). Use the
     * <code>DescribePHIDetectionJob</code> operation to track the status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartPhiDetectionJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartPhiDetectionJobRequest#builder()}
     * </p>
     *
     * @param startPhiDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartPHIDetectionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartPHIDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again. Contact customer support for more information about a service
     *         limit increase.</li>
     *         <li>ResourceNotFoundException The resource identified by the specified Amazon Resource Name (ARN) was not
     *         found. Check the ARN and try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.StartPHIDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartPHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartPhiDetectionJobResponse> startPHIDetectionJob(
            Consumer<StartPhiDetectionJobRequest.Builder> startPhiDetectionJobRequest) {
        return startPHIDetectionJob(StartPhiDetectionJobRequest.builder().applyMutation(startPhiDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops a medical entities detection job in progress.
     * </p>
     *
     * @param stopEntitiesDetectionV2JobRequest
     * @return A Java Future containing the result of the StopEntitiesDetectionV2Job operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>ResourceNotFoundException The resource identified by the specified Amazon Resource Name (ARN) was not
     *         found. Check the ARN and try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.StopEntitiesDetectionV2Job
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopEntitiesDetectionV2JobResponse> stopEntitiesDetectionV2Job(
            StopEntitiesDetectionV2JobRequest stopEntitiesDetectionV2JobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a medical entities detection job in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopEntitiesDetectionV2JobRequest.Builder} avoiding
     * the need to create one manually via {@link StopEntitiesDetectionV2JobRequest#builder()}
     * </p>
     *
     * @param stopEntitiesDetectionV2JobRequest
     *        A {@link Consumer} that will call methods on {@link StopEntitiesDetectionV2JobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopEntitiesDetectionV2Job operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>ResourceNotFoundException The resource identified by the specified Amazon Resource Name (ARN) was not
     *         found. Check the ARN and try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.StopEntitiesDetectionV2Job
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopEntitiesDetectionV2JobResponse> stopEntitiesDetectionV2Job(
            Consumer<StopEntitiesDetectionV2JobRequest.Builder> stopEntitiesDetectionV2JobRequest) {
        return stopEntitiesDetectionV2Job(StopEntitiesDetectionV2JobRequest.builder()
                .applyMutation(stopEntitiesDetectionV2JobRequest).build());
    }

    /**
     * <p>
     * Stops a protected health information (PHI) detection job in progress.
     * </p>
     *
     * @param stopPhiDetectionJobRequest
     * @return A Java Future containing the result of the StopPHIDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>ResourceNotFoundException The resource identified by the specified Amazon Resource Name (ARN) was not
     *         found. Check the ARN and try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.StopPHIDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopPHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopPhiDetectionJobResponse> stopPHIDetectionJob(
            StopPhiDetectionJobRequest stopPhiDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a protected health information (PHI) detection job in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopPhiDetectionJobRequest.Builder} avoiding the
     * need to create one manually via {@link StopPhiDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopPhiDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StopPHIDetectionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopPHIDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is invalid. Check your request to determine why
     *         it's invalid and then retry the request.</li>
     *         <li>ResourceNotFoundException The resource identified by the specified Amazon Resource Name (ARN) was not
     *         found. Check the ARN and try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendMedicalException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ComprehendMedicalAsyncClient.StopPHIDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopPHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopPhiDetectionJobResponse> stopPHIDetectionJob(
            Consumer<StopPhiDetectionJobRequest.Builder> stopPhiDetectionJobRequest) {
        return stopPHIDetectionJob(StopPhiDetectionJobRequest.builder().applyMutation(stopPhiDetectionJobRequest).build());
    }
}
