/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse;

public class ListDominantLanguageDetectionJobsPublisher
implements SdkPublisher<ListDominantLanguageDetectionJobsResponse> {
    private final ComprehendAsyncClient client;
    private final ListDominantLanguageDetectionJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDominantLanguageDetectionJobsPublisher(ComprehendAsyncClient client, ListDominantLanguageDetectionJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDominantLanguageDetectionJobsPublisher(ComprehendAsyncClient client, ListDominantLanguageDetectionJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDominantLanguageDetectionJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDominantLanguageDetectionJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDominantLanguageDetectionJobsResponseFetcher
    implements AsyncPageFetcher<ListDominantLanguageDetectionJobsResponse> {
        private ListDominantLanguageDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDominantLanguageDetectionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDominantLanguageDetectionJobsResponse> nextPage(ListDominantLanguageDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDominantLanguageDetectionJobsPublisher.this.client.listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsPublisher.this.firstRequest);
            }
            return ListDominantLanguageDetectionJobsPublisher.this.client.listDominantLanguageDetectionJobs((ListDominantLanguageDetectionJobsRequest)((Object)ListDominantLanguageDetectionJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

