/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxItemResult;
import software.amazon.awssdk.services.comprehend.model.BatchItemError;
import software.amazon.awssdk.services.comprehend.model.BatchItemErrorListCopier;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.ListOfDetectSyntaxResultCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDetectSyntaxResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, BatchDetectSyntaxResponse> {
    private static final SdkField<List<BatchDetectSyntaxItemResult>> RESULT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDetectSyntaxResponse.getter(BatchDetectSyntaxResponse::resultList)).setter(BatchDetectSyntaxResponse.setter(Builder::resultList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDetectSyntaxItemResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchItemError>> ERROR_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDetectSyntaxResponse.getter(BatchDetectSyntaxResponse::errorList)).setter(BatchDetectSyntaxResponse.setter(Builder::errorList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchItemError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_LIST_FIELD, ERROR_LIST_FIELD));
    private final List<BatchDetectSyntaxItemResult> resultList;
    private final List<BatchItemError> errorList;

    private BatchDetectSyntaxResponse(BuilderImpl builder) {
        super(builder);
        this.resultList = builder.resultList;
        this.errorList = builder.errorList;
    }

    public List<BatchDetectSyntaxItemResult> resultList() {
        return this.resultList;
    }

    public List<BatchItemError> errorList() {
        return this.errorList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resultList());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectSyntaxResponse)) {
            return false;
        }
        BatchDetectSyntaxResponse other = (BatchDetectSyntaxResponse)((Object)obj);
        return Objects.equals(this.resultList(), other.resultList()) && Objects.equals(this.errorList(), other.errorList());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetectSyntaxResponse").add("ResultList", this.resultList()).add("ErrorList", this.errorList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultList": {
                return Optional.ofNullable(clazz.cast(this.resultList()));
            }
            case "ErrorList": {
                return Optional.ofNullable(clazz.cast(this.errorList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectSyntaxResponse, T> g) {
        return obj -> g.apply((BatchDetectSyntaxResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<BatchDetectSyntaxItemResult> resultList = DefaultSdkAutoConstructList.getInstance();
        private List<BatchItemError> errorList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectSyntaxResponse model) {
            super(model);
            this.resultList(model.resultList);
            this.errorList(model.errorList);
        }

        public final Collection<BatchDetectSyntaxItemResult.Builder> getResultList() {
            return this.resultList != null ? (Collection)this.resultList.stream().map(BatchDetectSyntaxItemResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resultList(Collection<BatchDetectSyntaxItemResult> resultList) {
            this.resultList = ListOfDetectSyntaxResultCopier.copy(resultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(BatchDetectSyntaxItemResult ... resultList) {
            this.resultList(Arrays.asList(resultList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(Consumer<BatchDetectSyntaxItemResult.Builder> ... resultList) {
            this.resultList(Stream.of(resultList).map(c -> (BatchDetectSyntaxItemResult)((BatchDetectSyntaxItemResult.Builder)BatchDetectSyntaxItemResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResultList(Collection<BatchDetectSyntaxItemResult.BuilderImpl> resultList) {
            this.resultList = ListOfDetectSyntaxResultCopier.copyFromBuilder(resultList);
        }

        public final Collection<BatchItemError.Builder> getErrorList() {
            return this.errorList != null ? (Collection)this.errorList.stream().map(BatchItemError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errorList(Collection<BatchItemError> errorList) {
            this.errorList = BatchItemErrorListCopier.copy(errorList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorList(BatchItemError ... errorList) {
            this.errorList(Arrays.asList(errorList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorList(Consumer<BatchItemError.Builder> ... errorList) {
            this.errorList(Stream.of(errorList).map(c -> (BatchItemError)((BatchItemError.Builder)BatchItemError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrorList(Collection<BatchItemError.BuilderImpl> errorList) {
            this.errorList = BatchItemErrorListCopier.copyFromBuilder(errorList);
        }

        @Override
        public BatchDetectSyntaxResponse build() {
            return new BatchDetectSyntaxResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDetectSyntaxResponse> {
        public Builder resultList(Collection<BatchDetectSyntaxItemResult> var1);

        public Builder resultList(BatchDetectSyntaxItemResult ... var1);

        public Builder resultList(Consumer<BatchDetectSyntaxItemResult.Builder> ... var1);

        public Builder errorList(Collection<BatchItemError> var1);

        public Builder errorList(BatchItemError ... var1);

        public Builder errorList(Consumer<BatchItemError.Builder> ... var1);
    }
}

