/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter used to determine which endpoints are returned. You can filter jobs on their name, model, status, or the
 * date and time that they were created. You can only set one filter at a time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointFilter implements SdkPojo, Serializable, ToCopyableBuilder<EndpointFilter.Builder, EndpointFilter> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(EndpointFilter::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EndpointFilter::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(EndpointFilter::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(EndpointFilter::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD, STATUS_FIELD,
            CREATION_TIME_BEFORE_FIELD, CREATION_TIME_AFTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelArn;

    private final String status;

    private final Instant creationTimeBefore;

    private final Instant creationTimeAfter;

    private EndpointFilter(BuilderImpl builder) {
        this.modelArn = builder.modelArn;
        this.status = builder.status;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * Specifies the status of the endpoint being returned. Possible values are: Creating, Ready, Updating, Deleting,
     * Failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the status of the endpoint being returned. Possible values are: Creating, Ready, Updating,
     *         Deleting, Failed.
     * @see EndpointStatus
     */
    public final EndpointStatus status() {
        return EndpointStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies the status of the endpoint being returned. Possible values are: Creating, Ready, Updating, Deleting,
     * Failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the status of the endpoint being returned. Possible values are: Creating, Ready, Updating,
     *         Deleting, Failed.
     * @see EndpointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Specifies a date before which the returned endpoint or endpoints were created.
     * </p>
     * 
     * @return Specifies a date before which the returned endpoint or endpoints were created.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * Specifies a date after which the returned endpoint or endpoints were created.
     * </p>
     * 
     * @return Specifies a date after which the returned endpoint or endpoints were created.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointFilter)) {
            return false;
        }
        EndpointFilter other = (EndpointFilter) obj;
        return Objects.equals(modelArn(), other.modelArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointFilter").add("ModelArn", modelArn()).add("Status", statusAsString())
                .add("CreationTimeBefore", creationTimeBefore()).add("CreationTimeAfter", creationTimeAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTimeBefore", CREATION_TIME_BEFORE_FIELD);
        map.put("CreationTimeAfter", CREATION_TIME_AFTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointFilter, T> g) {
        return obj -> g.apply((EndpointFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointFilter> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * Specifies the status of the endpoint being returned. Possible values are: Creating, Ready, Updating,
         * Deleting, Failed.
         * </p>
         * 
         * @param status
         *        Specifies the status of the endpoint being returned. Possible values are: Creating, Ready, Updating,
         *        Deleting, Failed.
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies the status of the endpoint being returned. Possible values are: Creating, Ready, Updating,
         * Deleting, Failed.
         * </p>
         * 
         * @param status
         *        Specifies the status of the endpoint being returned. Possible values are: Creating, Ready, Updating,
         *        Deleting, Failed.
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder status(EndpointStatus status);

        /**
         * <p>
         * Specifies a date before which the returned endpoint or endpoints were created.
         * </p>
         * 
         * @param creationTimeBefore
         *        Specifies a date before which the returned endpoint or endpoints were created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * Specifies a date after which the returned endpoint or endpoints were created.
         * </p>
         * 
         * @param creationTimeAfter
         *        Specifies a date after which the returned endpoint or endpoints were created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);
    }

    static final class BuilderImpl implements Builder {
        private String modelArn;

        private String status;

        private Instant creationTimeBefore;

        private Instant creationTimeAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointFilter model) {
            modelArn(model.modelArn);
            status(model.status);
            creationTimeBefore(model.creationTimeBefore);
            creationTimeAfter(model.creationTimeAfter);
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        @Override
        public EndpointFilter build() {
            return new EndpointFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
