/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.internal.UserAgentUtils;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse;

public class ListEntityRecognizerSummariesPublisher
implements SdkPublisher<ListEntityRecognizerSummariesResponse> {
    private final ComprehendAsyncClient client;
    private final ListEntityRecognizerSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEntityRecognizerSummariesPublisher(ComprehendAsyncClient client, ListEntityRecognizerSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEntityRecognizerSummariesPublisher(ComprehendAsyncClient client, ListEntityRecognizerSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEntityRecognizerSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEntityRecognizerSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListEntityRecognizerSummariesResponseFetcher
    implements AsyncPageFetcher<ListEntityRecognizerSummariesResponse> {
        private ListEntityRecognizerSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListEntityRecognizerSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEntityRecognizerSummariesResponse> nextPage(ListEntityRecognizerSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListEntityRecognizerSummariesPublisher.this.client.listEntityRecognizerSummaries(ListEntityRecognizerSummariesPublisher.this.firstRequest);
            }
            return ListEntityRecognizerSummariesPublisher.this.client.listEntityRecognizerSummaries((ListEntityRecognizerSummariesRequest)((Object)ListEntityRecognizerSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

