/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerSummariesListCopier;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntityRecognizerSummariesResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListEntityRecognizerSummariesResponse> {
    private static final SdkField<List<EntityRecognizerSummary>> ENTITY_RECOGNIZER_SUMMARIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityRecognizerSummariesList").getter(ListEntityRecognizerSummariesResponse.getter(ListEntityRecognizerSummariesResponse::entityRecognizerSummariesList)).setter(ListEntityRecognizerSummariesResponse.setter(Builder::entityRecognizerSummariesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityRecognizerSummariesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityRecognizerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEntityRecognizerSummariesResponse.getter(ListEntityRecognizerSummariesResponse::nextToken)).setter(ListEntityRecognizerSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_RECOGNIZER_SUMMARIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEntityRecognizerSummariesResponse.memberNameToFieldInitializer();
    private final List<EntityRecognizerSummary> entityRecognizerSummariesList;
    private final String nextToken;

    private ListEntityRecognizerSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.entityRecognizerSummariesList = builder.entityRecognizerSummariesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEntityRecognizerSummariesList() {
        return this.entityRecognizerSummariesList != null && !(this.entityRecognizerSummariesList instanceof SdkAutoConstructList);
    }

    public final List<EntityRecognizerSummary> entityRecognizerSummariesList() {
        return this.entityRecognizerSummariesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityRecognizerSummariesList() ? this.entityRecognizerSummariesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntityRecognizerSummariesResponse)) {
            return false;
        }
        ListEntityRecognizerSummariesResponse other = (ListEntityRecognizerSummariesResponse)((Object)obj);
        return this.hasEntityRecognizerSummariesList() == other.hasEntityRecognizerSummariesList() && Objects.equals(this.entityRecognizerSummariesList(), other.entityRecognizerSummariesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEntityRecognizerSummariesResponse").add("EntityRecognizerSummariesList", this.hasEntityRecognizerSummariesList() ? this.entityRecognizerSummariesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityRecognizerSummariesList": {
                return Optional.ofNullable(clazz.cast(this.entityRecognizerSummariesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EntityRecognizerSummariesList", ENTITY_RECOGNIZER_SUMMARIES_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEntityRecognizerSummariesResponse, T> g) {
        return obj -> g.apply((ListEntityRecognizerSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<EntityRecognizerSummary> entityRecognizerSummariesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntityRecognizerSummariesResponse model) {
            super(model);
            this.entityRecognizerSummariesList(model.entityRecognizerSummariesList);
            this.nextToken(model.nextToken);
        }

        public final List<EntityRecognizerSummary.Builder> getEntityRecognizerSummariesList() {
            List<EntityRecognizerSummary.Builder> result = EntityRecognizerSummariesListCopier.copyToBuilder(this.entityRecognizerSummariesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntityRecognizerSummariesList(Collection<EntityRecognizerSummary.BuilderImpl> entityRecognizerSummariesList) {
            this.entityRecognizerSummariesList = EntityRecognizerSummariesListCopier.copyFromBuilder(entityRecognizerSummariesList);
        }

        @Override
        public final Builder entityRecognizerSummariesList(Collection<EntityRecognizerSummary> entityRecognizerSummariesList) {
            this.entityRecognizerSummariesList = EntityRecognizerSummariesListCopier.copy(entityRecognizerSummariesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityRecognizerSummariesList(EntityRecognizerSummary ... entityRecognizerSummariesList) {
            this.entityRecognizerSummariesList(Arrays.asList(entityRecognizerSummariesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityRecognizerSummariesList(Consumer<EntityRecognizerSummary.Builder> ... entityRecognizerSummariesList) {
            this.entityRecognizerSummariesList(Stream.of(entityRecognizerSummariesList).map(c -> (EntityRecognizerSummary)((EntityRecognizerSummary.Builder)EntityRecognizerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEntityRecognizerSummariesResponse build() {
            return new ListEntityRecognizerSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEntityRecognizerSummariesResponse> {
        public Builder entityRecognizerSummariesList(Collection<EntityRecognizerSummary> var1);

        public Builder entityRecognizerSummariesList(EntityRecognizerSummary ... var1);

        public Builder entityRecognizerSummariesList(Consumer<EntityRecognizerSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

