/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus;
import software.amazon.awssdk.services.comprehend.model.FlywheelModelEvaluationMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlywheelIterationProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlywheelIterationProperties> {
    private static final SdkField<String> FLYWHEEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlywheelArn").getter(FlywheelIterationProperties.getter(FlywheelIterationProperties::flywheelArn)).setter(FlywheelIterationProperties.setter(Builder::flywheelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelArn").build()}).build();
    private static final SdkField<String> FLYWHEEL_ITERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlywheelIterationId").getter(FlywheelIterationProperties.getter(FlywheelIterationProperties::flywheelIterationId)).setter(FlywheelIterationProperties.setter(Builder::flywheelIterationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelIterationId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(FlywheelIterationProperties.getter(FlywheelIterationProperties::creationTime)).setter(FlywheelIterationProperties.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(FlywheelIterationProperties.getter(FlywheelIterationProperties::endTime)).setter(FlywheelIterationProperties.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(FlywheelIterationProperties.getter(FlywheelIterationProperties::statusAsString)).setter(FlywheelIterationProperties.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(FlywheelIterationProperties.getter(FlywheelIterationProperties::message)).setter(FlywheelIterationProperties.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> EVALUATED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluatedModelArn").getter(FlywheelIterationProperties.getter(FlywheelIterationProperties::evaluatedModelArn)).setter(FlywheelIterationProperties.setter(Builder::evaluatedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatedModelArn").build()}).build();
    private static final SdkField<FlywheelModelEvaluationMetrics> EVALUATED_MODEL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluatedModelMetrics").getter(FlywheelIterationProperties.getter(FlywheelIterationProperties::evaluatedModelMetrics)).setter(FlywheelIterationProperties.setter(Builder::evaluatedModelMetrics)).constructor(FlywheelModelEvaluationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatedModelMetrics").build()}).build();
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainedModelArn").getter(FlywheelIterationProperties.getter(FlywheelIterationProperties::trainedModelArn)).setter(FlywheelIterationProperties.setter(Builder::trainedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainedModelArn").build()}).build();
    private static final SdkField<FlywheelModelEvaluationMetrics> TRAINED_MODEL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrainedModelMetrics").getter(FlywheelIterationProperties.getter(FlywheelIterationProperties::trainedModelMetrics)).setter(FlywheelIterationProperties.setter(Builder::trainedModelMetrics)).constructor(FlywheelModelEvaluationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainedModelMetrics").build()}).build();
    private static final SdkField<String> EVALUATION_MANIFEST_S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationManifestS3Prefix").getter(FlywheelIterationProperties.getter(FlywheelIterationProperties::evaluationManifestS3Prefix)).setter(FlywheelIterationProperties.setter(Builder::evaluationManifestS3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationManifestS3Prefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLYWHEEL_ARN_FIELD, FLYWHEEL_ITERATION_ID_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, MESSAGE_FIELD, EVALUATED_MODEL_ARN_FIELD, EVALUATED_MODEL_METRICS_FIELD, TRAINED_MODEL_ARN_FIELD, TRAINED_MODEL_METRICS_FIELD, EVALUATION_MANIFEST_S3_PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlywheelIterationProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String flywheelArn;
    private final String flywheelIterationId;
    private final Instant creationTime;
    private final Instant endTime;
    private final String status;
    private final String message;
    private final String evaluatedModelArn;
    private final FlywheelModelEvaluationMetrics evaluatedModelMetrics;
    private final String trainedModelArn;
    private final FlywheelModelEvaluationMetrics trainedModelMetrics;
    private final String evaluationManifestS3Prefix;

    private FlywheelIterationProperties(BuilderImpl builder) {
        this.flywheelArn = builder.flywheelArn;
        this.flywheelIterationId = builder.flywheelIterationId;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.message = builder.message;
        this.evaluatedModelArn = builder.evaluatedModelArn;
        this.evaluatedModelMetrics = builder.evaluatedModelMetrics;
        this.trainedModelArn = builder.trainedModelArn;
        this.trainedModelMetrics = builder.trainedModelMetrics;
        this.evaluationManifestS3Prefix = builder.evaluationManifestS3Prefix;
    }

    public final String flywheelArn() {
        return this.flywheelArn;
    }

    public final String flywheelIterationId() {
        return this.flywheelIterationId;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final FlywheelIterationStatus status() {
        return FlywheelIterationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public final String evaluatedModelArn() {
        return this.evaluatedModelArn;
    }

    public final FlywheelModelEvaluationMetrics evaluatedModelMetrics() {
        return this.evaluatedModelMetrics;
    }

    public final String trainedModelArn() {
        return this.trainedModelArn;
    }

    public final FlywheelModelEvaluationMetrics trainedModelMetrics() {
        return this.trainedModelMetrics;
    }

    public final String evaluationManifestS3Prefix() {
        return this.evaluationManifestS3Prefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flywheelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flywheelIterationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatedModelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationManifestS3Prefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlywheelIterationProperties)) {
            return false;
        }
        FlywheelIterationProperties other = (FlywheelIterationProperties)obj;
        return Objects.equals(this.flywheelArn(), other.flywheelArn()) && Objects.equals(this.flywheelIterationId(), other.flywheelIterationId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.evaluatedModelArn(), other.evaluatedModelArn()) && Objects.equals(this.evaluatedModelMetrics(), other.evaluatedModelMetrics()) && Objects.equals(this.trainedModelArn(), other.trainedModelArn()) && Objects.equals(this.trainedModelMetrics(), other.trainedModelMetrics()) && Objects.equals(this.evaluationManifestS3Prefix(), other.evaluationManifestS3Prefix());
    }

    public final String toString() {
        return ToString.builder((String)"FlywheelIterationProperties").add("FlywheelArn", (Object)this.flywheelArn()).add("FlywheelIterationId", (Object)this.flywheelIterationId()).add("CreationTime", (Object)this.creationTime()).add("EndTime", (Object)this.endTime()).add("Status", (Object)this.statusAsString()).add("Message", (Object)this.message()).add("EvaluatedModelArn", (Object)this.evaluatedModelArn()).add("EvaluatedModelMetrics", (Object)this.evaluatedModelMetrics()).add("TrainedModelArn", (Object)this.trainedModelArn()).add("TrainedModelMetrics", (Object)this.trainedModelMetrics()).add("EvaluationManifestS3Prefix", (Object)this.evaluationManifestS3Prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlywheelArn": {
                return Optional.ofNullable(clazz.cast(this.flywheelArn()));
            }
            case "FlywheelIterationId": {
                return Optional.ofNullable(clazz.cast(this.flywheelIterationId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "EvaluatedModelArn": {
                return Optional.ofNullable(clazz.cast(this.evaluatedModelArn()));
            }
            case "EvaluatedModelMetrics": {
                return Optional.ofNullable(clazz.cast(this.evaluatedModelMetrics()));
            }
            case "TrainedModelArn": {
                return Optional.ofNullable(clazz.cast(this.trainedModelArn()));
            }
            case "TrainedModelMetrics": {
                return Optional.ofNullable(clazz.cast(this.trainedModelMetrics()));
            }
            case "EvaluationManifestS3Prefix": {
                return Optional.ofNullable(clazz.cast(this.evaluationManifestS3Prefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FlywheelArn", FLYWHEEL_ARN_FIELD);
        map.put("FlywheelIterationId", FLYWHEEL_ITERATION_ID_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("EvaluatedModelArn", EVALUATED_MODEL_ARN_FIELD);
        map.put("EvaluatedModelMetrics", EVALUATED_MODEL_METRICS_FIELD);
        map.put("TrainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("TrainedModelMetrics", TRAINED_MODEL_METRICS_FIELD);
        map.put("EvaluationManifestS3Prefix", EVALUATION_MANIFEST_S3_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlywheelIterationProperties, T> g) {
        return obj -> g.apply((FlywheelIterationProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String flywheelArn;
        private String flywheelIterationId;
        private Instant creationTime;
        private Instant endTime;
        private String status;
        private String message;
        private String evaluatedModelArn;
        private FlywheelModelEvaluationMetrics evaluatedModelMetrics;
        private String trainedModelArn;
        private FlywheelModelEvaluationMetrics trainedModelMetrics;
        private String evaluationManifestS3Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(FlywheelIterationProperties model) {
            this.flywheelArn(model.flywheelArn);
            this.flywheelIterationId(model.flywheelIterationId);
            this.creationTime(model.creationTime);
            this.endTime(model.endTime);
            this.status(model.status);
            this.message(model.message);
            this.evaluatedModelArn(model.evaluatedModelArn);
            this.evaluatedModelMetrics(model.evaluatedModelMetrics);
            this.trainedModelArn(model.trainedModelArn);
            this.trainedModelMetrics(model.trainedModelMetrics);
            this.evaluationManifestS3Prefix(model.evaluationManifestS3Prefix);
        }

        public final String getFlywheelArn() {
            return this.flywheelArn;
        }

        public final void setFlywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
        }

        @Override
        public final Builder flywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
            return this;
        }

        public final String getFlywheelIterationId() {
            return this.flywheelIterationId;
        }

        public final void setFlywheelIterationId(String flywheelIterationId) {
            this.flywheelIterationId = flywheelIterationId;
        }

        @Override
        public final Builder flywheelIterationId(String flywheelIterationId) {
            this.flywheelIterationId = flywheelIterationId;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlywheelIterationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getEvaluatedModelArn() {
            return this.evaluatedModelArn;
        }

        public final void setEvaluatedModelArn(String evaluatedModelArn) {
            this.evaluatedModelArn = evaluatedModelArn;
        }

        @Override
        public final Builder evaluatedModelArn(String evaluatedModelArn) {
            this.evaluatedModelArn = evaluatedModelArn;
            return this;
        }

        public final FlywheelModelEvaluationMetrics.Builder getEvaluatedModelMetrics() {
            return this.evaluatedModelMetrics != null ? this.evaluatedModelMetrics.toBuilder() : null;
        }

        public final void setEvaluatedModelMetrics(FlywheelModelEvaluationMetrics.BuilderImpl evaluatedModelMetrics) {
            this.evaluatedModelMetrics = evaluatedModelMetrics != null ? evaluatedModelMetrics.build() : null;
        }

        @Override
        public final Builder evaluatedModelMetrics(FlywheelModelEvaluationMetrics evaluatedModelMetrics) {
            this.evaluatedModelMetrics = evaluatedModelMetrics;
            return this;
        }

        public final String getTrainedModelArn() {
            return this.trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final FlywheelModelEvaluationMetrics.Builder getTrainedModelMetrics() {
            return this.trainedModelMetrics != null ? this.trainedModelMetrics.toBuilder() : null;
        }

        public final void setTrainedModelMetrics(FlywheelModelEvaluationMetrics.BuilderImpl trainedModelMetrics) {
            this.trainedModelMetrics = trainedModelMetrics != null ? trainedModelMetrics.build() : null;
        }

        @Override
        public final Builder trainedModelMetrics(FlywheelModelEvaluationMetrics trainedModelMetrics) {
            this.trainedModelMetrics = trainedModelMetrics;
            return this;
        }

        public final String getEvaluationManifestS3Prefix() {
            return this.evaluationManifestS3Prefix;
        }

        public final void setEvaluationManifestS3Prefix(String evaluationManifestS3Prefix) {
            this.evaluationManifestS3Prefix = evaluationManifestS3Prefix;
        }

        @Override
        public final Builder evaluationManifestS3Prefix(String evaluationManifestS3Prefix) {
            this.evaluationManifestS3Prefix = evaluationManifestS3Prefix;
            return this;
        }

        public FlywheelIterationProperties build() {
            return new FlywheelIterationProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlywheelIterationProperties> {
        public Builder flywheelArn(String var1);

        public Builder flywheelIterationId(String var1);

        public Builder creationTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder status(String var1);

        public Builder status(FlywheelIterationStatus var1);

        public Builder message(String var1);

        public Builder evaluatedModelArn(String var1);

        public Builder evaluatedModelMetrics(FlywheelModelEvaluationMetrics var1);

        default public Builder evaluatedModelMetrics(Consumer<FlywheelModelEvaluationMetrics.Builder> evaluatedModelMetrics) {
            return this.evaluatedModelMetrics((FlywheelModelEvaluationMetrics)((FlywheelModelEvaluationMetrics.Builder)FlywheelModelEvaluationMetrics.builder().applyMutation(evaluatedModelMetrics)).build());
        }

        public Builder trainedModelArn(String var1);

        public Builder trainedModelMetrics(FlywheelModelEvaluationMetrics var1);

        default public Builder trainedModelMetrics(Consumer<FlywheelModelEvaluationMetrics.Builder> trainedModelMetrics) {
            return this.trainedModelMetrics((FlywheelModelEvaluationMetrics)((FlywheelModelEvaluationMetrics.Builder)FlywheelModelEvaluationMetrics.builder().applyMutation(trainedModelMetrics)).build());
        }

        public Builder evaluationManifestS3Prefix(String var1);
    }
}

