/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityTypesEvaluationMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityTypesEvaluationMetrics> {
    private static final SdkField<Double> PRECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Precision").getter(EntityTypesEvaluationMetrics.getter(EntityTypesEvaluationMetrics::precision)).setter(EntityTypesEvaluationMetrics.setter(Builder::precision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precision").build()}).build();
    private static final SdkField<Double> RECALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Recall").getter(EntityTypesEvaluationMetrics.getter(EntityTypesEvaluationMetrics::recall)).setter(EntityTypesEvaluationMetrics.setter(Builder::recall)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recall").build()}).build();
    private static final SdkField<Double> F1_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("F1Score").getter(EntityTypesEvaluationMetrics.getter(EntityTypesEvaluationMetrics::f1Score)).setter(EntityTypesEvaluationMetrics.setter(Builder::f1Score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("F1Score").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRECISION_FIELD, RECALL_FIELD, F1_SCORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double precision;
    private final Double recall;
    private final Double f1Score;

    private EntityTypesEvaluationMetrics(BuilderImpl builder) {
        this.precision = builder.precision;
        this.recall = builder.recall;
        this.f1Score = builder.f1Score;
    }

    public final Double precision() {
        return this.precision;
    }

    public final Double recall() {
        return this.recall;
    }

    public final Double f1Score() {
        return this.f1Score;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.precision());
        hashCode = 31 * hashCode + Objects.hashCode(this.recall());
        hashCode = 31 * hashCode + Objects.hashCode(this.f1Score());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityTypesEvaluationMetrics)) {
            return false;
        }
        EntityTypesEvaluationMetrics other = (EntityTypesEvaluationMetrics)obj;
        return Objects.equals(this.precision(), other.precision()) && Objects.equals(this.recall(), other.recall()) && Objects.equals(this.f1Score(), other.f1Score());
    }

    public final String toString() {
        return ToString.builder((String)"EntityTypesEvaluationMetrics").add("Precision", (Object)this.precision()).add("Recall", (Object)this.recall()).add("F1Score", (Object)this.f1Score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Precision": {
                return Optional.ofNullable(clazz.cast(this.precision()));
            }
            case "Recall": {
                return Optional.ofNullable(clazz.cast(this.recall()));
            }
            case "F1Score": {
                return Optional.ofNullable(clazz.cast(this.f1Score()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityTypesEvaluationMetrics, T> g) {
        return obj -> g.apply((EntityTypesEvaluationMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double precision;
        private Double recall;
        private Double f1Score;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityTypesEvaluationMetrics model) {
            this.precision(model.precision);
            this.recall(model.recall);
            this.f1Score(model.f1Score);
        }

        public final Double getPrecision() {
            return this.precision;
        }

        public final void setPrecision(Double precision) {
            this.precision = precision;
        }

        @Override
        public final Builder precision(Double precision) {
            this.precision = precision;
            return this;
        }

        public final Double getRecall() {
            return this.recall;
        }

        public final void setRecall(Double recall) {
            this.recall = recall;
        }

        @Override
        public final Builder recall(Double recall) {
            this.recall = recall;
            return this;
        }

        public final Double getF1Score() {
            return this.f1Score;
        }

        public final void setF1Score(Double f1Score) {
            this.f1Score = f1Score;
        }

        @Override
        public final Builder f1Score(Double f1Score) {
            this.f1Score = f1Score;
            return this;
        }

        public EntityTypesEvaluationMetrics build() {
            return new EntityTypesEvaluationMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityTypesEvaluationMetrics> {
        public Builder precision(Double var1);

        public Builder recall(Double var1);

        public Builder f1Score(Double var1);
    }
}

