/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelsRequest;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelsResponse;

public class ListFlywheelsPublisher
implements SdkPublisher<ListFlywheelsResponse> {
    private final ComprehendAsyncClient client;
    private final ListFlywheelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFlywheelsPublisher(ComprehendAsyncClient client, ListFlywheelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFlywheelsPublisher(ComprehendAsyncClient client, ListFlywheelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFlywheelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFlywheelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFlywheelsResponseFetcher
    implements AsyncPageFetcher<ListFlywheelsResponse> {
        private ListFlywheelsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlywheelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFlywheelsResponse> nextPage(ListFlywheelsResponse previousPage) {
            if (previousPage == null) {
                return ListFlywheelsPublisher.this.client.listFlywheels(ListFlywheelsPublisher.this.firstRequest);
            }
            return ListFlywheelsPublisher.this.client.listFlywheels((ListFlywheelsRequest)((Object)ListFlywheelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

